/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mc_utils;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MyNbtTextFormatter
implements TagVisitor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int field_33271 = 8;
    private static final ByteCollection SINGLE_LINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting NAME_COLOR = ChatFormatting.AQUA;
    private static final ChatFormatting STRING_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting NUMBER_COLOR = ChatFormatting.GOLD;
    private static final ChatFormatting TYPE_SUFFIX_COLOR = ChatFormatting.RED;
    private static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String KEY_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ENTRY_SEPARATOR = String.valueOf(',');
    private static final String SQUARE_OPEN_BRACKET = "[";
    private static final String SQUARE_CLOSE_BRACKET = "]";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String CURLY_OPEN_BRACKET = "{";
    private static final String CURLY_CLOSE_BRACKET = "}";
    private static final String NEW_LINE = "\n";
    private final String prefix;
    private final int indentationLevel;
    private Component result = TextComponent.f_131282_;

    public MyNbtTextFormatter(String prefix, int indentationLevel) {
        this.prefix = prefix;
        this.indentationLevel = indentationLevel;
    }

    public Component apply(Tag element) {
        element.m_142327_((TagVisitor)this);
        return this.result;
    }

    public void m_142614_(StringTag element) {
        String string = StringTag.m_129303_((String)element.m_7916_());
        String string2 = string.substring(0, 1);
        MutableComponent text = new TextComponent(string.substring(1, string.length() - 1)).m_130940_(STRING_COLOR);
        this.result = new TextComponent(string2).m_7220_((Component)text).m_130946_(string2);
    }

    public void m_141946_(ByteTag element) {
        if (element.m_7063_() == 0) {
            this.result = new TextComponent("false").m_130940_(NUMBER_COLOR);
            return;
        }
        if (element.m_7063_() == 1) {
            this.result = new TextComponent("true").m_130940_(NUMBER_COLOR);
            return;
        }
        MutableComponent text = new TextComponent("b").m_130940_(TYPE_SUFFIX_COLOR);
        this.result = new TextComponent(String.valueOf(element.m_8103_())).m_7220_((Component)text).m_130940_(NUMBER_COLOR);
    }

    public void m_142183_(ShortTag element) {
        MutableComponent text = new TextComponent("s").m_130940_(TYPE_SUFFIX_COLOR);
        this.result = new TextComponent(String.valueOf(element.m_8103_())).m_7220_((Component)text).m_130940_(NUMBER_COLOR);
    }

    public void m_142045_(IntTag element) {
        this.result = new TextComponent(String.valueOf(element.m_8103_())).m_130940_(NUMBER_COLOR);
    }

    public void m_142046_(LongTag element) {
        MutableComponent text = new TextComponent("L").m_130940_(TYPE_SUFFIX_COLOR);
        this.result = new TextComponent(String.valueOf(element.m_8103_())).m_7220_((Component)text).m_130940_(NUMBER_COLOR);
    }

    public void m_142181_(FloatTag element) {
        MutableComponent text = new TextComponent("f").m_130940_(TYPE_SUFFIX_COLOR);
        this.result = new TextComponent(String.valueOf(element.m_7057_())).m_7220_((Component)text).m_130940_(NUMBER_COLOR);
    }

    public void m_142121_(DoubleTag element) {
        MutableComponent text = new TextComponent("d").m_130940_(TYPE_SUFFIX_COLOR);
        this.result = new TextComponent(String.valueOf(element.m_7061_())).m_7220_((Component)text).m_130940_(NUMBER_COLOR);
    }

    public void m_142154_(ByteArrayTag element) {
        MutableComponent text = new TextComponent("B").m_130940_(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = new TextComponent(SQUARE_OPEN_BRACKET).m_7220_((Component)text).m_130946_(SEMICOLON);
        byte[] bs = element.m_128227_();
        for (int i = 0; i < bs.length; ++i) {
            MutableComponent mutableText2 = new TextComponent(String.valueOf(bs[i])).m_130940_(NUMBER_COLOR);
            mutableText.m_130946_(SPACE).m_7220_((Component)mutableText2).m_7220_((Component)text);
            if (i == bs.length - 1) continue;
            mutableText.m_130946_(ENTRY_SEPARATOR);
        }
        mutableText.m_130946_(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void m_142251_(IntArrayTag element) {
        MutableComponent text = new TextComponent("I").m_130940_(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = new TextComponent(SQUARE_OPEN_BRACKET).m_7220_((Component)text).m_130946_(SEMICOLON);
        int[] is = element.m_128648_();
        for (int i = 0; i < is.length; ++i) {
            mutableText.m_130946_(SPACE).m_7220_((Component)new TextComponent(String.valueOf(is[i])).m_130940_(NUMBER_COLOR));
            if (i == is.length - 1) continue;
            mutableText.m_130946_(ENTRY_SEPARATOR);
        }
        mutableText.m_130946_(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void m_142309_(LongArrayTag element) {
        MutableComponent text = new TextComponent("L").m_130940_(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = new TextComponent(SQUARE_OPEN_BRACKET).m_7220_((Component)text).m_130946_(SEMICOLON);
        long[] ls = element.m_128851_();
        for (int i = 0; i < ls.length; ++i) {
            MutableComponent text2 = new TextComponent(String.valueOf(ls[i])).m_130940_(NUMBER_COLOR);
            mutableText.m_130946_(SPACE).m_7220_((Component)text2).m_7220_((Component)text);
            if (i == ls.length - 1) continue;
            mutableText.m_130946_(ENTRY_SEPARATOR);
        }
        mutableText.m_130946_(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void m_142447_(ListTag element) {
        if (element.isEmpty()) {
            this.result = new TextComponent("[]");
            return;
        }
        if (SINGLE_LINE_ELEMENT_TYPES.contains(element.m_7264_()) && element.size() <= 8) {
            String string = ENTRY_SEPARATOR + SPACE;
            TextComponent mutableText = new TextComponent(SQUARE_OPEN_BRACKET);
            for (int i = 0; i < element.size(); ++i) {
                if (i != 0) {
                    mutableText.m_130946_(string);
                }
                mutableText.m_7220_(new MyNbtTextFormatter(this.prefix, this.indentationLevel).apply(element.get(i)));
            }
            mutableText.m_130946_(SQUARE_CLOSE_BRACKET);
            this.result = mutableText;
            return;
        }
        TextComponent string = new TextComponent(SQUARE_OPEN_BRACKET);
        for (int mutableText = 0; mutableText < element.size(); ++mutableText) {
            TextComponent i = new TextComponent(Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1)));
            i.m_7220_(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(element.get(mutableText)));
            if (mutableText != element.size() - 1) {
                i.m_130946_(ENTRY_SEPARATOR).m_130946_(SPACE);
            }
            string.m_7220_((Component)i);
        }
        if (!this.prefix.isEmpty()) {
            string.m_130946_(NEW_LINE).m_130946_(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        string.m_130946_(SQUARE_CLOSE_BRACKET);
        this.result = string;
    }

    public void m_142303_(CompoundTag compound) {
        if (compound.m_128456_()) {
            this.result = new TextComponent("{}");
            return;
        }
        TextComponent mutableText = new TextComponent(CURLY_OPEN_BRACKET);
        Collection collection = compound.m_128431_();
        ArrayList list = Lists.newArrayList((Iterable)compound.m_128431_());
        Collections.sort(list);
        collection = list;
        if (!this.prefix.isEmpty()) {
            mutableText.m_130946_(NEW_LINE);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            MutableComponent mutableText2 = new TextComponent(Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1))).m_7220_(MyNbtTextFormatter.escapeName(string)).m_130946_(KEY_VALUE_SEPARATOR).m_130946_(SPACE).m_7220_(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(compound.m_128423_(string)));
            if (iterator.hasNext()) {
                mutableText2.m_130946_(ENTRY_SEPARATOR).m_130946_(this.prefix.isEmpty() ? SPACE : NEW_LINE);
            }
            mutableText.m_7220_((Component)mutableText2);
        }
        if (!this.prefix.isEmpty()) {
            mutableText.m_130946_(NEW_LINE).m_130946_(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        mutableText.m_130946_(CURLY_CLOSE_BRACKET);
        this.result = mutableText;
    }

    protected static Component escapeName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return new TextComponent(name).m_130940_(NAME_COLOR);
        }
        String string = StringTag.m_129303_((String)name);
        String string2 = string.substring(0, 1);
        MutableComponent text = new TextComponent(string.substring(1, string.length() - 1)).m_130940_(NAME_COLOR);
        return new TextComponent(string2).m_7220_((Component)text).m_130946_(string2);
    }

    public void m_142384_(EndTag element) {
        this.result = TextComponent.f_131282_;
    }
}

