/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.miscellaneous;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.commands.PortalDebugCommands;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class GcMonitor {
    private static boolean memoryNotEnough = false;
    private static final WeakHashMap<GarbageCollectorMXBean, Long> lastCollectCount = new WeakHashMap();
    private static final LimitedLogger limitedLogger = new LimitedLogger(3);
    private static final LimitedLogger limitedLogger2 = new LimitedLogger(3);
    private static long lastUpdateTime = 0L;
    private static long lastLongPauseTime = 0L;

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        IPGlobal.preGameRenderSignal.connect(GcMonitor::update);
    }

    public static void initCommon() {
        IPGlobal.postServerTickSignal.connect(() -> {
            MinecraftServer server = MiscHelper.getServer();
            if (server != null && server.m_6982_()) {
                GcMonitor.update();
            }
        });
    }

    private static void update() {
        long currTime = System.nanoTime();
        if (currTime - lastUpdateTime > Helper.secondToNano(0.3)) {
            lastLongPauseTime = currTime;
        }
        lastUpdateTime = currTime;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long currCount = garbageCollectorMXBean.getCollectionCount();
            Long lastCount = lastCollectCount.get(garbageCollectorMXBean);
            lastCollectCount.put(garbageCollectorMXBean, currCount);
            if (lastCount == null || lastCount == currCount) continue;
            GcMonitor.check();
        }
    }

    private static void check() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double usage = (double)usedMemory / (double)maxMemory;
        double timeFromLongPause = System.nanoTime() - lastLongPauseTime;
        if (PortalDebugCommands.toMiB(freeMemory) < 300L && timeFromLongPause < (double)Helper.secondToNano(2.0)) {
            if (memoryNotEnough && !O_O.isDedicatedServer()) {
                GcMonitor.informMemoryNotEnoughClient();
            }
            limitedLogger2.invoke(() -> {
                Helper.err("Memory not enough. Try to Shrink loading distance or allocate more memory. If this happens with low loading distance, it usually indicates memory leak");
                long maxMemory1 = Runtime.getRuntime().maxMemory();
                long totalMemory1 = Runtime.getRuntime().totalMemory();
                long freeMemory1 = Runtime.getRuntime().freeMemory();
                long usedMemory1 = totalMemory1 - freeMemory1;
                Helper.err(String.format("Memory: % 2d%% %03d/%03dMB", usedMemory1 * 100L / maxMemory1, PortalDebugCommands.toMiB(usedMemory1), PortalDebugCommands.toMiB(maxMemory1)));
            });
            memoryNotEnough = true;
        } else {
            memoryNotEnough = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void informMemoryNotEnoughClient() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ != null && client.f_91074_.f_19797_ > 40) {
            limitedLogger.invoke(() -> client.f_91065_.m_93051_(ChatType.SYSTEM, (Component)new TranslatableComponent("imm_ptl.memory_not_enough").m_7220_((Component)McHelper.getLinkText("https://filmora.wondershare.com/game-recording/how-to-allocate-more-ram-to-minecraft.html")), Util.f_137441_));
        }
    }

    public static boolean isMemoryNotEnough() {
        return memoryNotEnough;
    }
}

