/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.teleportation.CrossPortalSound;

@Mixin(value={ClientLevel.class})
public class MixinClientLevel_Sound {
    @Shadow
    @Final
    private Minecraft f_104565_;

    @Inject(method={"playLocalSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaySound(double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean repeat, CallbackInfo ci) {
        if (!IPGlobal.enableCrossPortalSound) {
            return;
        }
        ClientLevel this_ = (ClientLevel)this;
        Vec3 soundPos = new Vec3(x, y, z);
        if (!this.portal_isPosNearPlayer(soundPos)) {
            SimpleSoundInstance crossPortalSound = CrossPortalSound.createCrossPortalSound(this_, sound, category, soundPos, volume, pitch);
            if (crossPortalSound != null) {
                this.portal_playSound(crossPortalSound, repeat);
                ci.cancel();
            } else if (!CrossPortalSound.isPlayerWorld(this_)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaySoundFromEntity(Player player, Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch, CallbackInfo ci) {
        if (!IPGlobal.enableCrossPortalSound) {
            return;
        }
        ClientLevel this_ = (ClientLevel)this;
        if (!this.portal_isPosNearPlayer(entity.m_20182_())) {
            SimpleSoundInstance crossPortalSound = CrossPortalSound.createCrossPortalSound(this_, sound, category, entity.m_20182_(), volume, pitch);
            if (crossPortalSound != null) {
                this.f_104565_.m_91106_().m_120367_((SoundInstance)crossPortalSound);
                ci.cancel();
            } else if (!CrossPortalSound.isPlayerWorld(this_)) {
                ci.cancel();
            }
        }
    }

    private void portal_playSound(SimpleSoundInstance sound, boolean repeat) {
        double d = this.f_104565_.f_91063_.m_109153_().m_90583_().m_82531_(sound.m_7772_(), sound.m_7780_(), sound.m_7778_());
        if (repeat && d > 100.0) {
            double e = Math.sqrt(d) / 40.0;
            this.f_104565_.m_91106_().m_120369_((SoundInstance)sound, (int)(e * 20.0));
        } else {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    private boolean portal_isPosNearPlayer(Vec3 pos) {
        ClientLevel this_ = (ClientLevel)this;
        LocalPlayer player = this.f_104565_.f_91074_;
        if (player == null) {
            return false;
        }
        if (this_ != player.f_19853_) {
            return false;
        }
        return pos.m_82557_(player.m_20182_()) < 4096.0;
    }
}

