/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.collision;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.teleportation.CollisionHelper;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEEntity {
    private Entity collidingPortal;
    private long collidingPortalActiveTickTime;
    @Shadow
    public Level f_19853_;
    @Shadow
    public boolean f_19850_;
    @Shadow
    public int f_19797_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private BlockPos f_19826_;
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    @Shadow
    public abstract AABB m_142469_();

    @Shadow
    public abstract void m_20011_(AABB var1);

    @Shadow
    protected abstract Vec3 m_20272_(Vec3 var1);

    @Shadow
    public abstract Component m_7755_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    protected abstract BlockPos m_20097_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    protected abstract void m_146912_();

    @Inject(method={"Lnet/minecraft/world/entity/Entity;tick()V"}, at={@At(value="HEAD")})
    private void onTicking(CallbackInfo ci) {
        this.tickCollidingPortal(1.0f);
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirectHandleCollisions(Entity entity, Vec3 attemptedMove) {
        if (!IPGlobal.enableServerCollision && !entity.f_19853_.m_5776_()) {
            if (entity instanceof Player) {
                return attemptedMove;
            }
            return Vec3.f_82478_;
        }
        if (attemptedMove.m_82556_() > 3600.0) {
            limitedLogger.invoke(() -> {
                Helper.err("Entity moves too fast " + entity + attemptedMove + entity.f_19853_.m_46467_());
                new Throwable().printStackTrace();
            });
            return attemptedMove;
        }
        if (this.m_20184_().m_82556_() > 2.0) {
            CollisionHelper.updateCollidingPortalNow(entity);
        }
        if (this.collidingPortal == null || !IPGlobal.crossPortalCollision) {
            return this.m_20272_(attemptedMove);
        }
        Vec3 result = CollisionHelper.handleCollisionHalfwayInPortal((Entity)this, attemptedMove, this.getCollidingPortal());
        return result;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.getCollidingPortal() instanceof EndPortalEntity) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;checkInsideBlocks()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private AABB redirectBoundingBoxInCheckingBlockCollision(Entity entity) {
        return CollisionHelper.getActiveCollisionBox(entity);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isInWall()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInsideWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.isRecentlyCollidingWithPortal()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;setPosRaw(DDD)V"}, at={@At(value="HEAD")})
    private void onSetPos(double nx, double ny, double nz, CallbackInfo ci) {
        if (this instanceof ServerPlayer && IPGlobal.teleportationDebugEnabled && (Math.abs(this.m_20185_() - nx) > 10.0 || Math.abs(this.m_20186_() - ny) > 10.0 || Math.abs(this.m_20189_() - nz) > 10.0)) {
            Helper.log(String.format("%s %s teleported from %s %s %s to %s %s %s", this.m_7755_().m_6111_(), this.f_19853_.m_46472_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_(), (int)nx, (int)ny, (int)nz));
            new Throwable().printStackTrace();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;canEnterPose(Lnet/minecraft/world/entity/Pose;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onWouldPoseNotCollide(Pose pose, CallbackInfoReturnable<Boolean> cir) {
        if (this.isRecentlyCollidingWithPortal()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getFeetBlockState()Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockState(CallbackInfoReturnable<BlockState> cir) {
        Portal collidingPortal = this.getCollidingPortal();
        Entity this_ = (Entity)this;
        if (collidingPortal != null && collidingPortal.getNormal().f_82480_ > 0.0) {
            BlockState result;
            BlockPos remoteLandingPos = new BlockPos(collidingPortal.transformPoint(this_.m_20182_()));
            Level destinationWorld = collidingPortal.getDestinationWorld();
            if (destinationWorld.m_46805_(remoteLandingPos) && !(result = destinationWorld.m_8055_(remoteLandingPos)).m_60795_()) {
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }

    @Override
    public Portal getCollidingPortal() {
        return (Portal)this.collidingPortal;
    }

    @Override
    public void tickCollidingPortal(float tickDelta) {
        Entity this_ = (Entity)this;
        if (this.collidingPortal != null) {
            if (this.collidingPortal.f_19853_ != this.f_19853_) {
                this.collidingPortal = null;
            } else {
                AABB stretchedBoundingBox = CollisionHelper.getStretchedBoundingBox(this_);
                if (!stretchedBoundingBox.m_82400_(0.5).m_82381_(this.collidingPortal.m_142469_())) {
                    this.collidingPortal = null;
                }
            }
            if (Math.abs((long)this.f_19797_ - this.collidingPortalActiveTickTime) >= 3L) {
                this.collidingPortal = null;
            }
        }
        if (this.f_19853_.f_46443_) {
            IPMcHelper.onClientEntityTick(this_);
        }
    }

    @Override
    public void notifyCollidingWithPortal(Entity portal) {
        Entity this_ = (Entity)this;
        this.collidingPortal = portal;
        this.collidingPortalActiveTickTime = this.f_19797_;
        ((Portal)portal).onCollidingWithEntity(this_);
    }

    @Override
    public boolean isRecentlyCollidingWithPortal() {
        return (long)this.f_19797_ - this.collidingPortalActiveTickTime < 20L;
    }

    @Override
    public void portal_unsetRemoved() {
        this.m_146912_();
    }

    @Override
    public void ip_setPositionWithoutTriggeringCallback(Vec3 newPos) {
        this.f_19825_ = newPos;
        this.f_19826_ = new BlockPos(newPos);
    }
}

