/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.container_gui;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPMcHelper;

@Mixin(value={ContainerOpenersCounter.class})
public abstract class MixinContainerOpenersCounter {
    @Shadow
    protected abstract boolean m_142718_(Player var1);

    @Inject(method={"getOpenCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void getOpenCount(Level level, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            boolean noPortalNearby = IPMcHelper.getNearbyPortalList(level, Vec3.m_82512_((Vec3i)pos), 32.0, p -> true).isEmpty();
            if (!noPortalNearby) {
                cir.setReturnValue((Object)this.ip_getOpenCountCheckingAllPlayer(serverWorld, pos));
            }
        }
    }

    private int ip_getOpenCountCheckingAllPlayer(ServerLevel serverWorld, BlockPos pos) {
        int count = 0;
        for (ServerPlayer player : serverWorld.m_142572_().m_6846_().m_11314_()) {
            if (!this.m_142718_((Player)player)) continue;
            ++count;
        }
        return count;
    }
}

