/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.IPModMainClient;
import qouteall.imm_ptl.core.compat.IPModCompatibilityWarning;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.render.LoadingIndicatorRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.imm_ptl.core.render.RendererUsingFrameBuffer;
import qouteall.imm_ptl.core.render.RendererUsingStencil;
import qouteall.imm_ptl.core.render.ShaderCodeTransformation;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModEntryClient {
    @SubscribeEvent
    public static void initPortalRenderers(EntityRenderersEvent.RegisterRenderers event) {
        Arrays.stream(new EntityType[]{(EntityType)IPRegistry.PORTAL.get(), (EntityType)IPRegistry.NETHER_PORTAL_NEW.get(), (EntityType)IPRegistry.END_PORTAL.get(), (EntityType)IPRegistry.MIRROR.get(), (EntityType)IPRegistry.BREAKABLE_MIRROR.get(), (EntityType)IPRegistry.GLOBAL_TRACKED_PORTAL.get(), (EntityType)IPRegistry.BORDER_PORTAL.get(), (EntityType)IPRegistry.END_FLOOR_PORTAL.get(), (EntityType)IPRegistry.GENERAL_BREAKABLE_PORTAL.get()}).peek(Validate::notNull).forEach(entityType -> event.registerEntityRenderer(entityType, PortalEntityRenderer::new));
        event.registerEntityRenderer((EntityType)IPRegistry.LOADING_INDICATOR.get(), LoadingIndicatorRenderer::new);
    }

    public static void onInitializeClient() {
        FMLJavaModLoadingContext.get().getModEventBus().register(IPModMainClient.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(IPModEntryClient.class);
        boolean isSodiumPresent = ModList.get().isLoaded("rubidium");
        if (isSodiumPresent) {
            Helper.log("Rubidium is present");
            SodiumInterface.invoker = new SodiumInterface.OnSodiumPresent();
            IPGlobal.clientTaskList.addTask(MyTaskList.oneShotTask(() -> {
                if (IPGlobal.enableWarning) {
                    CHelper.printChat((Component)new TranslatableComponent("imm_ptl.sodium_warning").m_7220_(IPMcHelper.getDisableWarningText()));
                }
            }));
        } else {
            Helper.log("Rubidium is not present");
        }
        if (ModList.get().isLoaded("oculus")) {
            Helper.log("Oculus is present");
            IrisInterface.invoker = new IrisInterface.OnIrisPresent();
            ExperimentalIrisPortalRenderer.init();
            IPGlobal.clientTaskList.addTask(MyTaskList.oneShotTask(() -> {
                if (IPGlobal.enableWarning) {
                    CHelper.printChat((Component)new TranslatableComponent("imm_ptl.iris_warning").m_7220_(IPMcHelper.getDisableWarningText()));
                }
            }));
        } else {
            Helper.log("Oculus is not present");
        }
        IPModCompatibilityWarning.initClient();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Minecraft.m_91087_().execute(() -> {
                ShaderCodeTransformation.init();
                MyRenderHelper.init();
                IPCGlobal.rendererUsingStencil = new RendererUsingStencil();
                IPCGlobal.rendererUsingFrameBuffer = new RendererUsingFrameBuffer();
                IPCGlobal.renderer = IPCGlobal.rendererUsingStencil;
                IPCGlobal.clientTeleportationManager = new ClientTeleportationManager();
            });
        }
    }
}

