/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.forge.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.q_misc_util.dimension.DimId;

public class PlayerAction {
    private ResourceKey<Level> dimension;
    private ServerboundPlayerActionPacket packet;

    public PlayerAction(ResourceKey<Level> dimension, ServerboundPlayerActionPacket packet) {
        this.dimension = dimension;
        this.packet = packet;
    }

    public PlayerAction(FriendlyByteBuf buf) {
        this.dimension = DimId.readWorldId(buf, false);
        this.packet = new ServerboundPlayerActionPacket(buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        DimId.writeWorldId(buf, this.dimension, true);
        buf.m_130068_((Enum)this.packet.m_134285_());
        buf.m_130064_(this.packet.m_134281_());
        buf.writeByte(this.packet.m_134284_().m_122411_());
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> IPGlobal.serverTaskList.addTask(() -> {
            BlockManipulationServer.processBreakBlock(this.dimension, this.packet, ctx.getSender());
            return true;
        }));
        ctx.setPacketHandled(true);
        return true;
    }
}

