/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.forge.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.q_misc_util.dimension.DimId;

public class RightClick {
    private ResourceKey<Level> dimension;
    private ServerboundUseItemOnPacket packet;

    public RightClick(ResourceKey<Level> dimension, ServerboundUseItemOnPacket packet) {
        this.dimension = dimension;
        this.packet = packet;
    }

    public RightClick(FriendlyByteBuf buf) {
        this.dimension = DimId.readWorldId(buf, false);
        this.packet = new ServerboundUseItemOnPacket(buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        DimId.writeWorldId(buf, this.dimension, true);
        buf.m_130068_((Enum)this.packet.m_134703_());
        buf.m_130062_(this.packet.m_134706_());
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> IPGlobal.serverTaskList.addTask(() -> {
            BlockManipulationServer.processRightClickBlock(this.dimension, this.packet, ctx.getSender());
            return true;
        }));
        ctx.setPacketHandled(true);
        return true;
    }
}

