/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class BreakableMirror
extends Mirror {
    public static EntityType<BreakableMirror> entityType = (EntityType)IPRegistry.BREAKABLE_MIRROR.get();
    public IntBox wallArea;
    public boolean unbreakable = false;

    public BreakableMirror(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.wallArea = new IntBox(new BlockPos(tag.m_128451_("boxXL"), tag.m_128451_("boxYL"), tag.m_128451_("boxZL")), new BlockPos(tag.m_128451_("boxXH"), tag.m_128451_("boxYH"), tag.m_128451_("boxZH")));
        if (tag.m_128441_("unbreakable")) {
            this.unbreakable = tag.m_128471_("unbreakable");
        }
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("boxXL", this.wallArea.l.m_123341_());
        tag.m_128405_("boxYL", this.wallArea.l.m_123342_());
        tag.m_128405_("boxZL", this.wallArea.l.m_123343_());
        tag.m_128405_("boxXH", this.wallArea.h.m_123341_());
        tag.m_128405_("boxYH", this.wallArea.h.m_123342_());
        tag.m_128405_("boxZH", this.wallArea.h.m_123343_());
        tag.m_128379_("unbreakable", this.unbreakable);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.unbreakable && this.f_19853_.m_46467_() % 10L == (long)(this.m_142049_() % 10)) {
            this.checkWallIntegrity();
        }
    }

    @Override
    public boolean isPortalValid() {
        return super.isPortalValid() && this.wallArea != null;
    }

    private void checkWallIntegrity() {
        boolean wallValid = this.wallArea.fastStream().allMatch(blockPos -> BreakableMirror.isGlass(this.f_19853_, blockPos));
        if (!wallValid) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public static boolean isGlass(Level world, BlockPos blockPos) {
        Block block = world.m_8055_(blockPos).m_60734_();
        return block instanceof GlassBlock || block instanceof IronBarsBlock || block instanceof StainedGlassBlock;
    }

    private static boolean isGlassPane(Level world, BlockPos blockPos) {
        Block block = world.m_8055_(blockPos).m_60734_();
        return block instanceof IronBarsBlock;
    }

    public static BreakableMirror createMirror(ServerLevel world, BlockPos glassPos, Direction facing) {
        if (!BreakableMirror.isGlass((Level)world, glassPos)) {
            return null;
        }
        boolean isPane = BreakableMirror.isGlassPane((Level)world, glassPos);
        if (facing.m_122434_() == Direction.Axis.Y && isPane) {
            return null;
        }
        IntBox wallArea = Helper.expandRectangle(glassPos, blockPos -> BreakableMirror.isGlass((Level)world, blockPos) && isPane == BreakableMirror.isGlassPane((Level)world, blockPos), facing.m_122434_());
        BreakableMirror breakableMirror = (BreakableMirror)entityType.m_20615_((Level)world);
        double distanceToCenter = isPane ? 0.0625 : 0.5;
        AABB wallBox = McHelper.getWallBox((Level)world, wallArea);
        if (wallBox == null) {
            wallBox = wallArea.toRealNumberBox();
        }
        Vec3 pos = Helper.getBoxSurfaceInversed(wallBox, facing.m_122424_()).m_82399_();
        pos = Helper.putCoordinate(pos, facing.m_122434_(), Helper.getCoordinate(wallArea.getCenterVec().m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(distanceToCenter)), facing.m_122434_()));
        breakableMirror.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        breakableMirror.setDestination(pos);
        breakableMirror.dimensionTo = world.m_46472_();
        Tuple<Direction, Direction> dirs = Helper.getPerpendicularDirections(facing);
        Vec3 boxSize = Helper.getBoxSize(wallBox);
        double width = Helper.getCoordinate(boxSize, ((Direction)dirs.m_14418_()).m_122434_());
        double height = Helper.getCoordinate(boxSize, ((Direction)dirs.m_14419_()).m_122434_());
        breakableMirror.axisW = Vec3.m_82528_((Vec3i)((Direction)dirs.m_14418_()).m_122436_());
        breakableMirror.axisH = Vec3.m_82528_((Vec3i)((Direction)dirs.m_14419_()).m_122436_());
        breakableMirror.width = width;
        breakableMirror.height = height;
        breakableMirror.wallArea = wallArea;
        BreakableMirror.breakIntersectedMirror(breakableMirror);
        world.m_7967_((Entity)breakableMirror);
        return breakableMirror;
    }

    private static void breakIntersectedMirror(BreakableMirror newMirror) {
        McHelper.getEntitiesNearby(newMirror, BreakableMirror.class, 20.0).stream().filter(mirror1 -> mirror1.getNormal().m_82526_(newMirror.getNormal()) > 0.5).filter(mirror1 -> IntBox.getIntersect(mirror1.wallArea, newMirror.wallArea) != null).filter(mirror -> mirror != newMirror).forEach(e -> e.m_142687_(Entity.RemovalReason.KILLED));
    }
}

