/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.IPEntityEventListenableEntity;
import qouteall.imm_ptl.core.platform_specific.forge.networking.IPMessage;
import qouteall.imm_ptl.core.platform_specific.forge.networking.Spawn_Entity;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.PortalAnimation;
import qouteall.imm_ptl.core.portal.PortalAnimationManagement;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.render.FrustumCuller;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.teleportation.CollisionHelper;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.BoxPredicate;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RotationHelper;
import qouteall.q_misc_util.my_util.SignalArged;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class Portal
extends Entity
implements PortalLike,
IPEntityEventListenableEntity {
    public static final UUID nullUUID = Util.f_137441_;
    private static final AABB nullBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public double width = 0.0;
    public double height = 0.0;
    public Vec3 axisW;
    public Vec3 axisH;
    public ResourceKey<Level> dimensionTo;
    public Vec3 destination;
    public boolean teleportable = true;
    @Nullable
    public UUID specificPlayerId;
    @Nullable
    public GeometryPortalShape specialShape;
    private AABB exactBoundingBoxCache;
    private AABB boundingBoxCache;
    private Vec3 normal;
    private Vec3 contentDirection;
    public double cullableXStart = 0.0;
    public double cullableXEnd = 0.0;
    public double cullableYStart = 0.0;
    public double cullableYEnd = 0.0;
    @Nullable
    public Quaternion rotation;
    public double scaling = 1.0;
    public boolean teleportChangesScale = true;
    protected boolean teleportChangesGravity = false;
    private boolean interactable = true;
    PortalExtension extension;
    @Nullable
    public String portalTag;
    public boolean isGlobalPortal = false;
    public boolean fuseView = false;
    public boolean renderingMergable = false;
    public boolean hasCrossPortalCollision = true;
    public boolean doRenderPlayer = true;
    @Nullable
    public List<String> commandsOnTeleported;
    @OnlyIn(value=Dist.CLIENT)
    PortalRenderInfo portalRenderInfo;
    protected PortalAnimation animation = PortalAnimation.defaultAnimation;
    public static final SignalArged<Portal> clientPortalTickSignal = new SignalArged();
    public static final SignalArged<Portal> serverPortalTickSignal = new SignalArged();
    public static final SignalArged<Portal> portalCacheUpdateSignal = new SignalArged();
    public static final SignalArged<Portal> portalDisposeSignal = new SignalArged();
    public static final SignalBiArged<Portal, CompoundTag> readPortalDataSignal = new SignalBiArged();
    public static final SignalBiArged<Portal, CompoundTag> writePortalDataSignal = new SignalBiArged();

    public Portal(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void ip_onEntityPositionUpdated() {
        this.updateCache();
    }

    @Override
    public void ip_onRemoved(Entity.RemovalReason reason) {
        portalDisposeSignal.emit(this);
    }

    @Override
    public Vec3 transformPoint(Vec3 pos) {
        Vec3 localPos = pos.m_82546_(this.getOriginPos());
        return this.transformLocalVec(localPos).m_82549_(this.getDestPos());
    }

    @Override
    public Vec3 transformLocalVec(Vec3 localVec) {
        return this.transformLocalVecNonScale(localVec).m_82490_(this.scaling);
    }

    public Vec3 getNormal() {
        if (this.normal == null) {
            this.normal = this.axisW.m_82537_(this.axisH).m_82541_();
        }
        return this.normal;
    }

    public Vec3 getContentDirection() {
        if (this.contentDirection == null) {
            this.contentDirection = this.transformLocalVecNonScale(this.getNormal().m_82490_(-1.0));
        }
        return this.contentDirection;
    }

    public void onEntityTeleportedOnServer(Entity entity) {
        if (this.commandsOnTeleported != null) {
            McHelper.invokeCommandAs(entity, this.commandsOnTeleported);
        }
    }

    public void reloadAndSyncToClient() {
        Validate.isTrue((!this.isGlobalPortal ? 1 : 0) != 0);
        Validate.isTrue((!this.f_19853_.m_5776_() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.updateCache();
        CompoundTag customData = new CompoundTag();
        this.m_7380_(customData);
        Packet packet = McRemoteProcedureCall.createPacketToSendToClient("qouteall.imm_ptl.core.portal.Portal.RemoteCallables.acceptPortalDataSync", this.f_19853_.m_46472_(), this.m_142049_(), this.m_20182_(), customData);
        McHelper.sendToTrackers(this, packet);
    }

    public void updateCache() {
        if (this.axisW == null) {
            return;
        }
        boolean updates = this.boundingBoxCache != null || this.exactBoundingBoxCache != null || this.normal != null || this.contentDirection != null;
        this.boundingBoxCache = null;
        this.exactBoundingBoxCache = null;
        this.normal = null;
        this.contentDirection = null;
        if (updates) {
            portalCacheUpdateSignal.emit(this);
        }
    }

    public AABB m_142469_() {
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.m_142242_();
            if (this.boundingBoxCache == null) {
                Helper.err("Cannot calc portal bounding box");
                return nullBox;
            }
        }
        return this.boundingBoxCache;
    }

    @Override
    public Vec3 getOriginPos() {
        return this.m_20182_();
    }

    @Override
    public Vec3 getDestPos() {
        return this.destination;
    }

    public void setOriginPos(Vec3 pos) {
        this.m_146884_(pos);
    }

    public void setDestinationDimension(ResourceKey<Level> dim) {
        this.dimensionTo = dim;
    }

    public void setDestination(Vec3 destination) {
        this.destination = destination;
        this.updateCache();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderViewAreaMesh(Vec3 portalPosRelativeToCamera, Consumer<Vec3> vertexOutput) {
        if (this instanceof Mirror) {
            boolean offsetFront = IrisInterface.invoker.isShaders() || IPGlobal.pureMirror;
            double mirrorOffset = offsetFront ? 0.01 : -0.01;
            portalPosRelativeToCamera = portalPosRelativeToCamera.m_82549_(((Mirror)this).getNormal().m_82490_(mirrorOffset));
        }
        ViewAreaRenderer.generateViewAreaTriangles(this, portalPosRelativeToCamera, vertexOutput);
    }

    @Override
    public boolean isFuseView() {
        return this.fuseView;
    }

    public boolean isRenderingMergable() {
        return this.renderingMergable;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public Level getOriginWorld() {
        return this.f_19853_;
    }

    @Override
    public Level getDestWorld() {
        return this.getDestinationWorld();
    }

    @Override
    public ResourceKey<Level> getDestDim() {
        return this.dimensionTo;
    }

    @Override
    public double getScale() {
        return this.scaling;
    }

    @Override
    public boolean getIsGlobal() {
        return this.isGlobalPortal;
    }

    public boolean canTeleportEntity(Entity entity) {
        if (!this.teleportable) {
            return false;
        }
        if (entity instanceof Portal) {
            return false;
        }
        if (entity instanceof Player ? this.specificPlayerId != null && !entity.m_142081_().equals(this.specificPlayerId) : this.specificPlayerId != null && !this.specificPlayerId.equals(nullUUID)) {
            return false;
        }
        return entity.m_6072_();
    }

    @Override
    @Nullable
    public Quaternion getRotation() {
        return this.rotation;
    }

    public DQuaternion getRotationD() {
        if (this.rotation == null) {
            return DQuaternion.identity;
        }
        return DQuaternion.fromMcQuaternion(this.rotation);
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public void setOrientationAndSize(Vec3 newAxisW, Vec3 newAxisH, double newWidth, double newHeight) {
        this.setOrientation(newAxisW, newAxisH);
        this.width = newWidth;
        this.height = newHeight;
        this.updateCache();
    }

    public void setOrientation(Vec3 newAxisW, Vec3 newAxisH) {
        this.axisW = newAxisW.m_82541_();
        this.axisH = newAxisH.m_82541_();
        this.updateCache();
    }

    public void setRotationTransformation(@Nullable Quaternion quaternion) {
        this.rotation = quaternion;
        this.updateCache();
    }

    public void setRotationTransformationD(@Nullable DQuaternion quaternion) {
        if (quaternion == null) {
            this.setRotationTransformation(null);
        } else {
            this.setRotationTransformation(quaternion.toMcQuaternion());
        }
    }

    public void setScaleTransformation(double newScale) {
        this.scaling = newScale;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.animation = compoundTag.m_128441_("animation") ? PortalAnimation.fromNbt(compoundTag.m_128469_("animation")) : PortalAnimation.defaultAnimation;
        this.width = compoundTag.m_128459_("width");
        this.height = compoundTag.m_128459_("height");
        this.axisW = Helper.getVec3d(compoundTag, "axisW").m_82541_();
        this.axisH = Helper.getVec3d(compoundTag, "axisH").m_82541_();
        this.dimensionTo = DimId.getWorldId(compoundTag, "dimensionTo", this.f_19853_.f_46443_);
        this.destination = Helper.getVec3d(compoundTag, "destination");
        this.specificPlayerId = Helper.getUuid(compoundTag, "specificPlayer");
        if (compoundTag.m_128441_("specialShape")) {
            this.specialShape = new GeometryPortalShape(compoundTag.m_128437_("specialShape", 6));
            if (this.specialShape.triangles.isEmpty()) {
                this.specialShape = null;
            } else if (!this.specialShape.isValid()) {
                Helper.err("Portal shape invalid ");
                this.specialShape = null;
            }
        } else {
            this.specialShape = null;
        }
        if (compoundTag.m_128441_("teleportable")) {
            this.teleportable = compoundTag.m_128471_("teleportable");
        }
        if (compoundTag.m_128441_("cullableXStart")) {
            this.cullableXStart = compoundTag.m_128459_("cullableXStart");
            this.cullableXEnd = compoundTag.m_128459_("cullableXEnd");
            this.cullableYStart = compoundTag.m_128459_("cullableYStart");
            this.cullableYEnd = compoundTag.m_128459_("cullableYEnd");
            this.cullableXEnd = Math.min(this.cullableXEnd, this.width / 2.0);
            this.cullableXStart = Math.max(this.cullableXStart, -this.width / 2.0);
            this.cullableYEnd = Math.min(this.cullableYEnd, this.height / 2.0);
            this.cullableYStart = Math.max(this.cullableYStart, -this.height / 2.0);
        } else if (this.specialShape != null) {
            this.cullableXStart = 0.0;
            this.cullableXEnd = 0.0;
            this.cullableYStart = 0.0;
            this.cullableYEnd = 0.0;
        } else {
            this.initDefaultCullableRange();
        }
        this.rotation = compoundTag.m_128441_("rotationA") ? new Quaternion(compoundTag.m_128457_("rotationB"), compoundTag.m_128457_("rotationC"), compoundTag.m_128457_("rotationD"), compoundTag.m_128457_("rotationA")) : null;
        if (compoundTag.m_128441_("interactable")) {
            this.interactable = compoundTag.m_128471_("interactable");
        }
        if (compoundTag.m_128441_("scale")) {
            this.scaling = compoundTag.m_128459_("scale");
        }
        if (compoundTag.m_128441_("teleportChangesScale")) {
            this.teleportChangesScale = compoundTag.m_128471_("teleportChangesScale");
        }
        if (compoundTag.m_128441_("teleportChangesGravity")) {
            this.teleportChangesGravity = compoundTag.m_128471_("teleportChangesGravity");
        }
        if (compoundTag.m_128441_("portalTag")) {
            this.portalTag = compoundTag.m_128461_("portalTag");
        }
        if (compoundTag.m_128441_("fuseView")) {
            this.fuseView = compoundTag.m_128471_("fuseView");
        }
        if (compoundTag.m_128441_("renderingMergable")) {
            this.renderingMergable = compoundTag.m_128471_("renderingMergable");
        }
        if (compoundTag.m_128441_("hasCrossPortalCollision")) {
            this.hasCrossPortalCollision = compoundTag.m_128471_("hasCrossPortalCollision");
        }
        if (compoundTag.m_128441_("commandsOnTeleported")) {
            ListTag list = compoundTag.m_128437_("commandsOnTeleported", 8);
            this.commandsOnTeleported = list.stream().map(t -> ((StringTag)t).m_7916_()).collect(Collectors.toList());
        } else {
            this.commandsOnTeleported = null;
        }
        if (compoundTag.m_128441_("doRenderPlayer")) {
            this.doRenderPlayer = compoundTag.m_128471_("doRenderPlayer");
        }
        readPortalDataSignal.emit(this, compoundTag);
        this.updateCache();
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128365_("animation", (Tag)this.animation.toNbt());
        compoundTag.m_128347_("width", this.width);
        compoundTag.m_128347_("height", this.height);
        Helper.putVec3d(compoundTag, "axisW", this.axisW);
        Helper.putVec3d(compoundTag, "axisH", this.axisH);
        DimId.putWorldId(compoundTag, "dimensionTo", this.dimensionTo);
        Helper.putVec3d(compoundTag, "destination", this.getDestPos());
        if (this.specificPlayerId != null) {
            Helper.putUuid(compoundTag, "specificPlayer", this.specificPlayerId);
        }
        if (this.specialShape != null) {
            compoundTag.m_128365_("specialShape", (Tag)this.specialShape.writeToTag());
        }
        compoundTag.m_128379_("teleportable", this.teleportable);
        if (this.specialShape == null) {
            this.initDefaultCullableRange();
        }
        compoundTag.m_128347_("cullableXStart", this.cullableXStart);
        compoundTag.m_128347_("cullableXEnd", this.cullableXEnd);
        compoundTag.m_128347_("cullableYStart", this.cullableYStart);
        compoundTag.m_128347_("cullableYEnd", this.cullableYEnd);
        if (this.rotation != null) {
            compoundTag.m_128347_("rotationA", (double)this.rotation.m_80156_());
            compoundTag.m_128347_("rotationB", (double)this.rotation.m_80140_());
            compoundTag.m_128347_("rotationC", (double)this.rotation.m_80150_());
            compoundTag.m_128347_("rotationD", (double)this.rotation.m_80153_());
        }
        compoundTag.m_128379_("interactable", this.interactable);
        compoundTag.m_128347_("scale", this.scaling);
        compoundTag.m_128379_("teleportChangesScale", this.teleportChangesScale);
        compoundTag.m_128379_("teleportChangesGravity", this.teleportChangesGravity);
        if (this.portalTag != null) {
            compoundTag.m_128359_("portalTag", this.portalTag);
        }
        compoundTag.m_128379_("fuseView", this.fuseView);
        compoundTag.m_128379_("renderingMergable", this.renderingMergable);
        compoundTag.m_128379_("hasCrossPortalCollision", this.hasCrossPortalCollision);
        compoundTag.m_128379_("doRenderPlayer", this.doRenderPlayer);
        if (this.commandsOnTeleported != null) {
            ListTag list = new ListTag();
            for (String command : this.commandsOnTeleported) {
                list.add((Object)StringTag.m_129297_((String)command));
            }
            compoundTag.m_128365_("commandsOnTeleported", (Tag)list);
        }
        writePortalDataSignal.emit(this, compoundTag);
    }

    private void initDefaultCullableRange() {
        this.cullableXStart = -(this.width / 2.0);
        this.cullableXEnd = this.width / 2.0;
        this.cullableYStart = -(this.height / 2.0);
        this.cullableYEnd = this.height / 2.0;
    }

    public void initCullableRange(double cullableXStart, double cullableXEnd, double cullableYStart, double cullableYEnd) {
        this.cullableXStart = Math.min(cullableXStart, cullableXEnd);
        this.cullableXEnd = Math.max(cullableXStart, cullableXEnd);
        this.cullableYStart = Math.min(cullableYStart, cullableYEnd);
        this.cullableYEnd = Math.max(cullableYStart, cullableYEnd);
    }

    public Packet<?> m_5654_() {
        return IPMessage.INSTANCE.toVanillaPacket((Object)new Spawn_Entity(this), NetworkDirection.PLAY_TO_CLIENT);
    }

    public boolean m_6459_(ServerPlayer spectator) {
        if (this.specificPlayerId == null) {
            return true;
        }
        return spectator.m_142081_().equals(this.specificPlayerId);
    }

    public void m_8119_() {
        if (this.m_142469_().equals((Object)nullBox)) {
            Helper.err("Abnormal bounding box " + this);
        }
        if (this.f_19853_.f_46443_) {
            clientPortalTickSignal.emit(this);
        } else {
            if (!this.isPortalValid()) {
                Helper.log("removed invalid portal" + this);
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            serverPortalTickSignal.emit(this);
        }
        CollisionHelper.notifyCollidingPortals(this);
        super.m_8119_();
    }

    protected AABB m_142242_() {
        if (this.axisW == null) {
            this.boundingBoxCache = null;
            return nullBox;
        }
        if (this.boundingBoxCache == null) {
            double w = this.width;
            double h = this.height;
            if (this.shouldLimitBoundingBox()) {
                w = Math.min(this.width, 64.0);
                h = Math.min(this.height, 64.0);
            }
            this.boundingBoxCache = new AABB(this.getPointInPlane(w / 2.0, h / 2.0).m_82549_(this.getNormal().m_82490_(0.2)), this.getPointInPlane(-w / 2.0, -h / 2.0).m_82549_(this.getNormal().m_82490_(-0.2))).m_82367_(new AABB(this.getPointInPlane(-w / 2.0, h / 2.0).m_82549_(this.getNormal().m_82490_(0.2)), this.getPointInPlane(w / 2.0, -h / 2.0).m_82549_(this.getNormal().m_82490_(-0.2))));
        }
        return this.boundingBoxCache;
    }

    protected boolean shouldLimitBoundingBox() {
        return !this.getIsGlobal();
    }

    public AABB getExactBoundingBox() {
        if (this.exactBoundingBoxCache == null) {
            this.exactBoundingBoxCache = new AABB(this.getPointInPlane(this.width / 2.0, this.height / 2.0).m_82549_(this.getNormal().m_82490_(0.02)), this.getPointInPlane(-this.width / 2.0, -this.height / 2.0).m_82549_(this.getNormal().m_82490_(-0.02))).m_82367_(new AABB(this.getPointInPlane(-this.width / 2.0, this.height / 2.0).m_82549_(this.getNormal().m_82490_(0.02)), this.getPointInPlane(this.width / 2.0, -this.height / 2.0).m_82549_(this.getNormal().m_82490_(-0.02))));
        }
        return this.exactBoundingBoxCache;
    }

    public void m_6478_(MoverType type, Vec3 movement) {
    }

    public boolean isPortalValid() {
        boolean valid;
        boolean bl = valid = this.dimensionTo != null && this.width != 0.0 && this.height != 0.0 && this.axisW != null && this.axisH != null && this.getDestPos() != null && this.axisW.m_82556_() > 0.9 && this.axisH.m_82556_() > 0.9 && this.m_20186_() > (double)(McHelper.getMinY((LevelAccessor)this.f_19853_) - 100);
        if (valid) {
            if (this.f_19853_ instanceof ServerLevel) {
                ServerLevel destWorld = this.m_20194_().m_129880_(this.dimensionTo);
                if (destWorld == null) {
                    Helper.err("Portal Dest Dimension Missing " + this.dimensionTo.m_135782_());
                    return false;
                }
                boolean inWorldBorder = destWorld.m_6857_().m_61937_(new BlockPos(this.getDestPos()));
                if (!inWorldBorder) {
                    Helper.err("Destination out of World Border " + this);
                    return false;
                }
            }
            if (this.f_19853_.m_5776_()) {
                return this.isPortalValidClient();
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPortalValidClient() {
        boolean contains = ClientWorldLoader.getServerDimensions().contains(this.dimensionTo);
        if (!contains) {
            Helper.err("Client Portal Dest Dimension Missing " + this.dimensionTo.m_135782_());
        }
        return contains;
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.m_142081_();
    }

    public String toString() {
        return String.format("%s{%s,%s,(%s %s %s %s)->(%s %s %s %s)%s%s%s}", this.getClass().getSimpleName(), this.m_142049_(), Direction.m_122366_((double)this.getNormal().f_82479_, (double)this.getNormal().f_82480_, (double)this.getNormal().f_82481_), this.f_19853_.m_46472_().m_135782_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_(), this.dimensionTo.m_135782_(), (int)this.getDestPos().f_82479_, (int)this.getDestPos().f_82480_, (int)this.getDestPos().f_82481_, this.specificPlayerId != null ? ",specificAccessor:" + this.specificPlayerId.toString() : "", this.hasScaling() ? ",scale:" + this.scaling : "", this.portalTag != null ? "," + this.portalTag : "");
    }

    public void transformVelocity(Entity entity) {
        Vec3 oldVelocity = McHelper.getWorldVelocity(entity);
        if (PehkuiInterface.invoker.isPehkuiPresent()) {
            if (this.teleportChangesScale) {
                McHelper.setWorldVelocity(entity, this.transformLocalVecNonScale(oldVelocity));
            } else {
                McHelper.setWorldVelocity(entity, this.transformLocalVec(oldVelocity));
            }
        } else {
            McHelper.setWorldVelocity(entity, this.transformLocalVec(oldVelocity));
        }
        int maxVelocity = 15;
        if (oldVelocity.m_82553_() > 15.0) {
            McHelper.setWorldVelocity(entity, McHelper.getWorldVelocity(entity).m_82541_().m_82490_(15.0));
        }
        if (entity instanceof AbstractMinecart && oldVelocity.m_82556_() < 0.5) {
            McHelper.setWorldVelocity(entity, McHelper.getWorldVelocity(entity).m_82490_(2.0));
        }
    }

    public double getDistanceToPlane(Vec3 pos) {
        return pos.m_82546_(this.getOriginPos()).m_82526_(this.getNormal());
    }

    public boolean isInFrontOfPortal(Vec3 pos) {
        return this.getDistanceToPlane(pos) > 0.0;
    }

    public Vec3 getPointInPlane(double xInPlane, double yInPlane) {
        return this.getOriginPos().m_82549_(this.getPointInPlaneLocal(xInPlane, yInPlane));
    }

    public Vec3 getPointInPlaneLocal(double xInPlane, double yInPlane) {
        return this.axisW.m_82490_(xInPlane).m_82549_(this.axisH.m_82490_(yInPlane));
    }

    public Vec3 getPointInPlaneLocalClamped(double xInPlane, double yInPlane) {
        return this.getPointInPlaneLocal(Mth.m_14008_((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0)), Mth.m_14008_((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0)));
    }

    public Vec3[] getFourVerticesLocal(double shrinkFactor) {
        Vec3[] vertices = new Vec3[]{this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, this.height / 2.0 - shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, this.height / 2.0 - shrinkFactor)};
        return vertices;
    }

    private Vec3[] getFourVerticesLocalRotated(double shrinkFactor) {
        Vec3[] fourVerticesLocal = this.getFourVerticesLocal(shrinkFactor);
        fourVerticesLocal[0] = this.transformLocalVec(fourVerticesLocal[0]);
        fourVerticesLocal[1] = this.transformLocalVec(fourVerticesLocal[1]);
        fourVerticesLocal[2] = this.transformLocalVec(fourVerticesLocal[2]);
        fourVerticesLocal[3] = this.transformLocalVec(fourVerticesLocal[3]);
        return fourVerticesLocal;
    }

    private Vec3[] getFourVerticesLocalCullable(double shrinkFactor) {
        Vec3[] vertices = new Vec3[]{this.getPointInPlaneLocal(this.cullableXEnd - shrinkFactor, this.cullableYStart + shrinkFactor), this.getPointInPlaneLocal(this.cullableXStart + shrinkFactor, this.cullableYStart + shrinkFactor), this.getPointInPlaneLocal(this.cullableXEnd - shrinkFactor, this.cullableYEnd - shrinkFactor), this.getPointInPlaneLocal(this.cullableXStart + shrinkFactor, this.cullableYEnd - shrinkFactor)};
        return vertices;
    }

    public final Vec3 transformPointRough(Vec3 pos) {
        Vec3 offset = this.getDestPos().m_82546_(this.getOriginPos());
        return pos.m_82549_(offset);
    }

    public Vec3 transformLocalVecNonScale(Vec3 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        Vector3f temp = new Vector3f(localVec);
        temp.m_122251_(this.rotation);
        return new Vec3(temp);
    }

    public Vec3 inverseTransformLocalVecNonScale(Vec3 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        Vector3f temp = new Vector3f(localVec);
        Quaternion r = new Quaternion(this.rotation);
        r.m_80157_();
        temp.m_122251_(r);
        return new Vec3(temp);
    }

    @Override
    public Vec3 inverseTransformLocalVec(Vec3 localVec) {
        return this.inverseTransformLocalVecNonScale(localVec).m_82490_(1.0 / this.scaling);
    }

    @Override
    public Vec3 inverseTransformPoint(Vec3 point) {
        return this.getOriginPos().m_82549_(this.inverseTransformLocalVec(point.m_82546_(this.getDestPos())));
    }

    public AABB getThinAreaBox() {
        return new AABB(this.getPointInPlane(this.width / 2.0, this.height / 2.0), this.getPointInPlane(-this.width / 2.0, -this.height / 2.0));
    }

    public boolean isPointInPortalProjection(Vec3 pos) {
        boolean roughResult;
        Vec3 offset = pos.m_82546_(this.getOriginPos());
        double yInPlane = offset.m_82526_(this.axisH);
        double xInPlane = offset.m_82526_(this.axisW);
        boolean bl = roughResult = Math.abs(xInPlane) < this.width / 2.0 + 0.001 && Math.abs(yInPlane) < this.height / 2.0 + 0.001;
        if (roughResult && this.specialShape != null) {
            return this.specialShape.triangles.stream().anyMatch(triangle -> triangle.isPointInTriangle(xInPlane, yInPlane));
        }
        return roughResult;
    }

    public boolean isMovedThroughPortal(Vec3 lastTickPos, Vec3 pos) {
        return this.rayTrace(lastTickPos, pos) != null;
    }

    @Nullable
    public Vec3 rayTrace(Vec3 from, Vec3 to) {
        double collidingT;
        double lastDistance = this.getDistanceToPlane(from);
        double nowDistance = this.getDistanceToPlane(to);
        if (!(lastDistance > 0.0) || !(nowDistance < 0.0)) {
            return null;
        }
        Vec3 lineOrigin = from;
        Vec3 lineDirection = to.m_82546_(from).m_82541_();
        Vec3 collidingPoint = lineOrigin.m_82549_(lineDirection.m_82490_(collidingT = Helper.getCollidingT(this.getOriginPos(), this.normal, lineOrigin, lineDirection)));
        if (this.isPointInPortalProjection(collidingPoint)) {
            return collidingPoint;
        }
        return null;
    }

    @Override
    public double getDistanceToNearestPointInPortal(Vec3 point) {
        double distanceToPlane = this.getDistanceToPlane(point);
        Vec3 localPos = point.m_82546_(this.getOriginPos());
        double localX = localPos.m_82526_(this.axisW);
        double localY = localPos.m_82526_(this.axisH);
        double distanceToRect = Helper.getDistanceToRectangle(localX, localY, -(this.width / 2.0), -(this.height / 2.0), this.width / 2.0, this.height / 2.0);
        return Math.sqrt(distanceToPlane * distanceToPlane + distanceToRect * distanceToRect);
    }

    public Vec3 getPointProjectedToPlane(Vec3 pos) {
        Vec3 originPos = this.getOriginPos();
        Vec3 offset = pos.m_82546_(originPos);
        double yInPlane = offset.m_82526_(this.axisH);
        double xInPlane = offset.m_82526_(this.axisW);
        return originPos.m_82549_(this.axisW.m_82490_(xInPlane)).m_82549_(this.axisH.m_82490_(yInPlane));
    }

    public Vec3 getNearestPointInPortal(Vec3 pos) {
        Vec3 originPos = this.getOriginPos();
        Vec3 offset = pos.m_82546_(originPos);
        double yInPlane = offset.m_82526_(this.axisH);
        double xInPlane = offset.m_82526_(this.axisW);
        xInPlane = Mth.m_14008_((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0));
        yInPlane = Mth.m_14008_((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0));
        return originPos.m_82549_(this.axisW.m_82490_(xInPlane)).m_82549_(this.axisH.m_82490_(yInPlane));
    }

    public Level getDestinationWorld() {
        return this.getDestinationWorld(this.f_19853_.m_5776_());
    }

    private Level getDestinationWorld(boolean isClient) {
        if (isClient) {
            return CHelper.getClientWorld(this.dimensionTo);
        }
        return MiscHelper.getServer().m_129880_(this.dimensionTo);
    }

    public static boolean isParallelPortal(Portal currPortal, Portal outerPortal) {
        return currPortal.f_19853_.m_46472_() == outerPortal.dimensionTo && currPortal.dimensionTo == outerPortal.f_19853_.m_46472_() && !(currPortal.getNormal().m_82526_(outerPortal.getContentDirection()) > -0.9) && !outerPortal.isInside(currPortal.getOriginPos(), 0.1);
    }

    public static boolean isParallelOrientedPortal(Portal currPortal, Portal outerPortal) {
        return currPortal.f_19853_.m_46472_() == outerPortal.dimensionTo && currPortal.getNormal().m_82526_(outerPortal.getContentDirection()) < -0.9 && !outerPortal.isInside(currPortal.getOriginPos(), 0.1);
    }

    public static boolean isReversePortal(Portal a, Portal b) {
        return a.dimensionTo == b.f_19853_.m_46472_() && a.f_19853_.m_46472_() == b.dimensionTo && a.getOriginPos().m_82554_(b.getDestPos()) < 0.1 && a.getDestPos().m_82554_(b.getOriginPos()) < 0.1 && a.getNormal().m_82526_(b.getContentDirection()) > 0.9;
    }

    public static boolean isFlippedPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.f_19853_ == b.f_19853_ && a.dimensionTo == b.dimensionTo && a.getOriginPos().m_82554_(b.getOriginPos()) < 0.1 && a.getDestPos().m_82554_(b.getDestPos()) < 0.1 && a.getNormal().m_82526_(b.getNormal()) < -0.9;
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        return Math.max(this.width, this.height) * this.scaling;
    }

    @Override
    public boolean isConventionalPortal() {
        return true;
    }

    @Override
    public AABB getExactAreaBox() {
        return this.getExactBoundingBox();
    }

    @Override
    public boolean isRoughlyVisibleTo(Vec3 cameraPos) {
        return this.isInFrontOfPortal(cameraPos);
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return new Plane(this.getDestPos(), this.getContentDirection());
    }

    @Override
    @Nullable
    public Vec3[] getOuterFrustumCullingVertices() {
        return this.getFourVerticesLocalCullable(0.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BoxPredicate getInnerFrustumCullingFunc(double cameraX, double cameraY, double cameraZ) {
        Vec3 portalOriginInLocalCoordinate = this.getDestPos().m_82520_(-cameraX, -cameraY, -cameraZ);
        Vec3[] innerFrustumCullingVertices = this.getFourVerticesLocalRotated(0.0);
        if (innerFrustumCullingVertices == null) {
            return BoxPredicate.nonePredicate;
        }
        Vec3[] downLeftUpRightPlaneNormals = FrustumCuller.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, innerFrustumCullingVertices);
        Vec3 downPlane = downLeftUpRightPlaneNormals[0];
        Vec3 leftPlane = downLeftUpRightPlaneNormals[1];
        Vec3 upPlane = downLeftUpRightPlaneNormals[2];
        Vec3 rightPlane = downLeftUpRightPlaneNormals[3];
        return (minX, minY, minZ, maxX, maxY, maxZ) -> FrustumCuller.isFullyOutsideFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
    }

    public TransformationDesc getTransformationDesc() {
        return new TransformationDesc(this.getDestDim(), this.getRotation(), this.getScale(), this.getDestPos().m_82490_(1.0 / this.getScale()).m_82546_(this.getOriginPos()), this instanceof Mirror);
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        return Portal.isParallelOrientedPortal(portal, this);
    }

    public void myUnsetRemoved() {
        this.m_146912_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public PortalLike getRenderingDelegate() {
        if (IPGlobal.enablePortalRenderingMerge) {
            PortalGroup group = PortalRenderInfo.getGroupOf(this);
            if (group != null) {
                return group;
            }
            return this;
        }
        return this;
    }

    public void m_6210_() {
        this.boundingBoxCache = null;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.0f;
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return PortalRenderer.getPortalTransformation(this);
    }

    protected void m_8097_() {
    }

    public boolean canDoOuterFrustumCulling() {
        if (this.isFuseView()) {
            return false;
        }
        if (this.specialShape == null) {
            this.initDefaultCullableRange();
        }
        return this.cullableXStart != this.cullableXEnd;
    }

    @Deprecated
    public boolean isTeleportable() {
        return this.teleportable;
    }

    public static boolean doesPortalBlockEntityView(LivingEntity observer, Entity target) {
        observer.f_19853_.m_46473_().m_6180_("portal_block_view");
        List<Portal> viewBlockingPortals = McHelper.findEntitiesByBox(Portal.class, observer.f_19853_, observer.m_142469_().m_82367_(target.m_142469_()), 8.0, p -> p.rayTrace(observer.m_20299_(1.0f), target.m_20299_(1.0f)) != null);
        observer.f_19853_.m_46473_().m_7238_();
        return !viewBlockingPortals.isEmpty();
    }

    public boolean allowOverlappedTeleport() {
        return false;
    }

    public void onCollidingWithEntity(Entity entity) {
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.hasCrossPortalCollision;
    }

    public boolean getTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public void setTeleportChangesGravity(boolean cond) {
        this.teleportChangesGravity = cond;
    }

    public Direction getTransformedGravityDirection(Direction oldGravityDir) {
        Vec3 oldGravityVec = Vec3.m_82528_((Vec3i)oldGravityDir.m_122436_());
        Vec3 newGravityVec = this.transformLocalVecNonScale(oldGravityVec);
        return Direction.m_122366_((double)newGravityVec.f_82479_, (double)newGravityVec.f_82480_, (double)newGravityVec.f_82481_);
    }

    @Nullable
    public PortalState getPortalState() {
        if (this.axisW == null) {
            return null;
        }
        if (this.f_19797_ == 0) {
            return null;
        }
        return new PortalState((ResourceKey<Level>)this.f_19853_.m_46472_(), this.getOriginPos(), this.dimensionTo, this.getDestPos(), this.getScale(), this.getRotation() == null ? DQuaternion.identity : DQuaternion.fromMcQuaternion(this.getRotation()), PortalManipulation.getPortalOrientationQuaternion(this.axisW, this.axisH), this.width, this.height);
    }

    public void setPortalState(PortalState state) {
        Validate.isTrue((this.f_19853_.m_46472_() == state.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((this.dimensionTo == state.toWorld ? 1 : 0) != 0);
        this.width = state.width;
        this.height = state.height;
        this.setOriginPos(state.fromPos);
        this.setDestination(state.toPos);
        PortalManipulation.setPortalOrientationQuaternion(this, state.orientation);
        if (DQuaternion.isClose(state.rotation, DQuaternion.identity, 5.0E-5)) {
            this.setRotationTransformation(null);
        } else {
            this.setRotationTransformation(state.rotation.toMcQuaternion());
        }
        this.setScaleTransformation(state.scaling);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startAnimationClient(PortalState animationStartState) {
        PortalState newState = this.getPortalState();
        if (newState == null) {
            Helper.err("portal animation state abnormal");
            return;
        }
        if (newState.fromWorld != animationStartState.fromWorld || newState.toWorld != animationStartState.toWorld) {
            return;
        }
        Validate.notNull((Object)this.animation);
        PortalAnimationManagement.addAnimation(this, animationStartState, newState, this.animation);
        this.setPortalState(animationStartState);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void acceptDataSync(Vec3 pos, CompoundTag customData) {
        PortalState oldState = this.getPortalState();
        this.m_146884_(pos);
        this.m_7378_(customData);
        if (this.animation.durationTicks > 0) {
            this.startAnimationClient(oldState);
        }
    }

    public CompoundTag writePortalDataToNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        this.m_7380_(nbtCompound);
        return nbtCompound;
    }

    public void readPortalDataFromNbt(CompoundTag compound) {
        this.m_7378_(compound);
    }

    public void rectifyClusterPortals() {
        PortalExtension.get(this).rectifyClusterPortals(this);
    }

    public static class TransformationDesc {
        public final ResourceKey<Level> dimensionTo;
        @Nullable
        public final Quaternion rotation;
        public final double scaling;
        public final Vec3 offset;
        public final boolean isMirror;

        public TransformationDesc(ResourceKey<Level> dimensionTo, @Nullable Quaternion rotation, double scaling, Vec3 offset, boolean isMirror) {
            this.dimensionTo = dimensionTo;
            this.rotation = rotation;
            this.scaling = scaling;
            this.offset = offset;
            this.isMirror = isMirror;
        }

        private static boolean rotationRoughlyEquals(Quaternion a, Quaternion b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return RotationHelper.isClose(a, b, 0.01f);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformationDesc that = (TransformationDesc)o;
            if (this.isMirror || that.isMirror) {
                return false;
            }
            return Double.compare(that.scaling, this.scaling) == 0 && this.dimensionTo == that.dimensionTo && TransformationDesc.rotationRoughlyEquals(this.rotation, that.rotation) && this.offset.m_82557_(that.offset) < 0.01;
        }

        public int hashCode() {
            throw new RuntimeException("This cannot be put into a container");
        }
    }

    public static class RemoteCallables {
        public static void acceptPortalDataSync(ResourceKey<Level> dim, int entityId, Vec3 pos, CompoundTag customData) {
            ClientLevel world = ClientWorldLoader.getWorld(dim);
            Entity entity = world.m_6815_(entityId);
            if (entity instanceof Portal) {
                Portal portal = (Portal)entity;
                portal.acceptDataSync(pos, customData);
            } else {
                Helper.err("missing portal entity to sync " + entityId);
            }
        }
    }
}

