/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.nbt.CompoundTag;

public class PortalAnimation {
    public final Curve curve;
    public final int durationTicks;
    public final boolean inverseScale;
    public static final PortalAnimation defaultAnimation = new PortalAnimation(Curve.sine, 10, false);

    public PortalAnimation(Curve curve, int durationTicks, boolean inverseScale) {
        this.curve = curve;
        this.durationTicks = durationTicks;
        this.inverseScale = inverseScale;
    }

    public static PortalAnimation fromNbt(CompoundTag nbt) {
        String c;
        Curve curve = switch (c = nbt.m_128461_("curve")) {
            case "linear" -> Curve.linear;
            case "sine" -> Curve.sine;
            case "circle" -> Curve.circle;
            default -> Curve.sine;
        };
        int durationTicks = nbt.m_128451_("durationTicks");
        boolean inverseScale = nbt.m_128471_("inverseScale");
        return new PortalAnimation(curve, durationTicks, inverseScale);
    }

    public CompoundTag toNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128359_("curve", this.curve.toString());
        nbtCompound.m_128405_("durationTicks", this.durationTicks);
        nbtCompound.m_128379_("inverseScale", this.inverseScale);
        return nbtCompound;
    }

    public PortalAnimation updateInverseScale(boolean newValue) {
        return new PortalAnimation(this.curve, this.durationTicks, newValue);
    }

    public static double mapProgress(double progress, Curve curve) {
        switch (curve) {
            case linear: {
                return progress;
            }
            case sine: {
                return Math.sin(progress * 1.5707963267948966);
            }
            case circle: {
                return Math.sqrt(1.0 - (1.0 - progress) * (1.0 - progress));
            }
        }
        throw new RuntimeException();
    }

    public static enum Curve {
        linear,
        sine,
        circle;

    }
}

