/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalAnimation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class PortalAnimationManagement {
    private static final Map<Portal, RunningAnimation> animatedPortals = new HashMap<Portal, RunningAnimation>();

    public static void init() {
        IPGlobal.preGameRenderSignal.connect(PortalAnimationManagement::onPreGameRender);
        IPGlobal.clientCleanupSignal.connect(PortalAnimationManagement::cleanup);
        ClientWorldLoader.clientDimensionDynamicRemoveSignal.connect(dim -> PortalAnimationManagement.cleanup());
    }

    public static void addAnimation(Portal portal, PortalState fromState, PortalState toState, PortalAnimation animation) {
        if (animation.durationTicks <= 0) {
            return;
        }
        long currTime = System.nanoTime();
        RunningAnimation runningAnimation = new RunningAnimation(fromState, toState, currTime, currTime + Helper.secondToNano((double)animation.durationTicks / 20.0), animation.curve, animation.inverseScale);
        animatedPortals.put(portal, runningAnimation);
    }

    private static void onPreGameRender() {
        long currTime = System.nanoTime();
        animatedPortals.entrySet().removeIf(entry -> {
            Portal portal = (Portal)entry.getKey();
            RunningAnimation animation = (RunningAnimation)entry.getValue();
            if (portal.m_146910_()) {
                return true;
            }
            if (currTime > animation.toTimeNano) {
                portal.setPortalState(animation.toState);
                return true;
            }
            PortalState currentState = animation.getCurrentState(currTime);
            if (currentState.fromWorld != portal.getOriginDim()) {
                return true;
            }
            if (currentState.toWorld != portal.getDestDim()) {
                return true;
            }
            portal.setPortalState(currentState);
            return false;
        });
    }

    private static void cleanup() {
        animatedPortals.clear();
    }

    public static class RunningAnimation {
        public PortalState fromState;
        public PortalState toState;
        public long startTimeNano;
        public long toTimeNano;
        public PortalAnimation.Curve curve;
        public boolean inverseScale;

        public RunningAnimation(PortalState fromState, PortalState toState, long startTimeNano, long toTimeNano, PortalAnimation.Curve curve, boolean inverseScale) {
            this.fromState = fromState;
            this.toState = toState;
            this.startTimeNano = startTimeNano;
            this.toTimeNano = toTimeNano;
            this.curve = curve;
            this.inverseScale = inverseScale;
        }

        public PortalState getCurrentState(long currTime) {
            double progress = (double)(currTime - this.startTimeNano) / (double)(this.toTimeNano - this.startTimeNano);
            if (progress < 0.0) {
                Helper.err("invalid portal animation");
                progress = 0.0;
            }
            progress = PortalAnimation.mapProgress(progress, this.curve);
            PortalState currState = PortalState.interpolate(this.fromState, this.toState, progress, this.inverseScale);
            return currState;
        }
    }
}

