/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class PortalExtension {
    public double motionAffinity = 0.0;
    public boolean adjustPositionAfterTeleport = false;
    public boolean bindCluster = false;
    @Nullable
    public Portal reversePortal;
    @Nullable
    public Portal flippedPortal;
    @Nullable
    public Portal parallelPortal;

    public static PortalExtension get(Portal portal) {
        if (portal.extension == null) {
            portal.extension = new PortalExtension();
        }
        return portal.extension;
    }

    public static void init() {
        Portal.clientPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.serverPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.readPortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).readFromNbt((CompoundTag)tag));
        Portal.writePortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).writeToNbt((CompoundTag)tag));
    }

    private void readFromNbt(CompoundTag compoundTag) {
        this.motionAffinity = compoundTag.m_128441_("motionAffinity") ? compoundTag.m_128459_("motionAffinity") : 0.0;
        this.adjustPositionAfterTeleport = compoundTag.m_128441_("adjustPositionAfterTeleport") ? compoundTag.m_128471_("adjustPositionAfterTeleport") : false;
        this.bindCluster = compoundTag.m_128441_("bindCluster") ? compoundTag.m_128471_("bindCluster") : false;
    }

    private void writeToNbt(CompoundTag compoundTag) {
        if (this.motionAffinity != 0.0) {
            compoundTag.m_128347_("motionAffinity", this.motionAffinity);
        }
        compoundTag.m_128379_("adjustPositionAfterTeleport", this.adjustPositionAfterTeleport);
        compoundTag.m_128379_("bindCluster", this.bindCluster);
    }

    private void tick(Portal portal) {
        if (portal.f_19853_.m_5776_()) {
            this.tickClient(portal);
        } else {
            this.updateClusterStatus(portal);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(Portal portal) {
    }

    private void updateClusterStatus(Portal portal) {
        if (this.bindCluster) {
            this.flippedPortal = PortalManipulation.findFlippedPortal(portal);
            if (this.flippedPortal != null) {
                PortalExtension.get((Portal)this.flippedPortal).bindCluster = true;
            }
            this.reversePortal = PortalManipulation.findReversePortal(portal);
            if (this.reversePortal != null) {
                PortalExtension.get((Portal)this.reversePortal).bindCluster = true;
            }
            this.parallelPortal = PortalManipulation.findParallelPortal(portal);
            if (this.parallelPortal != null) {
                PortalExtension.get((Portal)this.parallelPortal).bindCluster = true;
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
        }
    }

    public void rectifyClusterPortals(Portal portal) {
        portal.animation = portal.animation.updateInverseScale(false);
        if (this.flippedPortal != null) {
            this.flippedPortal = ServerTeleportationManager.teleportRegularEntityTo(this.flippedPortal, (ResourceKey<Level>)portal.f_19853_.m_46472_(), portal.getOriginPos());
            this.flippedPortal.dimensionTo = portal.dimensionTo;
            this.flippedPortal.setOriginPos(portal.getOriginPos());
            this.flippedPortal.setDestination(portal.getDestPos());
            this.flippedPortal.axisW = portal.axisW;
            this.flippedPortal.axisH = portal.axisH.m_82490_(-1.0);
            this.flippedPortal.scaling = portal.scaling;
            this.flippedPortal.rotation = portal.rotation;
            if (this.flippedPortal.specialShape == null) {
                this.flippedPortal.width = portal.width;
                this.flippedPortal.height = portal.height;
            }
            PortalManipulation.copyAdditionalProperties(this.flippedPortal, portal, false);
            this.flippedPortal.animation = this.flippedPortal.animation.updateInverseScale(false);
            this.flippedPortal.reloadAndSyncToClient();
        }
        if (this.reversePortal != null) {
            this.reversePortal = ServerTeleportationManager.teleportRegularEntityTo(this.reversePortal, portal.getDestDim(), portal.getDestPos());
            this.reversePortal.dimensionTo = portal.getOriginDim();
            this.reversePortal.setOriginPos(portal.getDestPos());
            this.reversePortal.setDestination(portal.getOriginPos());
            this.reversePortal.axisW = portal.transformLocalVecNonScale(portal.axisW);
            this.reversePortal.axisH = portal.transformLocalVecNonScale(portal.axisH.m_82490_(-1.0));
            this.reversePortal.scaling = 1.0 / portal.scaling;
            if (portal.rotation != null) {
                this.reversePortal.rotation = portal.rotation.m_80161_();
                this.reversePortal.rotation.m_80157_();
            } else {
                this.reversePortal.rotation = null;
            }
            if (this.reversePortal.specialShape == null) {
                this.reversePortal.width = portal.width * portal.getScale();
                this.reversePortal.height = portal.height * portal.getScale();
            }
            PortalManipulation.copyAdditionalProperties(this.reversePortal, portal, false);
            this.reversePortal.animation = this.reversePortal.animation.updateInverseScale(true);
            this.reversePortal.reloadAndSyncToClient();
        }
        if (this.parallelPortal != null) {
            this.parallelPortal = ServerTeleportationManager.teleportRegularEntityTo(this.parallelPortal, portal.getDestDim(), portal.getDestPos());
            this.parallelPortal.dimensionTo = portal.getOriginDim();
            this.parallelPortal.setOriginPos(portal.getDestPos());
            this.parallelPortal.setDestination(portal.getOriginPos());
            this.parallelPortal.axisW = portal.transformLocalVecNonScale(portal.axisW);
            this.parallelPortal.axisH = portal.transformLocalVecNonScale(portal.axisH);
            this.parallelPortal.scaling = 1.0 / portal.scaling;
            if (portal.rotation != null) {
                this.parallelPortal.rotation = portal.rotation.m_80161_();
                this.parallelPortal.rotation.m_80157_();
            } else {
                this.parallelPortal.rotation = null;
            }
            if (this.parallelPortal.specialShape == null) {
                this.parallelPortal.width = portal.width * portal.getScale();
                this.parallelPortal.height = portal.height * portal.getScale();
            }
            PortalManipulation.copyAdditionalProperties(this.parallelPortal, portal, false);
            this.parallelPortal.animation = this.parallelPortal.animation.updateInverseScale(true);
            this.parallelPortal.reloadAndSyncToClient();
        }
    }
}

