/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.GlQueryObject;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class PortalRenderInfo {
    private final Map<List<UUID>, Visibility> infoMap = new HashMap<List<UUID>, Visibility>();
    public int thisFrameQueryFrameIndex = -1;
    private long mispredictTime1 = 0L;
    private long mispredictTime2 = 0L;
    private int totalMispredictCount = 0;
    private boolean needsGroupingUpdate = true;
    @Nullable
    private PortalGroup renderingGroup;

    public static void init() {
        Portal.clientPortalTickSignal.connect(portal -> {
            PortalRenderInfo presentation = PortalRenderInfo.getOptional(portal);
            if (presentation != null) {
                presentation.tick((Portal)portal);
            }
        });
        Portal.portalCacheUpdateSignal.connect(portal -> {
            PortalRenderInfo renderInfo;
            if (portal.f_19853_.m_5776_() && (renderInfo = PortalRenderInfo.getOptional(portal)) != null) {
                renderInfo.onPortalCacheUpdate((Portal)portal);
            }
        });
        Portal.portalDisposeSignal.connect(portal -> {
            PortalRenderInfo renderInfo;
            if (portal.f_19853_.m_5776_() && (renderInfo = PortalRenderInfo.getOptional(portal)) != null) {
                renderInfo.dispose();
                renderInfo.setGroup((Portal)portal, null);
            }
        });
    }

    @Nullable
    public static PortalRenderInfo getOptional(Portal portal) {
        Validate.isTrue((boolean)portal.f_19853_.m_5776_());
        return portal.portalRenderInfo;
    }

    public static PortalRenderInfo get(Portal portal) {
        Validate.isTrue((boolean)portal.f_19853_.m_5776_());
        if (portal.portalRenderInfo == null) {
            portal.portalRenderInfo = new PortalRenderInfo();
        }
        return portal.portalRenderInfo;
    }

    private void tick(Portal portal) {
        Validate.isTrue((boolean)portal.f_19853_.m_5776_());
        if (this.needsGroupingUpdate) {
            this.needsGroupingUpdate = false;
            this.updateGrouping(portal);
        }
        if (this.renderingGroup != null) {
            this.renderingGroup.purge();
            if (this.renderingGroup.portals.size() <= 1) {
                this.setGroup(portal, null);
            }
        }
    }

    public void dispose() {
        PortalRenderInfo.disposeInfoMap(this.infoMap);
    }

    private static void disposeInfoMap(Map<List<UUID>, Visibility> infoMap) {
        infoMap.values().forEach(Visibility::dispose);
        infoMap.clear();
    }

    private void updateQuerySet() {
        if (RenderStates.frameIndex != this.thisFrameQueryFrameIndex) {
            if (RenderStates.frameIndex == this.thisFrameQueryFrameIndex + 1) {
                this.infoMap.entrySet().removeIf(entry -> {
                    Visibility visibility = (Visibility)entry.getValue();
                    return visibility.lastFrameQuery == null && visibility.thisFrameQuery == null;
                });
                this.infoMap.values().forEach(Visibility::update);
            } else {
                PortalRenderInfo.disposeInfoMap(this.infoMap);
            }
            this.thisFrameQueryFrameIndex = RenderStates.frameIndex;
        }
    }

    @Nonnull
    private Visibility getVisibility(List<UUID> desc) {
        this.updateQuerySet();
        return this.infoMap.computeIfAbsent(desc, k -> new Visibility());
    }

    private void onMispredict() {
        this.mispredictTime1 = this.mispredictTime2;
        this.mispredictTime2 = System.nanoTime();
        ++this.totalMispredictCount;
    }

    private boolean isFrequentlyMispredicted() {
        if (this.totalMispredictCount > 5) {
            return true;
        }
        long currTime = System.nanoTime();
        return currTime - this.mispredictTime1 < Helper.secondToNano(30.0);
    }

    private void updatePredictionStatus(Visibility visibility, boolean thisFrameDecision) {
        visibility.thisFrameRendered = thisFrameDecision;
        if (thisFrameDecision && visibility.lastFrameRendered != null && !visibility.lastFrameRendered.booleanValue() && !this.isFrequentlyMispredicted()) {
            this.onMispredict();
        }
    }

    public static boolean renderAndDecideVisibility(PortalLike portal, Runnable queryRendering) {
        boolean decision;
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        if (IPGlobal.offsetOcclusionQuery && portal instanceof Portal) {
            boolean noPredict;
            PortalRenderInfo presentation = PortalRenderInfo.get((Portal)portal);
            List<UUID> renderingDescription = WorldRenderInfo.getRenderingDescription();
            Visibility visibility = presentation.getVisibility(renderingDescription);
            GlQueryObject lastFrameQuery = visibility.lastFrameQuery;
            GlQueryObject thisFrameQuery = visibility.acquireThisFrameQuery();
            thisFrameQuery.performQueryAnySamplePassed(queryRendering);
            boolean bl = noPredict = presentation.isFrequentlyMispredicted() || QueryManager.queryStallCounter <= 3;
            if (lastFrameQuery != null) {
                boolean lastFrameVisible = lastFrameQuery.fetchQueryResult();
                if (!lastFrameVisible && noPredict) {
                    profiler.m_6180_("fetch_this_frame");
                    decision = thisFrameQuery.fetchQueryResult();
                    profiler.m_7238_();
                    ++QueryManager.queryStallCounter;
                } else {
                    decision = lastFrameVisible;
                    presentation.updatePredictionStatus(visibility, decision);
                }
            } else {
                profiler.m_6180_("fetch_this_frame");
                decision = thisFrameQuery.fetchQueryResult();
                profiler.m_7238_();
                ++QueryManager.queryStallCounter;
            }
        } else {
            decision = QueryManager.renderAndGetDoesAnySamplePass(queryRendering);
        }
        return decision;
    }

    private void onPortalCacheUpdate(Portal portal) {
        this.needsGroupingUpdate = true;
        this.setGroup(portal, null);
    }

    private void setGroup(Portal portal, @Nullable PortalGroup group) {
        if (this.renderingGroup != null) {
            this.renderingGroup.removePortal(portal);
        }
        this.renderingGroup = group;
        if (this.renderingGroup != null) {
            this.renderingGroup.addPortal(portal);
        }
    }

    private void updateGrouping(Portal portal) {
        Validate.isTrue((!portal.isGlobalPortal ? 1 : 0) != 0);
        if (!IPGlobal.enablePortalRenderingMerge) {
            return;
        }
        if (!PortalRenderInfo.canMerge(portal)) {
            return;
        }
        List<Portal> nearbyPortals = McHelper.findEntitiesByBox(Portal.class, portal.getOriginWorld(), portal.m_142469_().m_82400_(0.5), Math.min(64.0, portal.getSizeEstimation()) * 2.0 + 5.0, p -> p != portal && !Portal.isFlippedPortal(p, portal) && PortalRenderInfo.canMerge(p));
        Portal.TransformationDesc thisDesc = portal.getTransformationDesc();
        for (Portal that : nearbyPortals) {
            PortalRenderInfo nearbyPortalPresentation = PortalRenderInfo.get(that);
            PortalGroup itsGroup = nearbyPortalPresentation.renderingGroup;
            if (itsGroup != null) {
                if (!itsGroup.portals.stream().noneMatch(p -> Portal.isFlippedPortal(p, portal)) || !itsGroup.transformationDesc.equals(thisDesc)) continue;
                if (this.renderingGroup == null) {
                    this.setGroup(portal, itsGroup);
                } else {
                    PortalRenderInfo.mergeGroup(this.renderingGroup, itsGroup);
                }
                return;
            }
            Portal.TransformationDesc itsDesc = that.getTransformationDesc();
            if (!thisDesc.equals(itsDesc)) continue;
            if (this.renderingGroup == null) {
                PortalGroup newGroup = new PortalGroup(thisDesc);
                this.setGroup(portal, newGroup);
                PortalRenderInfo.get(that).setGroup(that, newGroup);
            } else {
                PortalRenderInfo.get(that).setGroup(that, this.renderingGroup);
            }
            return;
        }
        this.setGroup(portal, null);
    }

    private static boolean canMerge(Portal p) {
        if (IPGlobal.forceMergePortalRendering) {
            return true;
        }
        return p.isRenderingMergable();
    }

    @Nullable
    public static PortalGroup getGroupOf(Portal portal) {
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        PortalRenderInfo portalRenderInfo = PortalRenderInfo.getOptional(portal);
        if (portalRenderInfo == null) {
            return null;
        }
        return portalRenderInfo.renderingGroup;
    }

    private static void mergeGroup(PortalGroup g1, PortalGroup g2) {
        if (g1 == g2) {
            return;
        }
        ArrayList<Portal> g2Portals = new ArrayList<Portal>(g2.portals);
        for (Portal portal : g2Portals) {
            PortalRenderInfo.get(portal).setGroup(portal, g1);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        IPGlobal.preTotalRenderTaskList.addTask(() -> {
            this.dispose();
            return true;
        });
    }

    public static class Visibility {
        public GlQueryObject lastFrameQuery = null;
        public GlQueryObject thisFrameQuery = null;
        public Boolean lastFrameRendered = null;
        public Boolean thisFrameRendered;

        void update() {
            if (this.lastFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.lastFrameQuery);
            }
            this.lastFrameQuery = this.thisFrameQuery;
            this.thisFrameQuery = null;
            this.lastFrameRendered = this.thisFrameRendered;
            this.thisFrameRendered = null;
        }

        void dispose() {
            if (this.lastFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.lastFrameQuery);
            }
            if (this.thisFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.thisFrameQuery);
            }
        }

        GlQueryObject acquireThisFrameQuery() {
            if (this.thisFrameQuery == null) {
                this.thisFrameQuery = GlQueryObject.acquireQueryObject();
            }
            return this.thisFrameQuery;
        }
    }
}

