/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mixin.common.IERegistryLoader;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.UCoordinate;

public class CustomPortalGenManagement {
    private static final Multimap<Item, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private static final Multimap<Item, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private static final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private static final Map<UUID, UCoordinate> playerPosBeforeTravel = new HashMap<UUID, UCoordinate>();

    public static void onDatapackReload() {
        useItemGen.clear();
        throwItemGen.clear();
        convGen.clear();
        playerPosBeforeTravel.clear();
        if (!IPGlobal.enableDatapackPortalGen) {
            return;
        }
        Helper.log("Loading custom portal generation");
        Registry<CustomPortalGeneration> result = CustomPortalGenManagement.loadCustomPortalGenerations();
        if (result == null) {
            return;
        }
        result.m_6579_().forEach(entry -> {
            CustomPortalGeneration gen = (CustomPortalGeneration)entry.getValue();
            gen.identifier = ((ResourceKey)entry.getKey()).m_135782_();
            if (!gen.initAndCheck()) {
                Helper.log("Custom Portal Gen Is Not Activated " + gen.toString());
                return;
            }
            Helper.log("Loaded Custom Portal Gen " + ((ResourceKey)entry.getKey()).m_135782_());
            CustomPortalGenManagement.load(gen);
            if (gen.reversible) {
                CustomPortalGeneration reverse = gen.getReverse();
                if (reverse != null) {
                    reverse.identifier = ((ResourceKey)entry.getKey()).m_135782_();
                    if (gen.initAndCheck()) {
                        CustomPortalGenManagement.load(reverse);
                    }
                } else {
                    McHelper.sendMessageToFirstLoggedPlayer((Component)new TextComponent("Cannot create reverse generation of " + gen));
                }
            }
        });
    }

    private static Registry<CustomPortalGeneration> loadCustomPortalGenerations() {
        MinecraftServer server = MiscHelper.getServer();
        RegistryAccess.Frozen registryTracker = server.m_206579_();
        ResourceManager resourceManager = server.m_177941_();
        RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryTracker);
        MappedRegistry emptyRegistry = new MappedRegistry(CustomPortalGeneration.registryRegistryKey, Lifecycle.stable(), null);
        RegistryResourceAccess registryResourceAccess = RegistryResourceAccess.m_195881_((ResourceManager)resourceManager);
        RegistryLoader registryLoader = IERegistryLoader.construct(registryResourceAccess);
        DataResult<Registry<CustomPortalGeneration>> dataResult = ((IERegistryLoader)registryLoader).ip_overrideRegistryFromResources(emptyRegistry, CustomPortalGeneration.registryRegistryKey, CustomPortalGeneration.codec.codec(), (DynamicOps<JsonElement>)registryOps);
        Registry result = dataResult.get().left().orElse(null);
        if (result == null) {
            DataResult.PartialResult r = (DataResult.PartialResult)dataResult.get().right().get();
            McHelper.sendMessageToFirstLoggedPlayer((Component)new TextComponent("Error when parsing custom portal generation\n" + r.message()));
            return null;
        }
        return result;
    }

    private static void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            convGen.add(gen);
        }
    }

    public static void onItemUse(UseOnContext context, InteractionResult actionResult) {
        if (context.m_43725_().m_5776_()) {
            return;
        }
        Item item = context.m_43722_().m_41720_();
        if (useItemGen.containsKey((Object)item)) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : useItemGen.get((Object)item)) {
                    PortalGenTrigger.UseItemTrigger trigger;
                    boolean result = gen.perform((ServerLevel)context.m_43725_(), context.m_8083_().m_142300_(context.m_43719_()), (Entity)context.m_43723_());
                    if (!result) continue;
                    if (!(gen.trigger instanceof PortalGenTrigger.UseItemTrigger) || !(trigger = (PortalGenTrigger.UseItemTrigger)gen.trigger).shouldConsume(context)) break;
                    context.m_43722_().m_41774_(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onItemTick(ItemEntity entity) {
        Item item;
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (entity.m_32057_() == null) {
            return;
        }
        if (entity.m_32063_() && throwItemGen.containsKey((Object)(item = entity.m_32055_().m_41720_()))) {
            IPGlobal.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : throwItemGen.get((Object)item)) {
                    boolean result = gen.perform((ServerLevel)entity.f_19853_, entity.m_142538_(), (Entity)entity);
                    if (!result) continue;
                    entity.m_32055_().m_41774_(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onBeforeConventionalDimensionChange(ServerPlayer player) {
        playerPosBeforeTravel.put(player.m_142081_(), new UCoordinate((Entity)player));
    }

    public static void onAfterConventionalDimensionChange(ServerPlayer player) {
        UUID uuid = player.m_142081_();
        if (playerPosBeforeTravel.containsKey(uuid)) {
            UCoordinate startCoord = playerPosBeforeTravel.get(uuid);
            ServerLevel startWorld = McHelper.getServerWorld(startCoord.dimension);
            BlockPos startPos = new BlockPos(startCoord.pos);
            for (CustomPortalGeneration gen : convGen) {
                boolean succeeded = gen.perform(startWorld, startPos, (Entity)player);
                if (!succeeded) continue;
                playerPosBeforeTravel.remove(uuid);
                return;
            }
        }
        playerPosBeforeTravel.remove(uuid);
    }
}

