/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.google.common.math.IntMath;
import com.mojang.math.Matrix3f;
import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quaternion;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class DiligentMatcher {
    public static final List<IntMatrix3> rotationTransformations = (List)Util.m_137537_(() -> {
        List basicRotations = Arrays.stream(Direction.values()).map(DiligentMatcher::getRotation90).collect(Collectors.toList());
        IntMatrix3 identity = IntMatrix3.getIdentity();
        ArrayList<IntMatrix3> rotationList = new ArrayList<IntMatrix3>();
        HashSet<IntMatrix3> rotationSet = new HashSet<IntMatrix3>();
        rotationList.add(identity);
        rotationSet.add(identity);
        for (int i = 0; i < 3; ++i) {
            ArrayList<IntMatrix3> newlyAdded = new ArrayList<IntMatrix3>();
            for (IntMatrix3 rot : rotationList) {
                for (IntMatrix3 basicRotation : basicRotations) {
                    IntMatrix3 newRot = rot.multiply(basicRotation);
                    if (rotationSet.contains(newRot)) continue;
                    rotationSet.add(newRot);
                    newlyAdded.add(newRot);
                }
            }
            rotationList.addAll(newlyAdded);
        }
        Validate.isTrue((rotationList.size() == 24 ? 1 : 0) != 0);
        return rotationList;
    });

    public static int dirDotProduct(Direction dir, Direction b) {
        if (dir.m_122434_() != b.m_122434_()) {
            return 0;
        }
        if (dir.m_122421_() == b.m_122421_()) {
            return 1;
        }
        return -1;
    }

    public static Direction rotateAlong(Direction dir, Direction axis) {
        Tuple<Direction, Direction> ds = Helper.getPerpendicularDirections(axis);
        Direction d1 = (Direction)ds.m_14418_();
        Direction d2 = (Direction)ds.m_14419_();
        int c1 = DiligentMatcher.dirDotProduct(dir, d1);
        int c2 = DiligentMatcher.dirDotProduct(dir, d2);
        int ca = DiligentMatcher.dirDotProduct(dir, axis);
        int nc1 = -c2;
        int nc2 = c1;
        BlockPos finalVec = Helper.scale(d1.m_122436_(), nc1).m_141952_((Vec3i)Helper.scale(d2.m_122436_(), nc2)).m_141952_((Vec3i)Helper.scale(axis.m_122436_(), ca));
        return Direction.m_122378_((int)finalVec.m_123341_(), (int)finalVec.m_123342_(), (int)finalVec.m_123343_());
    }

    public static IntMatrix3 getRotation90(Direction direction) {
        return new IntMatrix3(DiligentMatcher.rotateAlong(Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), direction).m_122436_(), DiligentMatcher.rotateAlong(Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), direction).m_122436_(), DiligentMatcher.rotateAlong(Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), direction).m_122436_());
    }

    public static List<TransformedShape> getMatchableShapeVariants(BlockPortalShape original, int maxShapeLen) {
        ArrayList<TransformedShape> result = new ArrayList<TransformedShape>();
        HashSet<BlockPortalShape> shapeSet = new HashSet<BlockPortalShape>();
        int divFactor = DiligentMatcher.getShapeShrinkFactor(original);
        BlockPortalShape shrinked = DiligentMatcher.shrinkShapeBy(original, divFactor);
        BlockPos shrinkedShapeSize = shrinked.innerAreaBox.getSize();
        int shrinkedShapeLen = Math.max(shrinkedShapeSize.m_123341_(), Math.max(shrinkedShapeSize.m_123342_(), shrinkedShapeSize.m_123343_()));
        int maxMultiplyFactor = (int)Math.floor((double)maxShapeLen / (double)shrinkedShapeLen);
        for (IntMatrix3 rotation : rotationTransformations) {
            BlockPortalShape rotatedShape = DiligentMatcher.rotateShape(shrinked, rotation);
            BlockPortalShape newShape = DiligentMatcher.regularizeShape(rotatedShape);
            boolean isNew = shapeSet.add(newShape);
            if (!isNew) continue;
            result.add(new TransformedShape(original, newShape, rotation, 1.0 / (double)divFactor));
            for (int mul = 2; mul <= maxMultiplyFactor; ++mul) {
                BlockPortalShape expanded = DiligentMatcher.regularizeShape(DiligentMatcher.upscaleShape(rotatedShape, mul));
                isNew = shapeSet.add(expanded);
                if (!isNew) continue;
                result.add(new TransformedShape(original, expanded, rotation, (double)mul / (double)divFactor));
            }
        }
        return result;
    }

    public static BlockPortalShape regularizeShape(BlockPortalShape rotatedShape) {
        return rotatedShape.getShapeWithMovedAnchor(BlockPos.f_121853_);
    }

    public static BlockPortalShape rotateShape(BlockPortalShape shape, IntMatrix3 t) {
        Set<BlockPos> newArea = shape.area.stream().map(b -> t.transform((Vec3i)b)).collect(Collectors.toSet());
        Direction.Axis newAxis = t.transformDirection(Direction.m_122387_((Direction.Axis)shape.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_();
        return new BlockPortalShape(newArea, newAxis);
    }

    public static int getShapeShrinkFactor(BlockPortalShape shape) {
        HashSet<BlockPos> area = new HashSet<BlockPos>(shape.area);
        ArrayList<IntBox> boxList = DiligentMatcher.decomposeShape(shape, area);
        IntArrayList sideLenList = new IntArrayList();
        Tuple<Direction.Axis, Direction.Axis> axs = Helper.getAnotherTwoAxis(shape.axis);
        for (IntBox box : boxList) {
            BlockPos boxSize = box.getSize();
            int a2 = Helper.getCoordinate((Vec3i)boxSize, (Direction.Axis)axs.m_14418_());
            int b2 = Helper.getCoordinate((Vec3i)boxSize, (Direction.Axis)axs.m_14419_());
            sideLenList.add(a2);
            sideLenList.add(b2);
        }
        return (Integer)sideLenList.stream().reduce((a, b) -> IntMath.gcd((int)a, (int)b)).get();
    }

    public static BlockPortalShape shrinkShapeBy(BlockPortalShape shape, int div) {
        Validate.isTrue((div != 0 ? 1 : 0) != 0);
        BlockPortalShape regularized = DiligentMatcher.regularizeShape(shape);
        if (div == 1) {
            return regularized;
        }
        Set<BlockPos> newArea = regularized.area.stream().map(b -> new BlockPos(Math.floorDiv(b.m_123341_(), div), Math.floorDiv(b.m_123342_(), div), Math.floorDiv(b.m_123343_(), div))).collect(Collectors.toSet());
        return new BlockPortalShape(newArea, regularized.axis);
    }

    public static ArrayList<IntBox> decomposeShape(BlockPortalShape shape, HashSet<BlockPos> area) {
        IntBox box;
        ArrayList<IntBox> boxList = new ArrayList<IntBox>();
        while (!area.isEmpty() && (box = DiligentMatcher.splitBoxFromArea(area, shape.axis)) != null) {
            boxList.add(box);
        }
        return boxList;
    }

    public static BlockPortalShape upscaleShape(BlockPortalShape shape, int multiplyFactor) {
        Tuple<Direction.Axis, Direction.Axis> axs = Helper.getAnotherTwoAxis(shape.axis);
        Vec3i v1 = Direction.m_122387_((Direction.Axis)((Direction.Axis)axs.m_14418_()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_();
        Vec3i v2 = Direction.m_122387_((Direction.Axis)((Direction.Axis)axs.m_14419_()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_();
        return new BlockPortalShape(shape.area.stream().flatMap(basePos -> IntStream.range(0, multiplyFactor).boxed().flatMap(dx -> IntStream.range(0, multiplyFactor).mapToObj(dy -> Helper.scale((Vec3i)basePos, multiplyFactor).m_141952_((Vec3i)Helper.scale(v1, dx).m_141952_((Vec3i)Helper.scale(v2, dy)))))).collect(Collectors.toSet()), shape.axis);
    }

    private static IntBox splitBoxFromArea(Set<BlockPos> area, Direction.Axis axis) {
        Iterator<BlockPos> iterator = area.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        BlockPos firstElement = iterator.next();
        IntBox expanded = Helper.expandRectangle(firstElement, area::contains, axis);
        expanded.stream().forEach(b -> area.remove(b));
        return expanded;
    }

    public static class IntMatrix3 {
        public final Vec3i x;
        public final Vec3i y;
        public final Vec3i z;

        public IntMatrix3(Vec3i x, Vec3i y, Vec3i z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public IntMatrix3(OctahedralGroup t) {
            Direction d1 = t.m_56528_(Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            Direction d2 = t.m_56528_(Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            Direction d3 = t.m_56528_(Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            this.x = d1.m_122436_();
            this.y = d2.m_122436_();
            this.z = d3.m_122436_();
        }

        public BlockPos transform(Vec3i p) {
            return Helper.scale(this.x, p.m_123341_()).m_141952_((Vec3i)Helper.scale(this.y, p.m_123342_())).m_141952_((Vec3i)Helper.scale(this.z, p.m_123343_()));
        }

        public IntMatrix3 multiply(IntMatrix3 m) {
            return new IntMatrix3((Vec3i)m.transform(this.x), (Vec3i)m.transform(this.y), (Vec3i)m.transform(this.z));
        }

        public Direction transformDirection(Direction direction) {
            BlockPos vec = this.transform(direction.m_122436_());
            return Direction.m_122378_((int)vec.m_123341_(), (int)vec.m_123342_(), (int)vec.m_123343_());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntMatrix3 that = (IntMatrix3)o;
            return this.x.equals((Object)that.x) && this.y.equals((Object)that.y) && this.z.equals((Object)that.z);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }

        public static IntMatrix3 getIdentity() {
            return new IntMatrix3((Vec3i)new BlockPos(1, 0, 0), (Vec3i)new BlockPos(0, 1, 0), (Vec3i)new BlockPos(0, 0, 1));
        }

        public Matrix3f toMatrix() {
            Matrix3f matrix = new Matrix3f();
            matrix.m_8165_(0, 0, (float)this.x.m_123341_());
            matrix.m_8165_(0, 1, (float)this.x.m_123342_());
            matrix.m_8165_(0, 2, (float)this.x.m_123343_());
            matrix.m_8165_(1, 0, (float)this.y.m_123341_());
            matrix.m_8165_(1, 1, (float)this.y.m_123342_());
            matrix.m_8165_(1, 2, (float)this.y.m_123343_());
            matrix.m_8165_(2, 0, (float)this.z.m_123341_());
            matrix.m_8165_(2, 1, (float)this.z.m_123342_());
            matrix.m_8165_(2, 2, (float)this.z.m_123343_());
            return matrix;
        }

        public Quaternion toQuaternion() {
            return DQuaternion.matrixToQuaternion(Vec3.m_82528_((Vec3i)this.x), Vec3.m_82528_((Vec3i)this.y), Vec3.m_82528_((Vec3i)this.z)).toMcQuaternion();
        }
    }

    public static class TransformedShape {
        public final BlockPortalShape originalShape;
        public final BlockPortalShape transformedShape;
        public final IntMatrix3 rotation;
        public final double scale;

        public TransformedShape(BlockPortalShape originalShape, BlockPortalShape transformedShape, IntMatrix3 rotation, double scale) {
            this.originalShape = originalShape;
            this.transformedShape = transformedShape;
            this.rotation = rotation;
            this.scale = scale;
        }
    }
}

