/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.IntBox;

public class FlippingFloorSquareForm
extends PortalGenForm {
    public static final ListCodec<Block> blockListCodec = new ListCodec(Registry.f_122824_.m_194605_());
    public static final Codec<FlippingFloorSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("length").forGetter(o -> o.length), (App)SimpleBlockPredicate.codec.fieldOf("frame_block").forGetter(o -> o.frameBlock), (App)SimpleBlockPredicate.codec.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.codec.optionalFieldOf("up_frame_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.upFrameBlock), (App)SimpleBlockPredicate.codec.optionalFieldOf("bottom_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.bottomBlock)).apply((Applicative)instance, instance.stable(FlippingFloorSquareForm::new)));
    public final int length;
    public final SimpleBlockPredicate frameBlock;
    public final SimpleBlockPredicate areaBlock;
    public final SimpleBlockPredicate upFrameBlock;
    public final SimpleBlockPredicate bottomBlock;

    public FlippingFloorSquareForm(int length, SimpleBlockPredicate frameBlock, SimpleBlockPredicate areaBlock, SimpleBlockPredicate upFrameBlock, SimpleBlockPredicate bottomBlock) {
        this.length = length;
        this.frameBlock = frameBlock;
        this.areaBlock = areaBlock;
        this.upFrameBlock = upFrameBlock;
        this.bottomBlock = bottomBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerLevel fromWorld, BlockPos startingPos, ServerLevel toWorld, @Nullable Entity triggeringEntity) {
        SimpleBlockPredicate areaPredicate = this.areaBlock;
        SimpleBlockPredicate framePredicate = this.frameBlock;
        SimpleBlockPredicate bottomPredicate = this.bottomBlock;
        if (!areaPredicate.test(fromWorld.m_8055_(startingPos))) {
            return false;
        }
        if (!bottomPredicate.test(fromWorld.m_8055_(startingPos.m_7495_()))) {
            return false;
        }
        BlockPortalShape fromShape = BlockPortalShape.findArea(startingPos, Direction.Axis.Y, blockPos -> areaPredicate.test(fromWorld.m_8055_(blockPos)), blockPos -> framePredicate.test(fromWorld.m_8055_(blockPos)));
        if (fromShape == null) {
            return false;
        }
        if (!this.checkFromShape(fromWorld, fromShape)) {
            return false;
        }
        BlockPos areaSize = fromShape.innerAreaBox.getSize();
        BlockPos toPos = cpg.mapPosition(fromShape.innerAreaBox.l, fromWorld, toWorld);
        IntBox placingBox = FlippingFloorSquareForm.findPortalPlacement(toWorld, areaSize, toPos);
        BlockPos offset = placingBox.l.m_141950_((Vec3i)fromShape.innerAreaBox.l);
        BlockPortalShape toShape = fromShape.getShapeWithMovedAnchor(fromShape.anchor.m_141952_((Vec3i)offset));
        fromShape.frameAreaWithoutCorner.forEach(fromWorldPos -> {
            BlockPos toWorldPos = fromWorldPos.m_141952_((Vec3i)offset);
            toWorld.m_46597_(toWorldPos, fromWorld.m_8055_(fromWorldPos));
            toWorld.m_46597_(toWorldPos.m_7494_(), fromWorld.m_8055_(fromWorldPos.m_7494_()));
        });
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, toShape);
        Portal[] portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, fromShape, toShape);
        cpg.onPortalsGenerated(portals);
        return true;
    }

    public boolean checkFromShape(ServerLevel fromWorld, BlockPortalShape fromShape) {
        boolean areaSizeTest = BlockPortalShape.isSquareShape(fromShape, this.length);
        if (!areaSizeTest) {
            return false;
        }
        return fromShape.frameAreaWithoutCorner.stream().allMatch(blockPos -> this.upFrameBlock.test(fromWorld.m_8055_(blockPos.m_7494_()))) && fromShape.area.stream().allMatch(blockPos -> this.bottomBlock.test(fromWorld.m_8055_(blockPos.m_7495_())));
    }

    public static IntBox findPortalPlacement(ServerLevel toWorld, BlockPos areaSize, BlockPos toPos) {
        return IntStream.range(toPos.m_123341_() - 8, toPos.m_123341_() + 8).boxed().flatMap(x -> IntStream.range(toPos.m_123343_() - 8, toPos.m_123343_() + 8).boxed().flatMap(z -> IntStream.range(McHelper.getMinY((LevelAccessor)toWorld) + 5, McHelper.getMaxContentYExclusive((LevelAccessor)toWorld) - 5).map(y -> McHelper.getMaxContentYExclusive((LevelAccessor)toWorld) - y).mapToObj(y -> new BlockPos(x.intValue(), y, z.intValue())))).map(blockPos -> IntBox.getBoxByBasePointAndSize(areaSize, blockPos)).filter(intBox -> intBox.stream().allMatch(pos -> {
            BlockState blockState = toWorld.m_8055_(pos);
            return !blockState.m_60804_((BlockGetter)toWorld, pos) && blockState.m_60734_() != IPRegistry.NETHER_PORTAL_BLOCK.get() && blockState.m_60819_().m_76178_();
        })).filter(intBox -> intBox.getSurfaceLayer(Direction.DOWN).getMoved(Direction.DOWN.m_122436_()).stream().allMatch(blockPos -> {
            BlockState blockState = toWorld.m_8055_(blockPos);
            return !blockState.m_60795_() && blockState.m_60734_() != IPRegistry.NETHER_PORTAL_BLOCK.get();
        })).findFirst().orElseGet(() -> IntBox.getBoxByBasePointAndSize(areaSize, toPos)).getMoved(Direction.DOWN.m_122436_());
    }

    public static GeneralBreakablePortal[] createPortals(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape, BlockPortalShape toShape) {
        GeneralBreakablePortal pa = (GeneralBreakablePortal)GeneralBreakablePortal.entityType.m_20615_((Level)fromWorld);
        fromShape.initPortalPosAxisShape(pa, true);
        pa.setDestination(toShape.innerAreaBox.getCenterVec());
        pa.dimensionTo = toWorld.m_46472_();
        pa.rotation = new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 180.0f, true);
        GeneralBreakablePortal pb = PortalManipulation.createReversePortal(pa, GeneralBreakablePortal.entityType);
        pa.blockPortalShape = fromShape;
        pb.blockPortalShape = toShape;
        pa.reversePortalId = pb.m_142081_();
        pb.reversePortalId = pa.m_142081_();
        PortalExtension.get((Portal)pa).motionAffinity = 0.1;
        PortalExtension.get((Portal)pb).motionAffinity = 0.1;
        McHelper.spawnServerEntity(pa);
        McHelper.spawnServerEntity(pb);
        return new GeneralBreakablePortal[]{pa, pb};
    }
}

