/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import com.google.common.base.Supplier;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.q_misc_util.my_util.IntBox;

public class BorderBarrierFiller {
    private static final WeakHashMap<ServerPlayer, Object> warnedPlayers = new WeakHashMap();

    public static void onCommandExecuted(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.f_19853_;
        Vec3 playerPos = player.m_20182_();
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.getArea().m_82390_(playerPos)).findFirst().orElse(null);
        if (zone == null) {
            player.m_5661_((Component)new TranslatableComponent("imm_ptl.cannot_find_zone"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    public static void onCommandExecuted(ServerPlayer player, int zoneId) {
        ServerLevel world = (ServerLevel)player.f_19853_;
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone == null) {
            player.m_5661_((Component)new TranslatableComponent("imm_ptl.cannot_find_zone"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    private static void doInvoke(ServerPlayer player, ServerLevel world, WorldWrappingPortal.WrappingZone zone) {
        IntBox borderBox = zone.getBorderBox();
        boolean warned = warnedPlayers.containsKey(player);
        if (!warned) {
            warnedPlayers.put(player, null);
            BlockPos size = borderBox.getSize();
            int totalColumns = size.m_123341_() * 2 + size.m_123343_() * 2;
            double sizeEstimationGB = (double)totalColumns / 80000.0 * 0.5;
            player.m_5661_((Component)new TranslatableComponent("imm_ptl.clear_border_warning", new Object[]{sizeEstimationGB < 0.01 ? 0.0 : sizeEstimationGB}), false);
        } else {
            warnedPlayers.remove(player);
            player.m_5661_((Component)new TranslatableComponent("imm_ptl.start_clearing_border"), false);
            BorderBarrierFiller.startFillingBorder(world, borderBox, l -> player.m_5661_(l, false));
        }
    }

    private static void startFillingBorder(ServerLevel world, IntBox borderBox, Consumer<Component> informer) {
        Supplier xStream = () -> IntStream.range(borderBox.l.m_123341_(), borderBox.h.m_123341_() + 1);
        Supplier zStream = () -> IntStream.range(borderBox.l.m_123343_(), borderBox.h.m_123343_() + 1);
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos temp1 = new BlockPos.MutableBlockPos();
        Stream stream = Streams.concat((Stream[])new Stream[]{((IntStream)xStream.get()).mapToObj(x -> temp.m_122178_(x, 0, borderBox.l.m_123343_())), ((IntStream)xStream.get()).mapToObj(x -> temp.m_122178_(x, 0, borderBox.h.m_123343_())), ((IntStream)zStream.get()).mapToObj(z -> temp.m_122178_(borderBox.l.m_123341_(), 0, z)), ((IntStream)zStream.get()).mapToObj(z -> temp.m_122178_(borderBox.h.m_123341_(), 0, z))});
        BlockPos size = borderBox.getSize();
        int totalColumns = size.m_123341_() * 2 + size.m_123343_() * 2;
        int worldHeight = world.m_141928_();
        ThreadedLevelLightEngine lightingProvider = world.m_7726_().m_7827_();
        McHelper.performMultiThreadedFindingTaskOnServer(stream, columnPos -> {
            ChunkAccess chunk = world.m_46865_((BlockPos)columnPos);
            for (int y = 0; y < worldHeight; ++y) {
                temp1.m_122178_(columnPos.m_123341_(), y, columnPos.m_123343_());
                chunk.m_6978_((BlockPos)temp1, Blocks.f_50016_.m_49966_(), false);
                lightingProvider.m_142202_((BlockPos)temp1);
            }
            return false;
        }, columns -> {
            if (McHelper.getServerGameTime() % 20L == 0L) {
                informer.accept((Component)new TextComponent(String.format("Progress: %d / %d", columns, totalColumns)));
            }
            return true;
        }, e -> {}, () -> informer.accept((Component)new TranslatableComponent("imm_ptl.finished_clearing_border")), () -> {});
    }
}

