/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;

public class NetherPortalEntity
extends BreakablePortalEntity {
    public static EntityType<NetherPortalEntity> entityType = (EntityType)IPRegistry.NETHER_PORTAL_NEW.get();

    public NetherPortalEntity(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.updateClientSideOverlayInfo();
        }
    }

    @Override
    protected boolean isPortalIntactOnThisSide() {
        return this.blockPortalShape.area.stream().allMatch(blockPos -> this.f_19853_.m_8055_(blockPos).m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) && this.blockPortalShape.frameAreaWithoutCorner.stream().allMatch(blockPos -> O_O.isObsidian(this.f_19853_.m_8055_(blockPos)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addSoundAndParticle() {
        if (!IPGlobal.enableNetherPortalEffect) {
            return;
        }
        Random random = this.f_19853_.m_5822_();
        for (int i = 0; i < (int)Math.ceil(this.width * this.height / 20.0); ++i) {
            if (random.nextInt(10) != 0) continue;
            double px = (random.nextDouble() * 2.0 - 1.0) * (this.width / 2.0);
            double py = (random.nextDouble() * 2.0 - 1.0) * (this.height / 2.0);
            Vec3 pos = this.getPointInPlane(px, py);
            double speedMultiplier = 20.0;
            double vx = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            double vy = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            double vz = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vx, vy, vz);
        }
        if (random.nextInt(800) == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
    }

    void updateClientSideOverlayInfo() {
        if (!IPGlobal.netherPortalOverlay) {
            this.overlayInfo = null;
            return;
        }
        if (this.overlayInfo != null) {
            return;
        }
        Direction.Axis axis = this.blockPortalShape.axis;
        switch (axis) {
            case X: {
                this.overlayInfo = new BreakablePortalEntity.OverlayInfo((BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)Direction.Axis.Z), 0.5, 0.0, null);
                break;
            }
            case Y: {
                double offset = this.getNormal().f_82480_ > 0.0 ? 1.0 : -1.0;
                this.overlayInfo = new BreakablePortalEntity.OverlayInfo((BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)Direction.Axis.X), 0.5, offset, new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                break;
            }
            case Z: {
                this.overlayInfo = new BreakablePortalEntity.OverlayInfo((BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)Direction.Axis.X), 0.5, 0.0, null);
            }
        }
    }
}

