/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.LenientChunkRegion;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.LoadingIndicatorEntity;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FrameSearching;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalMatcher;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class NetherPortalGeneration {
    private static final LimitedLogger limitedLogger = new LimitedLogger(300);

    public static IntBox findAirCubePlacement(ServerLevel toWorld, BlockPos mappedPosInOtherDimension, Direction.Axis axis, BlockPos neededAreaSize) {
        IntBox foundAirCube;
        BlockPos randomShift = new BlockPos(toWorld.m_5822_().nextBoolean() ? 1 : -1, 0, toWorld.m_5822_().nextBoolean() ? 1 : -1);
        IntBox intBox = foundAirCube = axis == Direction.Axis.Y ? NetherPortalMatcher.findHorizontalPortalPlacement(neededAreaSize, (LevelAccessor)toWorld, mappedPosInOtherDimension.m_141952_((Vec3i)randomShift)) : NetherPortalMatcher.findVerticalPortalPlacement(neededAreaSize, (LevelAccessor)toWorld, mappedPosInOtherDimension.m_141952_((Vec3i)randomShift));
        if (foundAirCube == null) {
            Helper.log("Cannot find normal portal placement");
            foundAirCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(neededAreaSize, (LevelAccessor)toWorld, mappedPosInOtherDimension, 32);
            if (foundAirCube != null && NetherPortalGeneration.isFloating(toWorld, foundAirCube)) {
                foundAirCube = NetherPortalMatcher.levitateBox((LevelAccessor)toWorld, foundAirCube, 50);
            }
        }
        if (foundAirCube == null) {
            Helper.err("Cannot find air cube within 32 blocks? Force placed portal. It will occupy normal blocks.");
            foundAirCube = IntBox.getBoxByBasePointAndSize(neededAreaSize, mappedPosInOtherDimension);
        }
        return foundAirCube;
    }

    private static boolean isFloating(ServerLevel toWorld, IntBox foundAirCube) {
        return foundAirCube.getSurfaceLayer(Direction.DOWN).stream().noneMatch(blockPos -> toWorld.m_8055_(blockPos.m_7495_()).m_60767_().m_76333_());
    }

    public static void setPortalContentBlock(ServerLevel world, BlockPos pos, Direction.Axis normalAxis) {
        world.m_46597_(pos, (BlockState)((Block)IPRegistry.NETHER_PORTAL_BLOCK.get()).m_49966_().m_61124_(PortalPlaceholderBlock.AXIS, (Comparable)normalAxis));
    }

    public static void startGeneratingPortal(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape, BlockPos toPos, int existingFrameSearchingRadius, Predicate<BlockState> otherSideFramePredicate, Consumer<BlockPortalShape> newFrameGenerateFunc, Consumer<PortalGenInfo> portalEntityGeneratingFunc, Supplier<PortalGenInfo> newFramePlacer, BooleanSupplier portalIntegrityChecker, Function<WorldGenRegion, Function<BlockPos.MutableBlockPos, PortalGenInfo>> matchShapeByFramePos) {
        ResourceKey fromDimension = fromWorld.m_46472_();
        ResourceKey toDimension = toWorld.m_46472_();
        Vec3 indicatorPos = fromShape.innerAreaBox.getCenterVec();
        LoadingIndicatorEntity indicatorEntity = (LoadingIndicatorEntity)((EntityType)IPRegistry.LOADING_INDICATOR.get()).m_20615_((Level)fromWorld);
        indicatorEntity.isValid = true;
        indicatorEntity.portalShape = fromShape;
        indicatorEntity.m_6034_(indicatorPos.f_82479_, indicatorPos.f_82480_, indicatorPos.f_82481_);
        fromWorld.m_7967_((Entity)indicatorEntity);
        Runnable onGenerateNewFrame = () -> {
            indicatorEntity.inform((Component)new TranslatableComponent("imm_ptl.generating_new_frame"));
            PortalGenInfo info = (PortalGenInfo)newFramePlacer.get();
            if (info != null) {
                newFrameGenerateFunc.accept(info.toShape);
                portalEntityGeneratingFunc.accept(info);
                O_O.postPortalSpawnEventForge(info);
            }
        };
        boolean otherSideChunkAlreadyGenerated = McHelper.getIsServerChunkGenerated((ResourceKey<Level>)toDimension, toPos);
        int frameSearchingRadius = Math.floorDiv(existingFrameSearchingRadius, 16) + 1;
        int loaderRadius = otherSideChunkAlreadyGenerated ? frameSearchingRadius : 1;
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos((ResourceKey<Level>)toDimension, new ChunkPos(toPos)), loaderRadius);
        NewChunkTrackingGraph.addGlobalAdditionalChunkLoader(chunkLoader);
        Runnable finalizer = () -> {
            indicatorEntity.m_142687_(Entity.RemovalReason.KILLED);
            NewChunkTrackingGraph.removeGlobalAdditionalChunkLoader(chunkLoader);
        };
        IPGlobal.serverTaskList.addTask(() -> {
            int allChunksNeedsLoading;
            boolean isPortalIntact = portalIntegrityChecker.getAsBoolean();
            if (!isPortalIntact) {
                finalizer.run();
                return true;
            }
            int loadedChunks = chunkLoader.getLoadedChunkNum();
            if (loadedChunks < (allChunksNeedsLoading = chunkLoader.getChunkNum())) {
                indicatorEntity.inform((Component)new TranslatableComponent("imm_ptl.loading_chunks", new Object[]{loadedChunks, allChunksNeedsLoading}));
                return false;
            }
            if (!otherSideChunkAlreadyGenerated) {
                onGenerateNewFrame.run();
                finalizer.run();
                return true;
            }
            LenientChunkRegion chunkRegion = new ChunkLoader(chunkLoader.center, frameSearchingRadius).createChunkRegion();
            indicatorEntity.inform((Component)new TranslatableComponent("imm_ptl.searching_for_frame"));
            BlockPos.MutableBlockPos temp1 = new BlockPos.MutableBlockPos();
            FrameSearching.startSearchingPortalFrameAsync(chunkRegion, frameSearchingRadius, toPos, otherSideFramePredicate, (Function)matchShapeByFramePos.apply(chunkRegion), info -> {
                portalEntityGeneratingFunc.accept((PortalGenInfo)info);
                finalizer.run();
                O_O.postPortalSpawnEventForge(info);
            }, () -> {
                onGenerateNewFrame.run();
                finalizer.run();
            });
            return true;
        });
    }

    public static boolean isOtherGenerationRunning(ServerLevel fromWorld, Vec3 indicatorPos) {
        boolean isOtherGenerationRunning = McHelper.getEntitiesNearby((Level)fromWorld, indicatorPos, LoadingIndicatorEntity.class, 1.0).stream().findAny().isPresent();
        if (isOtherGenerationRunning) {
            Helper.log("Aborted Portal Generation Because Another Generation is Running Nearby");
            return true;
        }
        return false;
    }

    public static boolean checkPortalGeneration(ServerLevel fromWorld, BlockPos startingPos) {
        if (!fromWorld.m_46805_(startingPos)) {
            Helper.log("Cancel Portal Generation Because Chunk Not Loaded");
            return false;
        }
        limitedLogger.log(String.format("Portal Generation Attempted %s %s %s %s", fromWorld.m_46472_().m_135782_(), startingPos.m_123341_(), startingPos.m_123342_(), startingPos.m_123343_()));
        return true;
    }

    public static BlockPortalShape findFrameShape(ServerLevel fromWorld, BlockPos startingPos, Predicate<BlockState> thisSideAreaPredicate, Predicate<BlockState> thisSideFramePredicate) {
        return Arrays.stream(Direction.Axis.values()).map(axis -> BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, pos -> thisSideAreaPredicate.test(fromWorld.m_8055_(pos)), pos -> thisSideFramePredicate.test(fromWorld.m_8055_(pos)))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void embodyNewFrame(ServerLevel toWorld, BlockPortalShape toShape, BlockState frameBlockState) {
        toShape.frameAreaWithCorner.forEach(blockPos -> toWorld.m_46597_(blockPos, frameBlockState));
    }

    public static void fillInPlaceHolderBlocks(ServerLevel world, BlockPortalShape blockPortalShape) {
        blockPortalShape.area.forEach(blockPos -> NetherPortalGeneration.setPortalContentBlock(world, blockPos, blockPortalShape.axis));
    }
}

