/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class CrossPortalEntityRenderer {
    private static final Minecraft client = Minecraft.m_91087_();
    private static final WeakHashMap<Entity, Object> collidedEntities = new WeakHashMap();
    public static boolean isRenderingEntityNormally = false;
    public static boolean isRenderingEntityProjection = false;

    public static void init() {
        IPGlobal.postClientTickSignal.connect(CrossPortalEntityRenderer::onClientTick);
        IPGlobal.clientCleanupSignal.connect(CrossPortalEntityRenderer::cleanUp);
        ClientWorldLoader.clientDimensionDynamicRemoveSignal.connect(dim -> CrossPortalEntityRenderer.cleanUp());
    }

    private static void cleanUp() {
        collidedEntities.clear();
    }

    private static void onClientTick() {
        collidedEntities.entrySet().removeIf(entry -> ((Entity)entry.getKey()).m_146910_() || ((IEEntity)entry.getKey()).getCollidingPortal() == null);
    }

    public static void onEntityTickClient(Entity entity) {
        if (entity instanceof Portal) {
            return;
        }
        Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
        if (collidingPortal != null) {
            collidedEntities.put(entity, null);
        }
    }

    public static void onBeginRenderingEntities(PoseStack matrixStack) {
        isRenderingEntityNormally = true;
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getRenderingPortal(), false, matrixStack);
        }
    }

    private static boolean isCrossPortalRenderingEnabled() {
        if (IrisInterface.invoker.isIrisPresent()) {
            return false;
        }
        return IPGlobal.correctCrossPortalEntityRendering;
    }

    public static void onEndRenderingEntities(PoseStack matrixStack) {
        isRenderingEntityNormally = false;
        FrontClipping.disableClipping();
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        CrossPortalEntityRenderer.renderEntityProjections(matrixStack);
    }

    public static void beforeRenderingEntity(Entity entity, PoseStack matrixStack) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (collidingPortal == null) {
                return;
            }
            client.m_91269_().m_110104_().m_109911_();
            FrontClipping.setupOuterClipping(matrixStack, collidingPortal);
        }
    }

    public static void afterRenderingEntity(Entity entity) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            client.m_91269_().m_110104_().m_109911_();
            FrontClipping.disableClipping();
        }
    }

    private static void renderEntityProjections(PoseStack matrixStack) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        collidedEntities.keySet().forEach(entity -> {
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (collidingPortal == null) {
                return;
            }
            if (collidingPortal instanceof Mirror) {
                return;
            }
            ResourceKey<Level> projectionDimension = collidingPortal.dimensionTo;
            if (CrossPortalEntityRenderer.client.f_91073_.m_46472_() == projectionDimension) {
                CrossPortalEntityRenderer.renderProjectedEntity(entity, collidingPortal, matrixStack);
            }
        });
    }

    public static boolean hasIntersection(Vec3 outerPlanePos, Vec3 outerPlaneNormal, Vec3 entityPos, Vec3 collidingPortalNormal) {
        return entityPos.m_82546_(outerPlanePos).m_82526_(outerPlaneNormal) > 0.01 && outerPlanePos.m_82546_(entityPos).m_82526_(collidingPortalNormal) > 0.01;
    }

    private static void renderProjectedEntity(Entity entity, Portal collidingPortal, PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal instanceof Portal && !Portal.isFlippedPortal((Portal)renderingPortal, collidingPortal) && !Portal.isReversePortal((Portal)renderingPortal, collidingPortal)) {
                boolean isHidden;
                Vec3 cameraPos = CrossPortalEntityRenderer.client.f_91063_.m_109153_().m_90583_();
                boolean bl = isHidden = cameraPos.m_82546_(collidingPortal.getDestPos()).m_82526_(collidingPortal.getContentDirection()) < 0.0;
                if (renderingPortal == collidingPortal || !isHidden) {
                    CrossPortalEntityRenderer.renderEntityRegardingPlayer(entity, collidingPortal, matrixStack);
                }
            }
        } else {
            FrontClipping.disableClipping();
            client.m_91269_().m_110104_().m_109911_();
            FrontClipping.setupInnerClipping(collidingPortal, false, matrixStack);
            CrossPortalEntityRenderer.renderEntityRegardingPlayer(entity, collidingPortal, matrixStack);
            FrontClipping.disableClipping();
        }
    }

    private static void renderEntityRegardingPlayer(Entity entity, Portal transformingPortal, PoseStack matrixStack) {
        if (entity instanceof LocalPlayer) {
            MyGameRenderer.renderPlayerItself(() -> CrossPortalEntityRenderer.renderEntity(entity, transformingPortal, matrixStack));
        } else {
            CrossPortalEntityRenderer.renderEntity(entity, transformingPortal, matrixStack);
        }
    }

    private static void renderEntity(Entity entity, Portal transformingPortal, PoseStack matrixStack) {
        Vec3 cameraPos = CrossPortalEntityRenderer.client.f_91063_.m_109153_().m_90583_();
        ClientLevel newWorld = ClientWorldLoader.getWorld(transformingPortal.dimensionTo);
        Vec3 oldEyePos = McHelper.getEyePos(entity);
        Vec3 oldLastTickEyePos = McHelper.getLastTickEyePos(entity);
        Level oldWorld = entity.f_19853_;
        Vec3 newEyePos = transformingPortal.transformPoint(oldEyePos);
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            Vec3 transformedEntityPos = newEyePos.m_82546_(McHelper.getEyeOffset(entity));
            AABB transformedBoundingBox = McHelper.getBoundingBoxWithMovedPosition(entity, transformedEntityPos);
            boolean intersects = PortalManipulation.isOtherSideBoxInside(transformedBoundingBox, renderingPortal);
            if (!intersects) {
                return;
            }
        }
        if (entity instanceof LocalPlayer) {
            if (!IPGlobal.renderYourselfInPortal) {
                return;
            }
            if (!transformingPortal.getDoRenderPlayer()) {
                return;
            }
            if (CrossPortalEntityRenderer.client.f_91066_.m_92176_().m_90612_()) {
                double dis = newEyePos.m_82554_(cameraPos);
                double valve = 0.5 + McHelper.lastTickPosOf(entity).m_82554_(entity.m_20182_());
                if (transformingPortal.scaling > 1.0) {
                    valve *= transformingPortal.scaling;
                }
                if (dis < valve) {
                    return;
                }
                AABB transformedBoundingBox = Helper.transformBox(RenderStates.originalPlayerBoundingBox, transformingPortal::transformPoint);
                if (transformedBoundingBox.m_82390_(CHelper.getCurrentCameraPos())) {
                    return;
                }
            }
        }
        McHelper.setEyePos(entity, newEyePos, transformingPortal.transformPoint(oldLastTickEyePos));
        entity.f_19853_ = newWorld;
        isRenderingEntityProjection = true;
        matrixStack.m_85836_();
        CrossPortalEntityRenderer.setupEntityProjectionRenderingTransformation(transformingPortal, entity, matrixStack);
        MultiBufferSource.BufferSource consumers = client.m_91269_().m_110104_();
        ((IEWorldRenderer)CrossPortalEntityRenderer.client.f_91060_).ip_myRenderEntity(entity, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_, RenderStates.tickDelta, matrixStack, (MultiBufferSource)consumers);
        consumers.m_109911_();
        matrixStack.m_85849_();
        isRenderingEntityProjection = false;
        McHelper.setEyePos(entity, oldEyePos, oldLastTickEyePos);
        entity.f_19853_ = oldWorld;
    }

    private static void setupEntityProjectionRenderingTransformation(Portal portal, Entity entity, PoseStack matrixStack) {
        if (portal.scaling == 1.0 && portal.rotation == null) {
            return;
        }
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        Vec3 anchor = entity.m_20299_(RenderStates.tickDelta).m_82546_(cameraPos);
        matrixStack.m_85837_(anchor.f_82479_, anchor.f_82480_, anchor.f_82481_);
        float scaling = (float)portal.scaling;
        matrixStack.m_85841_(scaling, scaling, scaling);
        if (portal.rotation != null) {
            matrixStack.m_85845_(portal.rotation);
        }
        matrixStack.m_85837_(-anchor.f_82479_, -anchor.f_82480_, -anchor.f_82481_);
    }

    public static boolean shouldRenderPlayerDefault() {
        if (!IPGlobal.renderYourselfInPortal) {
            return false;
        }
        if (!WorldRenderInfo.isRendering()) {
            return false;
        }
        return CrossPortalEntityRenderer.client.f_91075_.f_19853_.m_46472_() == RenderStates.originalPlayerDimension;
    }

    public static boolean shouldRenderEntityNow(Entity entity) {
        Validate.notNull((Object)entity);
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return true;
        }
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (entity instanceof Player && !renderingPortal.getDoRenderPlayer()) {
                return false;
            }
            if (collidingPortal != null && !(entity instanceof LocalPlayer) && renderingPortal instanceof Portal && !Portal.isReversePortal(collidingPortal, (Portal)renderingPortal)) {
                boolean isHidden;
                Vec3 cameraPos = PortalRenderer.client.f_91063_.m_109153_().m_90583_();
                boolean bl = isHidden = cameraPos.m_82546_(collidingPortal.getOriginPos()).m_82526_(collidingPortal.getNormal()) < 0.0;
                if (isHidden) {
                    return false;
                }
            }
            return renderingPortal.isInside(CrossPortalEntityRenderer.getRenderingCameraPos(entity), -0.01);
        }
        return true;
    }

    public static boolean shouldRenderPlayerNormally(Entity entity) {
        if (!CrossPortalEntityRenderer.client.f_91066_.m_92176_().m_90612_()) {
            return true;
        }
        if (RenderStates.originalPlayerBoundingBox.m_82390_(CHelper.getCurrentCameraPos())) {
            return false;
        }
        double distanceToCamera = CrossPortalEntityRenderer.getRenderingCameraPos(entity).m_82554_(CrossPortalEntityRenderer.client.f_91063_.m_109153_().m_90583_());
        return distanceToCamera > 1.0 || PortalRendering.isRenderingOddNumberOfMirrors();
    }

    public static Vec3 getRenderingCameraPos(Entity entity) {
        if (entity instanceof LocalPlayer) {
            return RenderStates.originalPlayerPos.m_82549_(McHelper.getEyeOffset(entity));
        }
        return entity.m_20299_(RenderStates.tickDelta);
    }
}

