/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryStack;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@OnlyIn(value=Dist.CLIENT)
public class OverlayRendering {
    private static final Random random = new Random();
    private static boolean shaderOverlayWarned = false;

    public static boolean shouldRenderOverlay(PortalLike portal) {
        if (portal instanceof BreakablePortalEntity) {
            BreakablePortalEntity breakablePortalEntity = (BreakablePortalEntity)portal;
            if (breakablePortalEntity.overlayInfo != null) {
                return breakablePortalEntity.isInFrontOfPortal(CHelper.getCurrentCameraPos());
            }
        }
        return false;
    }

    public static void onRenderPortalEntity(PortalLike portal, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        if (IrisInterface.invoker.isShaders()) {
            if (!shaderOverlayWarned) {
                shaderOverlayWarned = true;
                CHelper.printChat("[Immersive Portals] Portal overlay cannot be rendered with shaders");
            }
            return;
        }
        if (portal instanceof BreakablePortalEntity) {
            OverlayRendering.renderBreakablePortalOverlay((BreakablePortalEntity)portal, RenderStates.tickDelta, matrixStack, vertexConsumerProvider);
        }
    }

    public static List<BakedQuad> getQuads(BakedModel model, BlockState blockState, Vec3 portalNormal) {
        Direction facing = Direction.m_122366_((double)portalNormal.f_82479_, (double)portalNormal.f_82480_, (double)portalNormal.f_82481_);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        result.addAll(model.m_6840_(blockState, facing, random));
        result.addAll(model.m_6840_(blockState, null, random));
        if (result.isEmpty()) {
            for (Direction direction : Direction.values()) {
                result.addAll(model.m_6840_(blockState, direction, random));
            }
        }
        return result;
    }

    private static void renderBreakablePortalOverlay(BreakablePortalEntity portal, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        BlockState blockState = portal.overlayInfo.blockState();
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        if (blockState == null) {
            return;
        }
        BlockRenderDispatcher blockRenderManager = Minecraft.m_91087_().m_91289_();
        BlockPortalShape blockPortalShape = portal.blockPortalShape;
        if (blockPortalShape == null) {
            return;
        }
        matrixStack.m_85836_();
        Vec3 offset = portal.getNormal().m_82490_(portal.overlayInfo.offset());
        Vec3 pos = portal.m_20182_();
        matrixStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        BakedModel model = blockRenderManager.m_110910_(blockState);
        RenderType renderLayer = Sheets.m_110792_();
        VertexConsumer buffer = vertexConsumerProvider.m_6299_(renderLayer);
        List<BakedQuad> quads = OverlayRendering.getQuads(model, blockState, portal.getNormal());
        random.setSeed(0L);
        for (BlockPos blockPos : blockPortalShape.area) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)blockPos.m_123341_() - pos.f_82479_, (double)blockPos.m_123342_() - pos.f_82480_, (double)blockPos.m_123343_() - pos.f_82481_);
            if (portal.overlayInfo.rotation() != null) {
                matrixStack.m_85845_(portal.overlayInfo.rotation());
            }
            for (BakedQuad quad : quads) {
                SodiumInterface.invoker.markSpriteActive(quad.m_173410_());
                OverlayRendering.renderQuad(buffer, matrixStack.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, new int[]{0xE000F0, 0xE000F0, 0xE000F0, 0xE000F0}, OverlayTexture.f_118083_, true, (float)portal.overlayInfo.opacity());
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public static void renderQuad(VertexConsumer vertexConsumer, PoseStack.Pose poseEntry, BakedQuad quad, float[] colorMuls, float red, float green, float blue, int[] combinedLights, int combinedOverlay, boolean mulColor, float alpha) {
        float[] fs = new float[]{colorMuls[0], colorMuls[1], colorMuls[2], colorMuls[3]};
        int[] is = new int[]{combinedLights[0], combinedLights[1], combinedLights[2], combinedLights[3]};
        int[] js = quad.m_111303_();
        Vec3i vec3i = quad.m_111306_().m_122436_();
        Vector3f vector3f = new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_());
        Matrix4f matrix4f = poseEntry.m_85861_();
        vector3f.m_122249_(poseEntry.m_85864_());
        int i = 8;
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float q;
                float p;
                float o;
                float n;
                float m;
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (mulColor) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    m = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    n = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    o = l * fs[k] * red;
                    p = m * fs[k] * green;
                    q = n * fs[k] * blue;
                } else {
                    o = fs[k] * red;
                    p = fs[k] * green;
                    q = fs[k] * blue;
                }
                int r = is[k];
                m = byteBuffer.getFloat(16);
                n = byteBuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, g, h, 1.0f);
                vector4f.m_123607_(matrix4f);
                vertexConsumer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), o, p, q, alpha, m, n, combinedOverlay, r, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            }
        }
    }
}

