/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public abstract class PortalRenderer {
    public static final Minecraft client = Minecraft.m_91087_();

    public abstract void onBeforeTranslucentRendering(PoseStack var1);

    public abstract void onAfterTranslucentRendering(PoseStack var1);

    public abstract void onHandRenderingEnded(PoseStack var1);

    public void onBeforeHandRendering(PoseStack matrixStack) {
    }

    public abstract void prepareRendering();

    public abstract void finishRendering();

    public abstract void renderPortalInEntityRenderer(Portal var1);

    public abstract boolean replaceFrameBufferClearing();

    protected List<PortalLike> getPortalsToRender(PoseStack matrixStack) {
        Validate.isTrue((PortalRenderer.client.f_91075_.f_19853_ == PortalRenderer.client.f_91073_ ? 1 : 0) != 0);
        Supplier<Frustum> frustumSupplier = Helper.cached(() -> {
            Frustum frustum = new Frustum(matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_());
            Vec3 cameraPos = PortalRenderer.client.f_91063_.m_109153_().m_90583_();
            frustum.m_113002_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
            return frustum;
        });
        ArrayList<PortalLike> portalsToRender = new ArrayList<PortalLike>();
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals((Level)PortalRenderer.client.f_91073_);
        for (Portal globalPortal : globalPortals) {
            if (PortalRenderer.shouldSkipRenderingPortal(globalPortal, frustumSupplier)) continue;
            portalsToRender.add(globalPortal);
        }
        PortalRenderer.client.f_91073_.m_104735_().forEach(e -> {
            Portal portal;
            if (e instanceof Portal && !PortalRenderer.shouldSkipRenderingPortal(portal = (Portal)e, frustumSupplier)) {
                PortalLike renderingDelegate = portal.getRenderingDelegate();
                if (renderingDelegate != portal) {
                    if (!portalsToRender.contains(renderingDelegate)) {
                        portalsToRender.add(renderingDelegate);
                    }
                } else {
                    portalsToRender.add(renderingDelegate);
                }
            }
        });
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        portalsToRender.sort(Comparator.comparingDouble(portalEntity -> portalEntity.getDistanceToNearestPointInPortal(cameraPos)));
        return portalsToRender;
    }

    private static boolean shouldSkipRenderingPortal(Portal portal, Supplier<Frustum> frustumSupplier) {
        Frustum frustum;
        PortalLike outerPortal;
        if (!portal.isPortalValid()) {
            return true;
        }
        if (RenderStates.getRenderedPortalNum() >= IPGlobal.portalRenderLimit) {
            return true;
        }
        Vec3 cameraPos = TransformationManager.getIsometricAdjustedCameraPos();
        if (!portal.isRoughlyVisibleTo(cameraPos)) {
            return true;
        }
        if (PortalRendering.isRendering() && (outerPortal = PortalRendering.getRenderingPortal()).cannotRenderInMe(portal)) {
            return true;
        }
        double distance = portal.getDistanceToNearestPointInPortal(cameraPos);
        if (distance > PortalRenderer.getRenderRange()) {
            return true;
        }
        return IPCGlobal.earlyFrustumCullingPortal && distance > 0.03 && !(frustum = frustumSupplier.get()).m_113029_(portal.getExactAreaBox());
    }

    public static double getRenderRange() {
        double outerPortalScale;
        double range = PortalRenderer.client.f_91066_.f_92106_ * 16;
        if (RenderStates.isLaggy || IPGlobal.reducedPortalRendering) {
            range = 16.0;
        }
        if (PortalRendering.getPortalLayer() > 1) {
            range /= (double)PortalRendering.getPortalLayer();
        }
        if (PortalRendering.getPortalLayer() >= 1 && (outerPortalScale = PortalRendering.getRenderingPortal().getScale()) > 2.0) {
            range *= outerPortalScale;
            range = Math.min(range, 512.0);
        }
        return range;
    }

    protected final void renderPortalContent(PortalLike portal) {
        if (PortalRendering.getPortalLayer() > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        Entity cameraEntity = PortalRenderer.client.f_91075_;
        ClientLevel newWorld = ClientWorldLoader.getWorld(portal.getDestDim());
        Camera camera = PortalRenderer.client.f_91063_.m_109153_();
        PortalRendering.onBeginPortalWorldRendering();
        int renderDistance = PortalRenderer.getPortalRenderDistance(portal);
        this.invokeWorldRendering(new WorldRenderInfo(newWorld, PortalRendering.getRenderingCameraPos(), portal.getAdditionalCameraTransformation(), false, portal.getDiscriminator(), renderDistance));
        PortalRendering.onEndPortalWorldRendering();
        GlStateManager.m_84513_();
        MyRenderHelper.restoreViewPort();
    }

    private static int getPortalRenderDistance(PortalLike portal) {
        if (portal.getScale() > 2.0) {
            double radiusBlocks = portal.getDestAreaRadiusEstimation() * 1.4;
            radiusBlocks = Math.min(radiusBlocks, 512.0);
            return Math.max((int)(radiusBlocks / 16.0), PortalRenderer.client.f_91066_.f_92106_);
        }
        if (IPGlobal.reducedPortalRendering) {
            return PortalRenderer.client.f_91066_.f_92106_ / 3;
        }
        return PortalRenderer.client.f_91066_.f_92106_;
    }

    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Nullable
    public static Matrix4f getPortalTransformation(Portal portal) {
        Matrix4f rot = PortalRenderer.getPortalRotationMatrix(portal);
        Matrix4f mirror = portal instanceof Mirror ? TransformationManager.getMirrorTransformation(portal.getNormal()) : null;
        Matrix4f scale = PortalRenderer.getPortalScaleMatrix(portal);
        return PortalRenderer.combineNullable(rot, PortalRenderer.combineNullable(mirror, scale));
    }

    @Nullable
    public static Matrix4f getPortalRotationMatrix(Portal portal) {
        if (portal.rotation == null) {
            return null;
        }
        Quaternion rot = portal.rotation.m_80161_();
        rot.m_80157_();
        return new Matrix4f(rot);
    }

    @Nullable
    public static Matrix4f combineNullable(@Nullable Matrix4f a, @Nullable Matrix4f b) {
        return Helper.combineNullable(a, b, (m1, m2) -> {
            m1.m_27644_(m2);
            return m1;
        });
    }

    @Nullable
    public static Matrix4f getPortalScaleMatrix(Portal portal) {
        if (PortalRenderer.shouldApplyScaleToModelView(portal)) {
            float v = (float)(1.0 / portal.getScale());
            return Matrix4f.m_27632_((float)v, (float)v, (float)v);
        }
        return null;
    }

    public static boolean shouldApplyScaleToModelView(PortalLike portal) {
        return portal.hasScaling() && portal.isFuseView();
    }

    public void onBeginIrisTranslucentRendering(PoseStack matrixStack) {
    }
}

