/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEMatrix4f;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

@OnlyIn(value=Dist.CLIENT)
public class TransformationManager {
    private static DQuaternion interpolationStart;
    private static DQuaternion lastCameraRotation;
    private static long interpolationStartTime;
    private static long interpolationEndTime;
    public static final Minecraft client;
    public static boolean isIsometricView;
    public static float isometricViewLength;
    public static boolean isCalculatingViewBobbingOffset;

    private static DQuaternion getNormalCameraRotation(Direction gravityDirection, float pitch, float yaw) {
        DQuaternion extra = GravityChangerInterface.invoker.getExtraCameraRotation(gravityDirection);
        DQuaternion cameraRotation = DQuaternion.getCameraRotation(pitch, yaw);
        if (extra == null) {
            return cameraRotation;
        }
        return cameraRotation.hamiltonProduct(extra);
    }

    public static void processTransformation(Camera camera, PoseStack matrixStack) {
        if (TransformationManager.isAnimationRunning()) {
            matrixStack.m_85850_().m_85861_().m_27624_();
            matrixStack.m_85850_().m_85864_().m_8180_();
            Direction gravityDir = GravityChangerInterface.invoker.getGravityDirection((Player)TransformationManager.client.f_91074_);
            DQuaternion cameraRotation = TransformationManager.getNormalCameraRotation(gravityDir, camera.m_90589_(), camera.m_90590_());
            DQuaternion finalRotation = TransformationManager.getAnimatedCameraRotation(cameraRotation);
            matrixStack.m_85845_(finalRotation.toMcQuaternion());
        }
        WorldRenderInfo.applyAdditionalTransformations(matrixStack);
    }

    public static boolean isAnimationRunning() {
        if (interpolationStartTime == 0L) {
            return false;
        }
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        return progress >= -0.1 && progress <= 1.1;
    }

    public static DQuaternion getAnimatedCameraRotation(DQuaternion cameraRotation) {
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        if (progress < 0.0 || progress >= 1.0) {
            return cameraRotation;
        }
        progress = TransformationManager.mapProgress(progress);
        DQuaternion cameraRotDelta = cameraRotation.hamiltonProduct(lastCameraRotation.getConjugated());
        interpolationStart = interpolationStart.hamiltonProduct(cameraRotDelta);
        lastCameraRotation = cameraRotation;
        return DQuaternion.interpolate(interpolationStart, cameraRotation, progress);
    }

    public static double mapProgress(double progress) {
        return Math.sin(progress * 1.5707963267948966);
    }

    public static void managePlayerRotationAndChangeGravity(Portal portal) {
        if (portal.rotation != null) {
            DQuaternion newExtraCameraRot;
            Direction newGravityDir;
            LocalPlayer player = TransformationManager.client.f_91074_;
            Direction oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((Player)player);
            DQuaternion oldCameraRotation = TransformationManager.getNormalCameraRotation(oldGravityDir, player.m_5686_(RenderStates.tickDelta), player.m_5675_(RenderStates.tickDelta));
            DQuaternion currentCameraRotationInterpolated = TransformationManager.getAnimatedCameraRotation(oldCameraRotation);
            DQuaternion cameraRotationThroughPortal = currentCameraRotationInterpolated.hamiltonProduct(DQuaternion.fromMcQuaternion(portal.rotation).getConjugated());
            Direction direction = newGravityDir = portal.getTeleportChangesGravity() ? portal.getTransformedGravityDirection(oldGravityDir) : oldGravityDir;
            if (newGravityDir != oldGravityDir) {
                GravityChangerInterface.invoker.setGravityDirection((Entity)player, newGravityDir);
            }
            DQuaternion newCameraRotationWithNormalGravity = (newExtraCameraRot = GravityChangerInterface.invoker.getExtraCameraRotation(newGravityDir)) != null ? cameraRotationThroughPortal.hamiltonProduct(newExtraCameraRot.getConjugated()) : cameraRotationThroughPortal;
            Tuple<Double, Double> pitchYaw = DQuaternion.getPitchYawFromRotation(newCameraRotationWithNormalGravity);
            float finalYaw = (float)((Double)pitchYaw.m_14419_()).doubleValue();
            float finalPitch = (float)((Double)pitchYaw.m_14418_()).doubleValue();
            if (finalPitch > 90.0f) {
                finalPitch = 90.0f - (finalPitch - 90.0f);
            } else if (finalPitch < -90.0f) {
                finalPitch = -90.0f + (-90.0f - finalPitch);
            }
            player.m_146922_(finalYaw);
            player.m_146926_(finalPitch);
            player.f_19859_ = finalYaw;
            player.f_19860_ = finalPitch;
            player.f_108585_ = finalYaw;
            player.f_108586_ = finalPitch;
            player.f_108587_ = finalYaw;
            player.f_108588_ = finalPitch;
            DQuaternion newCameraRotation = TransformationManager.getNormalCameraRotation(newGravityDir, finalPitch, finalYaw);
            if (!DQuaternion.isClose(newCameraRotation, cameraRotationThroughPortal, 0.001f)) {
                interpolationStart = cameraRotationThroughPortal;
                lastCameraRotation = newCameraRotation;
                interpolationStartTime = RenderStates.renderStartNanoTime;
                interpolationEndTime = interpolationStartTime + Helper.secondToNano(TransformationManager.getAnimationDurationSeconds());
            }
            TransformationManager.updateCamera(client);
        }
    }

    private static double getAnimationDurationSeconds() {
        return 1.0;
    }

    private static void updateCamera(Minecraft client) {
        Camera camera = client.f_91063_.m_109153_();
        camera.m_90575_((BlockGetter)client.f_91073_, (Entity)client.f_91074_, !client.f_91066_.m_92176_().m_90612_(), client.f_91066_.m_92176_().m_90613_(), RenderStates.tickDelta);
    }

    public static Matrix4f getMirrorTransformation(Vec3 normal) {
        float x = (float)normal.f_82479_;
        float y = (float)normal.f_82480_;
        float z = (float)normal.f_82481_;
        float[] arr = new float[]{1.0f - 2.0f * x * x, 0.0f - 2.0f * x * y, 0.0f - 2.0f * x * z, 0.0f, 0.0f - 2.0f * y * x, 1.0f - 2.0f * y * y, 0.0f - 2.0f * y * z, 0.0f, 0.0f - 2.0f * z * x, 0.0f - 2.0f * z * y, 1.0f - 2.0f * z * z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix4f matrix = new Matrix4f();
        ((IEMatrix4f)matrix).loadFromArray(arr);
        return matrix;
    }

    public static Matrix4f getIsometricProjection() {
        int w = client.m_91268_().m_85441_();
        int h = client.m_91268_().m_85442_();
        float wView = isometricViewLength / (float)h * (float)w;
        float near = -2000.0f;
        float far = 2000.0f;
        float left = -wView / 2.0f;
        float right = wView / 2.0f;
        float top = isometricViewLength / 2.0f;
        float bottom = -isometricViewLength / 2.0f;
        float[] arr = new float[]{2.0f / (right - left), 0.0f, 0.0f, -(right + left) / (right - left), 0.0f, 2.0f / (top - bottom), 0.0f, -(top + bottom) / (top - bottom), 0.0f, 0.0f, -2.0f / (far - near), -(far + near) / (far - near), 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix4f m1 = new Matrix4f();
        ((IEMatrix4f)m1).loadFromArray(arr);
        return m1;
    }

    public static Vec3 getIsometricAdjustedCameraPos() {
        Camera camera = TransformationManager.client.f_91063_.m_109153_();
        return TransformationManager.getIsometricAdjustedCameraPos(camera);
    }

    public static Vec3 getIsometricAdjustedCameraPos(Camera camera) {
        Vec3 cameraPos = camera.m_90583_();
        if (!isIsometricView) {
            return cameraPos;
        }
        Quaternion rotation = camera.m_90591_();
        Vector3f vec = new Vector3f(0.0f, 0.0f, (float)(TransformationManager.client.f_91066_.f_92106_ * -10));
        vec.m_122251_(rotation);
        return cameraPos.m_82520_((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
    }

    static {
        interpolationStartTime = 0L;
        interpolationEndTime = 1L;
        client = Minecraft.m_91087_();
        isIsometricView = false;
        isometricViewLength = 50.0f;
        isCalculatingViewBobbingOffset = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RemoteCallables {
        public static void enableIsometricView(float viewLength) {
            isometricViewLength = viewLength;
            isIsometricView = true;
            TransformationManager.client.f_90980_ = false;
        }

        public static void disableIsometricView() {
            isIsometricView = false;
            TransformationManager.client.f_90980_ = true;
        }
    }
}

