/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class ViewAreaRenderer {
    public static void renderPortalArea(PortalLike portal, Vec3 fogColor, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean doFaceCulling, boolean doModifyColor, boolean doModifyDepth) {
        boolean shouldReverseCull;
        if (doFaceCulling) {
            GlStateManager.m_84091_();
        } else {
            GlStateManager.m_84094_();
        }
        if (portal.isFuseView()) {
            GlStateManager.m_84300_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else {
            GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (doModifyDepth) {
            if (portal.isFuseView()) {
                GlStateManager.m_84298_((boolean)false);
            } else {
                GlStateManager.m_84298_((boolean)true);
            }
        } else {
            GlStateManager.m_84298_((boolean)false);
        }
        if (!doModifyColor) {
            GlStateManager.m_84300_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        if (shouldReverseCull = PortalRendering.isRenderingOddNumberOfMirrors()) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
        GlStateManager.m_84513_();
        GlStateManager.m_84110_();
        CHelper.enableDepthClamp();
        ShaderInstance shader = MyRenderHelper.portalAreaShader;
        RenderSystem.m_157427_(() -> shader);
        shader.f_173308_.m_5679_(modelViewMatrix);
        shader.f_173309_.m_5679_(projectionMatrix);
        FrontClipping.updateClippingEquationUniformForCurrentShader(false);
        shader.m_173363_();
        Tesselator tessellator = RenderSystem.m_69883_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(fogColor, portal, bufferBuilder, CHelper.getCurrentCameraPos(), RenderStates.tickDelta);
        boolean realDepthMask = GL11.glGetBoolean((int)2930);
        BufferUploader.m_166847_((BufferBuilder)bufferBuilder);
        shader.m_173362_();
        GlStateManager.m_84109_();
        GlStateManager.m_84091_();
        CHelper.disableDepthClamp();
        GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.m_84298_((boolean)true);
        if (shouldReverseCull) {
            MyRenderHelper.recoverFaceCulling();
        }
        CHelper.checkGlError();
    }

    public static void buildPortalViewAreaTrianglesBuffer(Vec3 fogColor, PortalLike portal, BufferBuilder bufferbuilder, Vec3 cameraPos, float tickDelta) {
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Vec3 posInPlayerCoordinate = portal.getOriginPos().m_82546_(cameraPos);
        Consumer<Vec3> vertexOutput = p -> ViewAreaRenderer.putIntoVertex(bufferbuilder, p, fogColor);
        portal.renderViewAreaMesh(posInPlayerCoordinate, vertexOutput);
        bufferbuilder.m_85721_();
    }

    public static void generateViewAreaTriangles(Portal portal, Vec3 posInPlayerCoordinate, Consumer<Vec3> vertexOutput) {
        if (portal.specialShape == null) {
            if (portal.getIsGlobal()) {
                ViewAreaRenderer.generateTriangleForGlobalPortal(vertexOutput, portal, posInPlayerCoordinate);
            } else {
                ViewAreaRenderer.generateTriangleForNormalShape(vertexOutput, portal, posInPlayerCoordinate);
            }
        } else {
            ViewAreaRenderer.generateTriangleForSpecialShape(vertexOutput, portal, posInPlayerCoordinate);
        }
    }

    public static void generateTriangleForSpecialShape(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        ViewAreaRenderer.generateTriangleSpecial(vertexOutput, portal, posInPlayerCoordinate);
    }

    public static void generateTriangleSpecial(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        GeometryPortalShape specialShape = portal.specialShape;
        for (GeometryPortalShape.TriangleInPlane triangle : specialShape.triangles) {
            Vec3 a = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x1)).m_82549_(portal.axisH.m_82490_(triangle.y1));
            Vec3 b = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x3)).m_82549_(portal.axisH.m_82490_(triangle.y3));
            Vec3 c = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x2)).m_82549_(portal.axisH.m_82490_(triangle.y2));
            vertexOutput.accept(a);
            vertexOutput.accept(b);
            vertexOutput.accept(c);
        }
    }

    private static void putIntoLocalVertex(Consumer<Vec3> vertexOutput, Portal portal, Vec3 offset, Vec3 posInPlayerCoordinate, double localX, double localY) {
        vertexOutput.accept(posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(localX)).m_82549_(portal.axisH.m_82490_(localY)).m_82549_(offset));
    }

    private static void generateTriangleForNormalShape(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        double w = Math.min(portal.width, 23333.0);
        double h = Math.min(portal.height, 23333.0);
        Vec3 v0 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, -h / 2.0 + 0.0);
        Vec3 v1 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, -h / 2.0 + 0.0);
        Vec3 v2 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, h / 2.0 - 0.0);
        Vec3 v3 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, h / 2.0 - 0.0);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.m_82549_(posInPlayerCoordinate), v2.m_82549_(posInPlayerCoordinate), v3.m_82549_(posInPlayerCoordinate), v1.m_82549_(posInPlayerCoordinate));
    }

    private static void generateTriangleForGlobalPortal(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        double distance;
        Vec3 cameraPosLocal = posInPlayerCoordinate.m_82490_(-1.0);
        double cameraLocalX = cameraPosLocal.m_82526_(portal.axisW);
        double cameraLocalY = cameraPosLocal.m_82526_(portal.axisH);
        double r = Minecraft.m_91087_().f_91066_.f_92106_ * 16 - 16;
        if (TransformationManager.isIsometricView) {
            r *= 2.0;
        }
        if ((distance = Math.abs(cameraPosLocal.m_82526_(portal.getNormal()))) > 200.0) {
            r = r * 200.0 / distance;
        }
        Vec3 v0 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, -r + cameraLocalY);
        Vec3 v1 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, -r + cameraLocalY);
        Vec3 v2 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, r + cameraLocalY);
        Vec3 v3 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, r + cameraLocalY);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.m_82549_(posInPlayerCoordinate), v2.m_82549_(posInPlayerCoordinate), v3.m_82549_(posInPlayerCoordinate), v1.m_82549_(posInPlayerCoordinate));
    }

    private static void putIntoVertex(BufferBuilder bufferBuilder, Vec3 pos, Vec3 fogColor) {
        bufferBuilder.m_5483_(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_85950_((float)fogColor.f_82479_, (float)fogColor.f_82480_, (float)fogColor.f_82481_, 1.0f).m_5752_();
    }

    private static void putIntoQuad(Consumer<Vec3> vertexOutput, Vec3 a, Vec3 b, Vec3 c, Vec3 d) {
        vertexOutput.accept(b);
        vertexOutput.accept(c);
        vertexOutput.accept(d);
        vertexOutput.accept(d);
        vertexOutput.accept(a);
        vertexOutput.accept(b);
    }
}

