/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.StaticFieldsSwappingManager;

public class FogRendererContext {
    public float red;
    public float green;
    public float blue;
    public int waterFogColor = -1;
    public int nextWaterFogColor = -1;
    public long lastWaterFogColorUpdateTime = -1L;
    public static Consumer<FogRendererContext> copyContextFromObject;
    public static Consumer<FogRendererContext> copyContextToObject;
    public static Supplier<Vec3> getCurrentFogColor;
    public static StaticFieldsSwappingManager<FogRendererContext> swappingManager;

    public static void init() {
        FogRenderer.class.hashCode();
        swappingManager = new StaticFieldsSwappingManager<FogRendererContext>(copyContextFromObject, copyContextToObject, false, FogRendererContext::new);
    }

    public static void update() {
        swappingManager.setOuterDimension(RenderStates.originalPlayerDimension);
        swappingManager.resetChecks();
        if (ClientWorldLoader.getIsInitialized()) {
            ClientWorldLoader.getClientWorlds().forEach(world -> {
                ResourceKey dimension = world.m_46472_();
                FogRendererContext.swappingManager.contextMap.computeIfAbsent((ResourceKey<Level>)dimension, k -> new StaticFieldsSwappingManager.ContextRecord<FogRendererContext>((ResourceKey<Level>)dimension, new FogRendererContext(), dimension != RenderStates.originalPlayerDimension));
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vec3 getFogColorOf(ClientLevel destWorld, Vec3 pos) {
        Minecraft client = Minecraft.m_91087_();
        client.m_91307_().m_6180_("get_fog_color");
        ClientLevel oldWorld = client.f_91073_;
        ResourceKey newWorldKey = destWorld.m_46472_();
        FogRendererContext.swappingManager.contextMap.computeIfAbsent((ResourceKey<Level>)newWorldKey, k -> new StaticFieldsSwappingManager.ContextRecord<FogRendererContext>((ResourceKey<Level>)k, new FogRendererContext(), true));
        swappingManager.pushSwapping((ResourceKey<Level>)newWorldKey);
        client.f_91073_ = destWorld;
        Camera newCamera = new Camera();
        ((IECamera)newCamera).portal_setPos(pos);
        ((IECamera)newCamera).portal_setFocusedEntity(client.f_91075_);
        try {
            Vec3 result;
            FogRenderer.m_109018_((Camera)newCamera, (float)RenderStates.tickDelta, (ClientLevel)destWorld, (int)client.f_91066_.f_92106_, (float)client.f_91063_.m_109131_(RenderStates.tickDelta));
            Vec3 vec3 = result = getCurrentFogColor.get();
            return vec3;
        }
        finally {
            swappingManager.popSwapping();
            client.f_91073_ = oldWorld;
            client.m_91307_().m_7238_();
        }
    }

    public static void onPlayerTeleport(ResourceKey<Level> from, ResourceKey<Level> to) {
        swappingManager.updateOuterDimensionAndChangeContext(to);
    }
}

