/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@OnlyIn(value=Dist.CLIENT)
public class PortalRendering {
    private static final Stack<PortalLike> portalLayers = new Stack();
    private static boolean isRenderingCache = false;
    private static boolean isRenderingOddNumberOfMirrorsCache = false;

    public static void pushPortalLayer(PortalLike portal) {
        portalLayers.push(portal);
        PortalRendering.updateCache();
    }

    public static void popPortalLayer() {
        portalLayers.pop();
        PortalRendering.updateCache();
    }

    private static void updateCache() {
        isRenderingCache = PortalRendering.getPortalLayer() != 0;
        int number = 0;
        for (PortalLike portal : portalLayers) {
            if (!(portal instanceof Mirror)) continue;
            ++number;
        }
        isRenderingOddNumberOfMirrorsCache = number % 2 == 1;
    }

    public static int getPortalLayer() {
        return portalLayers.size();
    }

    public static boolean isRendering() {
        return isRenderingCache;
    }

    public static boolean isRenderingOddNumberOfMirrors() {
        return isRenderingOddNumberOfMirrorsCache;
    }

    public static int getMaxPortalLayer() {
        if (RenderStates.isLaggy) {
            return 1;
        }
        return IPGlobal.maxPortalLayer;
    }

    public static PortalLike getRenderingPortal() {
        return portalLayers.peek();
    }

    public static void onBeginPortalWorldRendering() {
        List currRenderInfo = portalLayers.stream().map(WeakReference::new).collect(Collectors.toList());
        RenderStates.portalRenderInfos.add(currRenderInfo);
        ++RenderStates.portalsRenderedThisFrame;
        if (portalLayers.stream().anyMatch(PortalLike::hasScaling)) {
            RenderStates.renderedScalingPortal = true;
        }
        CHelper.checkGlError();
    }

    public static void onEndPortalWorldRendering() {
        RenderStates.renderedDimensions.add(portalLayers.peek().getDestDim());
    }

    public static Vec3 getRenderingCameraPos() {
        Vec3 pos = RenderStates.originalCamera.m_90583_();
        for (PortalLike portal : portalLayers) {
            pos = portal.transformPoint(pos);
        }
        return pos;
    }

    public static double getExtraModelViewScaling() {
        double scale = 1.0;
        for (PortalLike portal : portalLayers) {
            if (PortalRenderer.shouldApplyScaleToModelView(portal)) continue;
            scale *= portal.getScale();
        }
        return scale;
    }
}

