/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.optimization;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.q_misc_util.Helper;

public class SharedBlockMeshBuffers {
    public static final ThreadLocal<Object> bufferTemp = ThreadLocal.withInitial(() -> null);
    public static final ThreadLocal<Object> taskTemp = ThreadLocal.withInitial(() -> null);
    public static ConcurrentLinkedQueue<ChunkBufferBuilderPack> threadBuffers;

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(SharedBlockMeshBuffers::cleanup);
    }

    public static ConcurrentLinkedQueue<ChunkBufferBuilderPack> acquireThreadBuffers() {
        if (threadBuffers == null) {
            SharedBlockMeshBuffers.createThreadBuffers();
        }
        return threadBuffers;
    }

    private static void createThreadBuffers() {
        Validate.isTrue((boolean)IPGlobal.enableSharedBlockMeshBuffers);
        int totalExpectedBufferSize = RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum();
        int bufferCountEstimation = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (totalExpectedBufferSize * 4) - 1);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        boolean is64Bits = Minecraft.m_91087_().m_91103_();
        int effectiveProcessors = is64Bits ? availableProcessors : Math.min(availableProcessors, 4);
        int bufferCount = Math.max(1, Math.min(effectiveProcessors, bufferCountEstimation));
        ArrayList<ChunkBufferBuilderPack> list = new ArrayList<ChunkBufferBuilderPack>();
        try {
            for (int m = 0; m < bufferCount; ++m) {
                list.add(new ChunkBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
            String errorMessage = String.format("[Immersive Portals] Allocated only %s/%s block mesh buffers. Memory seems not enough.", list.size(), bufferCount);
            Helper.err(errorMessage);
            CHelper.printChat(errorMessage);
            int n = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int i = 0; i < n; ++i) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        threadBuffers = Queues.newConcurrentLinkedQueue(list);
    }

    private static void cleanup() {
        if (threadBuffers != null) {
            threadBuffers = null;
        }
    }

    public static String getDebugString() {
        if (IPGlobal.enableSharedBlockMeshBuffers) {
            return "SharedBlockMeshBuffers " + Integer.toString(threadBuffers.size());
        }
        return "";
    }
}

