/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.platform_specific.forge.networking.IPMessage;
import qouteall.imm_ptl.core.platform_specific.forge.networking.Teleport;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.CollisionHelper;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class ClientTeleportationManager {
    public static final Minecraft client = Minecraft.m_91087_();
    public long tickTimeForTeleportation = 0L;
    private long lastTeleportGameTime = 0L;
    private Vec3 moveStartPoint = null;
    private long teleportTickTimeLimit = 0L;
    public static boolean isTeleportingTick = false;
    public static boolean isTeleportingFrame = false;
    private static final int teleportLimit = 2;

    public ClientTeleportationManager() {
        IPGlobal.postClientTickSignal.connectWithWeakRef(this, ClientTeleportationManager::tick);
        IPGlobal.clientCleanupSignal.connectWithWeakRef(this, this_ -> this_.disableTeleportFor(40));
    }

    private void tick() {
        ++this.tickTimeForTeleportation;
        this.changePlayerMotionIfCollidingWithPortal();
        isTeleportingTick = false;
    }

    public void acceptSynchronizationDataFromServer(ResourceKey<Level> dimension, Vec3 pos, boolean forceAccept) {
        if (!forceAccept) {
            if (this.isTeleportingFrequently()) {
                return;
            }
            if (ClientTeleportationManager.client.f_91074_.f_19797_ < 200) {
                return;
            }
        }
        if (ClientTeleportationManager.client.f_91074_.f_19853_.m_46472_() != dimension) {
            this.forceTeleportPlayer(dimension, pos);
        }
    }

    public void manageTeleportation(float tickDelta) {
        if (IPGlobal.disableTeleportation) {
            return;
        }
        isTeleportingFrame = false;
        if (ClientTeleportationManager.client.f_91073_ == null || ClientTeleportationManager.client.f_91074_ == null) {
            this.moveStartPoint = null;
        } else {
            if (ClientTeleportationManager.client.f_91074_.f_19854_ == 0.0 && ClientTeleportationManager.client.f_91074_.f_19855_ == 0.0 && ClientTeleportationManager.client.f_91074_.f_19856_ == 0.0) {
                return;
            }
            client.m_91307_().m_6180_("ip_teleport");
            if (this.moveStartPoint != null) {
                boolean teleported;
                for (int i = 0; i < 2 && (teleported = this.tryTeleport(tickDelta)); ++i) {
                    if (i == 0) continue;
                    Helper.log("Nested teleport");
                }
            }
            this.moveStartPoint = ClientTeleportationManager.getPlayerHeadPos(tickDelta);
            client.m_91307_().m_7238_();
        }
    }

    private boolean tryTeleport(float tickDelta) {
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        Vec3 newHeadPos = ClientTeleportationManager.getPlayerHeadPos(tickDelta);
        if (this.moveStartPoint.m_82557_(newHeadPos) > 1600.0) {
            return false;
        }
        Tuple pair = CHelper.getClientNearbyPortals(32.0).flatMap(portal -> {
            Vec3 collidingPoint;
            if (portal.canTeleportEntity((Entity)player) && (collidingPoint = portal.rayTrace(this.moveStartPoint, newHeadPos)) != null) {
                return Stream.of(new Tuple(portal, (Object)collidingPoint));
            }
            return Stream.empty();
        }).min(Comparator.comparingDouble(p -> ((Vec3)p.m_14419_()).m_82557_(this.moveStartPoint))).orElse(null);
        if (pair != null) {
            Portal portal2 = (Portal)pair.m_14418_();
            Vec3 collidingPos = (Vec3)pair.m_14419_();
            client.m_91307_().m_6180_("portal_teleport");
            this.teleportPlayer(portal2);
            client.m_91307_().m_7238_();
            boolean allowOverlappedTeleport = portal2.allowOverlappedTeleport();
            double adjustment = allowOverlappedTeleport ? -0.001 : 0.001;
            this.moveStartPoint = portal2.transformPoint(collidingPos).m_82549_(portal2.getContentDirection().m_82490_(adjustment));
            return true;
        }
        return false;
    }

    public static Vec3 getPlayerHeadPos(float tickDelta) {
        return ClientTeleportationManager.client.f_91074_.m_20299_(tickDelta);
    }

    private void teleportPlayer(Portal portal) {
        if (this.tickTimeForTeleportation <= this.teleportTickTimeLimit) {
            Helper.log("Client player teleportation rejected");
            return;
        }
        this.lastTeleportGameTime = this.tickTimeForTeleportation;
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        Validate.isTrue((player != null ? 1 : 0) != 0);
        ResourceKey<Level> toDimension = portal.dimensionTo;
        Vec3 oldEyePos = McHelper.getEyePos((Entity)player);
        Vec3 newEyePos = portal.transformPoint(oldEyePos);
        Vec3 newLastTickEyePos = portal.transformPoint(McHelper.getLastTickEyePos((Entity)player));
        ClientLevel fromWorld = ClientTeleportationManager.client.f_91073_;
        ResourceKey fromDimension = fromWorld.m_46472_();
        if (fromDimension != toDimension) {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
        }
        Vec3 oldRealVelocity = McHelper.getWorldVelocity((Entity)player);
        TransformationManager.managePlayerRotationAndChangeGravity(portal);
        McHelper.setWorldVelocity((Entity)player, oldRealVelocity);
        portal.transformVelocity((Entity)player);
        if (player.m_20202_() != null) {
            portal.transformVelocity(player.m_20202_());
        }
        McHelper.setEyePos((Entity)player, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
        PehkuiInterface.invoker.onClientPlayerTeleported(portal);
        IPMessage.sendToServer(new Teleport((ResourceKey<Level>)fromDimension, oldEyePos, portal.m_142081_()));
        ClientTeleportationManager.tickAfterTeleportation(player, newEyePos, newLastTickEyePos);
        McHelper.adjustVehicle((Entity)player);
        if (player.m_20202_() != null) {
            this.disableTeleportFor(10);
        }
        RenderStates.updatePreRenderInfo(RenderStates.tickDelta);
        Helper.log(String.format("Client Teleported %s %s", portal, this.tickTimeForTeleportation));
        isTeleportingTick = true;
        isTeleportingFrame = true;
        if (PortalExtension.get((Portal)portal).adjustPositionAfterTeleport) {
            ClientTeleportationManager.adjustPlayerPosition(player);
        }
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public boolean isTeleportingFrequently() {
        return this.tickTimeForTeleportation - this.lastTeleportGameTime <= 20L || this.tickTimeForTeleportation <= this.teleportTickTimeLimit;
    }

    private void forceTeleportPlayer(ResourceKey<Level> toDimension, Vec3 destination) {
        Helper.log("force teleported " + toDimension + destination);
        ClientLevel fromWorld = ClientTeleportationManager.client.f_91073_;
        ResourceKey fromDimension = fromWorld.m_46472_();
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        if (fromDimension == toDimension) {
            player.m_6034_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
            McHelper.adjustVehicle((Entity)player);
        } else {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            this.changePlayerDimension(player, fromWorld, toWorld, destination);
        }
        this.moveStartPoint = null;
        this.disableTeleportFor(20);
        RenderStates.updatePreRenderInfo(RenderStates.tickDelta);
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public void changePlayerDimension(LocalPlayer player, ClientLevel fromWorld, ClientLevel toWorld, Vec3 newEyePos) {
        Validate.isTrue((!WorldRenderInfo.isRendering() ? 1 : 0) != 0);
        Validate.isTrue((!FrontClipping.isClippingEnabled ? 1 : 0) != 0);
        Validate.isTrue((!PacketRedirectionClient.getIsProcessingRedirectedMessage() ? 1 : 0) != 0);
        Entity vehicle = player.m_20202_();
        player.m_19877_();
        ResourceKey toDimension = toWorld.m_46472_();
        ResourceKey fromDimension = fromWorld.m_46472_();
        ((IEClientPlayNetworkHandler)client.m_91403_()).ip_setWorld(toWorld);
        fromWorld.m_171642_(player.m_142049_(), Entity.RemovalReason.CHANGED_DIMENSION);
        player.f_19853_ = toWorld;
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        ((IEEntity)player).portal_unsetRemoved();
        toWorld.m_104630_(player.m_142049_(), (AbstractClientPlayer)player);
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.m_91087_().f_91063_;
        gameRenderer.setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)toDimension).lightmapTexture);
        ClientTeleportationManager.client.f_91073_ = toWorld;
        ((IEMinecraftClient)client).setWorldRenderer(ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)toDimension));
        toWorld.m_104669_(fromWorld.m_6188_());
        if (ClientTeleportationManager.client.f_91061_ != null) {
            ((IEParticleManager)ClientTeleportationManager.client.f_91061_).ip_setWorld(toWorld);
        }
        client.m_167982_().m_112257_((Level)toWorld);
        if (vehicle != null) {
            Vec3 vehiclePos = new Vec3(newEyePos.f_82479_, McHelper.getVehicleY(vehicle, (Entity)player), newEyePos.f_82481_);
            ClientTeleportationManager.moveClientEntityAcrossDimension(vehicle, toWorld, vehiclePos);
            player.m_7998_(vehicle, true);
        }
        Helper.log(String.format("Client Changed Dimension from %s to %s time: %s", fromDimension.m_135782_(), toDimension.m_135782_(), this.tickTimeForTeleportation));
        FogRendererContext.onPlayerTeleport((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
        O_O.onPlayerChangeDimensionClient((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
    }

    private void changePlayerMotionIfCollidingWithPortal() {
        LocalPlayer player = ClientTeleportationManager.client.f_91074_;
        Portal portal = ((IEEntity)player).getCollidingPortal();
        if (portal != null) {
            if (PortalExtension.get((Portal)portal).motionAffinity > 0.0) {
                this.changeMotion((Entity)player, portal);
            } else if (PortalExtension.get((Portal)portal).motionAffinity < 0.0 && player.m_20184_().m_82553_() > 0.7) {
                this.changeMotion((Entity)player, portal);
            }
        }
    }

    private void changeMotion(Entity player, Portal portal) {
        Vec3 velocity = player.m_20184_();
        player.m_20256_(velocity.m_82490_(1.0 + PortalExtension.get((Portal)portal).motionAffinity));
    }

    public static void moveClientEntityAcrossDimension(Entity entity, ClientLevel newWorld, Vec3 newPos) {
        ClientLevel oldWorld = (ClientLevel)entity.f_19853_;
        oldWorld.m_171642_(entity.m_142049_(), Entity.RemovalReason.CHANGED_DIMENSION);
        entity.f_19853_ = newWorld;
        entity.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        newWorld.m_104627_(entity.m_142049_(), entity);
    }

    public void disableTeleportFor(int ticks) {
        this.teleportTickTimeLimit = this.tickTimeForTeleportation + (long)ticks;
    }

    private static void tickAfterTeleportation(LocalPlayer player, Vec3 newEyePos, Vec3 newLastTickEyePos) {
        McHelper.findEntitiesByBox(Portal.class, player.f_19853_, player.m_142469_(), 10.0, portal -> true).forEach(CollisionHelper::notifyCollidingPortals);
        CollisionHelper.tickClient();
        ((IEEntity)player).tickCollidingPortal(RenderStates.tickDelta);
        McHelper.setEyePos((Entity)player, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
    }

    private static void adjustPlayerPosition(LocalPlayer player) {
        if (player.m_5833_()) {
            return;
        }
        AABB playerBoundingBox = player.m_142469_();
        Direction gravityDir = GravityChangerInterface.invoker.getGravityDirection((Player)player);
        Direction levitationDir = gravityDir.m_122424_();
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset((Entity)player);
        AABB bottomHalfBox = playerBoundingBox.m_82310_(eyeOffset.f_82479_ / 2.0, eyeOffset.f_82480_ / 2.0, eyeOffset.f_82481_ / 2.0);
        Iterable collisions = player.f_19853_.m_186434_((Entity)player, bottomHalfBox);
        AABB collisionUnion = null;
        for (VoxelShape collision : collisions) {
            AABB collisionBoundingBox = collision.m_83215_();
            if (collisionUnion == null) {
                collisionUnion = collisionBoundingBox;
                continue;
            }
            collisionUnion = collisionUnion.m_82367_(collisionBoundingBox);
        }
        if (collisionUnion == null) {
            return;
        }
        Vec3 anchor = player.m_20182_();
        AABB collisionUnionLocal = Helper.transformBox(collisionUnion, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.m_82546_(anchor)));
        AABB playerBoxLocal = Helper.transformBox(playerBoundingBox, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.m_82546_(anchor)));
        double targetLocalY = collisionUnionLocal.f_82292_ + 0.01;
        double originalLocalY = playerBoxLocal.f_82289_;
        double delta = targetLocalY - originalLocalY;
        if (delta <= 0.0) {
            return;
        }
        Vec3 levitationVec = Vec3.m_82528_((Vec3i)levitationDir.m_122436_());
        Vec3 offset = levitationVec.m_82490_(delta);
        int ticks = 5;
        Helper.log("Adjusting Client Player Position");
        int[] counter = new int[]{0};
        IPGlobal.clientTaskList.addTask(() -> {
            Vec3 newEyePos;
            Vec3 eyePos;
            if (player.m_146910_()) {
                return true;
            }
            if (GravityChangerInterface.invoker.getGravityDirection((Player)player) != gravityDir) {
                return true;
            }
            if (counter[0] >= 5) {
                return true;
            }
            counter[0] = counter[0] + 1;
            double len = player.m_20182_().m_82546_(anchor).m_82526_(levitationVec);
            if (len < -1.0 || len > 2.0) {
                return true;
            }
            double progress = (double)counter[0] / 5.0;
            progress = TransformationManager.mapProgress(progress);
            Vec3 expectedPos = anchor.m_82549_(offset.m_82490_(progress));
            Vec3 newPos = Helper.putCoordinate(player.m_20182_(), levitationDir.m_122434_(), Helper.getCoordinate(expectedPos, levitationDir.m_122434_()));
            Portal collidingPortal = ((IEEntity)player).getCollidingPortal();
            if (collidingPortal != null && collidingPortal.rayTrace(eyePos = McHelper.getEyePos((Entity)player), newEyePos = newPos.m_82549_(McHelper.getEyeOffset((Entity)player))) != null) {
                return true;
            }
            player.m_20343_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            McHelper.updateBoundingBox((Entity)player);
            return false;
        });
    }

    public static class RemoteCallables {
        public static void updateEntityPos(ResourceKey<Level> dim, int entityId, Vec3 pos) {
            ClientLevel world = ClientWorldLoader.getWorld(dim);
            Entity entity = world.m_6815_(entityId);
            if (entity == null) {
                Helper.err("cannot find entity to update position");
                return;
            }
            entity.m_6453_(pos.f_82479_, pos.f_82480_, pos.f_82481_, entity.m_146908_(), entity.m_146909_(), 0, false);
            entity.m_146884_(pos);
        }
    }
}

