/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;

public class CommandStickItem
extends Item {
    private static final ResourceKey<Registry<Data>> registryRegistryKey = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("immersive_portals:command_stick_type"));
    public static final DeferredRegister<Data> CommandStickData = DeferredRegister.create((ResourceLocation)new ResourceLocation("immersive_portals", "command_stick_type"), (String)"imm_ptl");
    public static final Supplier<IForgeRegistry<Data>> REGISTRY = CommandStickData.makeRegistry(Data.class, RegistryBuilder::new);
    public static final RegistryObject<Data> delete_portal = CommandStickData.register("delete_portal", () -> CommandStickItem.createData("delete_portal"));
    public static final RegistryObject<Data> remove_connected_portals = CommandStickData.register("remove_connected_portals", () -> CommandStickItem.createData("remove_connected_portals"));
    public static final RegistryObject<Data> eradicate_portal_cluster = CommandStickData.register("eradicate_portal_cluster", () -> CommandStickItem.createData("eradicate_portal_cluster"));
    public static final RegistryObject<Data> complete_bi_way_bi_faced_portal = CommandStickData.register("complete_bi_way_bi_faced_portal", () -> CommandStickItem.createData("complete_bi_way_bi_faced_portal"));
    public static final RegistryObject<Data> complete_bi_way_portal = CommandStickData.register("complete_bi_way_portal", () -> CommandStickItem.createData("complete_bi_way_portal"));
    public static final RegistryObject<Data> bind_cluster = CommandStickData.register("bind_cluster", () -> CommandStickItem.createData("bind_cluster", "set_portal_nbt {bindCluster:true}"));
    public static final RegistryObject<Data> move_portal_front = CommandStickData.register("move_portal_front", () -> CommandStickItem.createData("move_portal_front", "move_portal 0.5"));
    public static final RegistryObject<Data> move_portal_back = CommandStickData.register("move_portal_back", () -> CommandStickItem.createData("move_portal_back", "move_portal -0.5"));
    public static final RegistryObject<Data> move_portal_destination_front = CommandStickData.register("move_portal_destination_front", () -> CommandStickItem.createData("move_portal_destination_front", "move_portal_destination 0.5"));
    public static final RegistryObject<Data> move_portal_destination_back = CommandStickData.register("move_portal_destination_back", () -> CommandStickItem.createData("move_portal_destination_back", "move_portal_destination -0.5"));
    public static final RegistryObject<Data> rotate_x = CommandStickData.register("rotate_x", () -> CommandStickItem.createData("rotate_x", "rotate_portal_rotation_along x 15"));
    public static final RegistryObject<Data> rotate_y = CommandStickData.register("rotate_y", () -> CommandStickItem.createData("rotate_y", "rotate_portal_rotation_along y 15"));
    public static final RegistryObject<Data> rotate_z = CommandStickData.register("rotate_z", () -> CommandStickItem.createData("rotate_z", "rotate_portal_rotation_along z 15"));
    public static final RegistryObject<Data> make_unbreakable = CommandStickData.register("make_unbreakable", () -> CommandStickItem.createData("make_unbreakable", "set_portal_nbt {unbreakable:true}"));
    public static final RegistryObject<Data> make_fuse_view = CommandStickData.register("make_fuse_view", () -> CommandStickItem.createData("make_fuse_view", "set_portal_nbt {fuseView:true}"));
    public static final RegistryObject<Data> enable_pos_adjust = CommandStickData.register("enable_pos_adjust", () -> CommandStickItem.createData("enable_pos_adjust", "set_portal_nbt {adjustPositionAfterTeleport:true}"));
    public static final RegistryObject<Data> disable_rendering_yourself = CommandStickData.register("disable_rendering_yourself", () -> CommandStickItem.createData("disable_rendering_yourself", "set_portal_nbt {doRenderPlayer:false}"));
    public static final RegistryObject<Data> enable_isometric = CommandStickData.register("enable_isometric", () -> CommandStickItem.createData("enable_isometric", "debug isometric_enable 50"));
    public static final RegistryObject<Data> disable_isometric = CommandStickData.register("disable_isometric", () -> CommandStickItem.createData("disable_isometric", "debug isometric_disable"));
    public static final RegistryObject<Data> create_5_connected_rooms = CommandStickData.register("create_5_connected_rooms", () -> CommandStickItem.createData("create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5"));
    public static final RegistryObject<Data> accelerate50 = CommandStickData.register("accelerate50", () -> CommandStickItem.createData("accelerate50", "debug accelerate 50"));
    public static final RegistryObject<Data> accelerate200 = CommandStickData.register("accelerate200", () -> CommandStickItem.createData("accelerate200", "debug accelerate 200"));
    public static final RegistryObject<Data> reverse_accelerate50 = CommandStickData.register("reverse_accelerate50", () -> CommandStickItem.createData("reverse_accelerate50", "debug accelerate -50"));
    public static final RegistryObject<Data> enable_gravity_change = CommandStickData.register("enable_gravity_change", () -> CommandStickItem.createData("enable_gravity_change", "set_portal_nbt {teleportChangesGravity:true}"));
    public static final RegistryObject<Data> reset_scale = CommandStickData.register("reset_scale", () -> new Data("/scale set pehkui:base 1", "imm_ptl.command.reset_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_scale"}), true));
    public static final RegistryObject<Data> long_reach = CommandStickData.register("long_reach", () -> new Data("/scale set pehkui:reach 5", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"}), true));
    public static final RegistryObject<Data> goback = CommandStickData.register("goback", () -> CommandStickItem.createData("goback"));
    public static final RegistryObject<Data> show_wiki = CommandStickData.register("show_wiki", () -> CommandStickItem.createData("show_wiki", "wiki"));
    static List<Data> cmd_stick_data = new ArrayList<Data>();
    public static final MappedRegistry<Data> commandStickTypeRegistry = new MappedRegistry(registryRegistryKey, Lifecycle.stable(), null);

    public static void registerType(String id, Data data) {
        commandStickTypeRegistry.m_203505_(ResourceKey.m_135785_(registryRegistryKey, (ResourceLocation)new ResourceLocation(id)), (Object)data, Lifecycle.stable());
    }

    public static Data createData(String name) {
        return CommandStickItem.createData(name, name);
    }

    private static Data createData(String name, String subCommand) {
        return new Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}), true);
    }

    public CommandStickItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        this.doUse(player, player.m_21120_(hand));
        return super.m_7203_(world, player, hand);
    }

    private void doUse(Player player, ItemStack stack) {
        if (player.f_19853_.m_5776_()) {
            return;
        }
        if (CommandStickItem.canUseCommand(player)) {
            Data data = Data.deserialize(stack.m_41784_());
            CommandSourceStack commandSource = player.m_20203_().m_81325_(2);
            Commands commandManager = commandSource.m_81377_().m_129892_();
            commandManager.m_82117_(commandSource, data.command);
        } else {
            CommandStickItem.sendMessage(player, (Component)new TextComponent("No Permission"));
        }
    }

    private static boolean canUseCommand(Player player) {
        if (IPGlobal.easeCommandStickPermission) {
            return true;
        }
        return player.m_20310_(2) || player.m_7500_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        Data data = Data.deserialize(stack.m_41784_());
        tooltip.add((Component)new TextComponent(data.command).m_130940_(ChatFormatting.GOLD));
        for (String descriptionTranslationKey : data.descriptionTranslationKeys) {
            tooltip.add((Component)new TranslatableComponent(descriptionTranslationKey).m_130940_(ChatFormatting.AQUA));
        }
        tooltip.add((Component)new TranslatableComponent("imm_ptl.command_stick").m_130940_(ChatFormatting.GRAY));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(group)) {
            cmd_stick_data.forEach(data -> {
                ItemStack stack = new ItemStack((ItemLike)PeripheralModEntry.COMMAND_STICK_ITEM.get());
                data.serialize(stack.m_41784_());
                stacks.add((Object)stack);
            });
        }
    }

    public String m_5671_(ItemStack stack) {
        Data data = Data.deserialize(stack.m_41784_());
        return data.nameTranslationKey;
    }

    public static void sendMessage(Player player, Component message) {
        ((ServerPlayer)player).m_9146_(message, ChatType.GAME_INFO, Util.f_137441_);
    }

    public static void init() {
        PortalCommand.createCommandStickCommandSignal.connect((player, command) -> {
            ItemStack itemStack = new ItemStack((ItemLike)PeripheralModEntry.COMMAND_STICK_ITEM.get(), 1);
            Data data = new Data((String)command, (String)command, (List<String>)new ArrayList<String>(), false);
            data.serialize(itemStack.m_41784_());
            player.m_150109_().m_36054_(itemStack);
            player.f_36095_.m_38946_();
        });
    }

    public static class Data
    extends ForgeRegistryEntry<Data> {
        public final String command;
        public final String nameTranslationKey;
        public final List<String> descriptionTranslationKeys;

        public Data(String command, String nameTranslationKey, List<String> descriptionTranslationKeys, boolean addToMenu) {
            this.command = command;
            this.nameTranslationKey = nameTranslationKey;
            this.descriptionTranslationKeys = descriptionTranslationKeys;
            if (addToMenu) {
                cmd_stick_data.add(this);
            }
        }

        public void serialize(CompoundTag tag) {
            tag.m_128359_("command", this.command);
            tag.m_128359_("nameTranslationKey", this.nameTranslationKey);
            ListTag listTag = new ListTag();
            for (String descriptionTK : this.descriptionTranslationKeys) {
                listTag.add((Object)StringTag.m_129297_((String)descriptionTK));
            }
            tag.m_128365_("descriptionTranslationKeys", (Tag)listTag);
        }

        public static Data deserialize(CompoundTag tag) {
            return new Data(tag.m_128461_("command"), tag.m_128461_("nameTranslationKey"), tag.m_128437_("descriptionTranslationKeys", (int)StringTag.m_129297_((String)"").m_7060_()).stream().map(tag1 -> ((StringTag)tag1).m_7916_()).collect(Collectors.toList()), false);
        }
    }
}

