/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import qouteall.imm_ptl.peripheral.CommandStickItem;
import qouteall.imm_ptl.peripheral.alternate_dimension.AlternateDimensions;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.FormulaGenerator;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGameRule;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.guide.IPGuide;
import qouteall.imm_ptl.peripheral.portal_generation.IntrinsicPortalGeneration;

public class PeripheralModMain {
    private static final DeferredRegister<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = DeferredRegister.create((ResourceKey)Registry.f_122853_, (String)"immersive_portals");
    private static final DeferredRegister<Codec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((ResourceKey)Registry.f_122852_, (String)"immersive_portals");
    public static final RegistryObject<Codec<? extends ChunkGenerator>> ERROR_TERRAIN_GENERATOR = CHUNK_GENERATOR.register("error_terrain_generator", () -> ErrorTerrainGenerator.codec);
    public static final RegistryObject<Codec<? extends ChunkGenerator>> NORMAL_SKYLAND_GENERATOR = CHUNK_GENERATOR.register("normal_skyland_generator", () -> ErrorTerrainGenerator.codec);
    public static final RegistryObject<Codec<? extends BiomeSource>> CHAOS_BIOME_SOURCE = BIOME_SOURCE.register("chaos_biome_source", () -> ChaosBiomeSource.CODEC);

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        IPGuide.initClient();
    }

    public static void init() {
        FormulaGenerator.init();
        IntrinsicPortalGeneration.init();
        DimStackGameRule.init();
        DimStackManagement.init();
        AlternateDimensions.init();
        CHUNK_GENERATOR.register(FMLJavaModLoadingContext.get().getModEventBus());
        BIOME_SOURCE.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void registerCommandStickTypes() {
    }

    private static void registerPortalSubCommandStick(String name) {
        PeripheralModMain.registerPortalSubCommandStick(name, name);
    }

    private static void registerPortalSubCommandStick(String name, String subCommand) {
        CommandStickItem.registerType("imm_ptl:" + name, new CommandStickItem.Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}), true));
    }
}

