/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.NormalSkylandGenerator;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.forge.events.ServerDimensionsLoadEvent;

public class AlternateDimensions {
    public static final ResourceKey<DimensionType> surfaceType = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("immersive_portals:surface_type"));
    public static final ResourceKey<Level> alternate1 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate1"));
    public static final ResourceKey<Level> alternate2 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate2"));
    public static final ResourceKey<Level> alternate3 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate3"));
    public static final ResourceKey<Level> alternate4 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate4"));
    public static final ResourceKey<Level> alternate5 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate5"));

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AlternateDimensions.class);
        IPGlobal.postServerTickSignal.connect(AlternateDimensions::tick);
    }

    @SubscribeEvent
    public static void onServerDimensionsLoad(ServerDimensionsLoadEvent event) {
        AlternateDimensions.initializeAlternateDimensions(event.generatorOptions, event.registryManager);
    }

    private static void initializeAlternateDimensions(WorldGenSettings generatorOptions, RegistryAccess registryManager) {
        Registry registry = generatorOptions.m_204655_();
        long seed = generatorOptions.m_64619_();
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("immersive_portals:surface_type"));
        Holder surfaceTypeHolder = (Holder)registryManager.m_175515_(Registry.f_122818_).m_203636_(resourceKey).orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type"));
        if (surfaceTypeHolder == null) {
            Helper.err("Missing dimension type immersive_portals:surface_type");
            return;
        }
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate1.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createSkylandGenerator(seed + 1L, registryManager));
        DimensionAPI.markDimensionNonPersistent(alternate1.m_135782_());
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate2.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createSkylandGenerator(seed, registryManager));
        DimensionAPI.markDimensionNonPersistent(alternate2.m_135782_());
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate3.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createErrorTerrainGenerator(seed + 1L, registryManager));
        DimensionAPI.markDimensionNonPersistent(alternate3.m_135782_());
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate4.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createErrorTerrainGenerator(seed, registryManager));
        DimensionAPI.markDimensionNonPersistent(alternate4.m_135782_());
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate5.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createVoidGenerator(registryManager));
        DimensionAPI.markDimensionNonPersistent(alternate5.m_135782_());
    }

    public static boolean isAlternateDimension(Level world) {
        ResourceKey key = world.m_46472_();
        return key == alternate1 || key == alternate2 || key == alternate3 || key == alternate4 || key == alternate5;
    }

    private static void syncWithOverworldTimeWeather(@Nullable ServerLevel world, ServerLevel overworld) {
        if (world == null) {
            return;
        }
        ((IEWorld)world).portal_setWeather(overworld.m_46722_(1.0f), overworld.m_46722_(1.0f), overworld.m_46661_(1.0f), overworld.m_46661_(1.0f));
    }

    public static ChunkGenerator createSkylandGenerator(long seed, RegistryAccess rm) {
        return NormalSkylandGenerator.create(seed, (Registry<StructureSet>)rm.m_175515_(Registry.f_211073_), (Registry<Biome>)rm.m_175515_(Registry.f_122885_), (Registry<NormalNoise.NoiseParameters>)rm.m_175515_(Registry.f_194568_));
    }

    public static ChunkGenerator createErrorTerrainGenerator(long seed, RegistryAccess rm) {
        return ErrorTerrainGenerator.create(seed, (Registry<StructureSet>)rm.m_175515_(Registry.f_211073_), (Registry<Biome>)rm.m_175515_(Registry.f_122885_), (Registry<NormalNoise.NoiseParameters>)rm.m_175515_(Registry.f_194568_));
    }

    public static ChunkGenerator createVoidGenerator(RegistryAccess rm) {
        Registry biomeRegistry = rm.m_175515_(Registry.f_122885_);
        Registry structureSets = rm.m_175515_(Registry.f_211073_);
        FlatLevelGeneratorSettings flatChunkGeneratorConfig = new FlatLevelGeneratorSettings(Optional.empty(), biomeRegistry);
        flatChunkGeneratorConfig.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50016_));
        flatChunkGeneratorConfig.m_70403_();
        return new FlatLevelSource(structureSets, flatChunkGeneratorConfig);
    }

    private static void tick() {
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        ServerLevel overworld = McHelper.getServerWorld((ResourceKey<Level>)Level.f_46428_);
        MinecraftServer server = MiscHelper.getServer();
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate1), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate2), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate3), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate4), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate5), overworld);
    }
}

