/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.DelegatedChunkGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.RegionErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.mixin.common.alternate_dimension.IENoiseGeneratorSettings;
import qouteall.q_misc_util.Helper;

public class ErrorTerrainGenerator
extends DelegatedChunkGenerator {
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(g -> g.seed), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(g -> g.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(g -> g.biomeRegistry), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(g -> g.noiseRegistry)).apply((Applicative)instance, ErrorTerrainGenerator::create));
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private final BlockState air = Blocks.f_50016_.m_49966_();
    private final BlockState defaultBlock = Blocks.f_50069_.m_49966_();
    private final BlockState defaultFluid = Blocks.f_49990_.m_49966_();
    private final LoadingCache<ChunkPos, RegionErrorTerrainGenerator> cache;
    public final long seed;
    public final Registry<Biome> biomeRegistry;
    public final Registry<NormalNoise.NoiseParameters> noiseRegistry;

    public static ErrorTerrainGenerator create(Long seed, Registry<StructureSet> structureSets, Registry<Biome> biomeRegistry, Registry<NormalNoise.NoiseParameters> noiseRegistry) {
        List biomeHolderList = biomeRegistry.m_203611_().filter(holder -> holder.m_205785_().m_135782_().m_135827_().equals("minecraft")).collect(Collectors.toList());
        ChaosBiomeSource chaosBiomeSource = new ChaosBiomeSource((HolderSet<Biome>)HolderSet.m_205800_(biomeHolderList));
        NoiseGeneratorSettings skylandSetting = IENoiseGeneratorSettings.ip_floatingIslands();
        NoiseBasedChunkGenerator islandChunkGenerator = new NoiseBasedChunkGenerator(structureSets, noiseRegistry, (BiomeSource)chaosBiomeSource, seed.longValue(), Holder.m_205709_((Object)skylandSetting));
        return new ErrorTerrainGenerator(seed, structureSets, chaosBiomeSource, (ChunkGenerator)islandChunkGenerator, biomeRegistry, noiseRegistry);
    }

    public ErrorTerrainGenerator(final long seed, Registry<StructureSet> structureSets, BiomeSource biomeSource, ChunkGenerator delegate, Registry<Biome> biomeRegistry, Registry<NormalNoise.NoiseParameters> noiseRegistry) {
        super(structureSets, biomeSource, delegate);
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ChunkPos, RegionErrorTerrainGenerator>(){

            public RegionErrorTerrainGenerator load(ChunkPos key) {
                return new RegionErrorTerrainGenerator(key.f_45578_, key.f_45579_, seed);
            }
        });
        this.seed = seed;
        this.biomeRegistry = biomeRegistry;
        this.noiseRegistry = noiseRegistry;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return codec;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new ErrorTerrainGenerator(seed, (Registry<StructureSet>)this.f_207955_, this.biomeSource_.m_7206_(seed), this.delegate.m_6819_(seed), this.biomeRegistry, this.noiseRegistry);
    }

    @Override
    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender arg, StructureFeatureManager structureAccessor, ChunkAccess chunk) {
        LevelChunkSection[] sectionArray = chunk.m_7103_();
        ArrayList<LevelChunkSection> locked = new ArrayList<LevelChunkSection>();
        for (LevelChunkSection chunkSection : sectionArray) {
            if (chunkSection == null) continue;
            chunkSection.m_62981_();
            locked.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.doPopulateNoise(chunk);
            return chunk;
        }, executor).thenApplyAsync(chunkx -> {
            for (LevelChunkSection chunkSection : locked) {
                chunkSection.m_63006_();
            }
            return chunkx;
        }, executor);
    }

    public void doPopulateNoise(ChunkAccess chunk) {
        ProtoChunk protoChunk = (ProtoChunk)chunk;
        ChunkPos pos = chunk.m_7697_();
        Heightmap oceanFloorHeightMap = protoChunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surfaceHeightMap = protoChunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int regionX = Math.floorDiv(pos.f_45578_, 4);
        int regionZ = Math.floorDiv(pos.f_45579_, 4);
        RegionErrorTerrainGenerator generator = Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new ChunkPos(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            LevelChunkSection section = protoChunk.m_183278_(sectionY);
            for (int localX = 0; localX < 16; ++localX) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localY = 0; localY < 16; ++localY) {
                        int worldX = pos.f_45578_ * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.f_45579_ * 16 + localZ;
                        BlockState currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.m_62991_(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.m_64249_(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.m_64249_(localX, worldY, localZ, currBlockState);
                    }
                }
            }
        }
    }
}

