/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.q_misc_util.Helper;

public class DimEntryWidget
extends ContainerObjectSelectionList.Entry<DimEntryWidget> {
    public final ResourceKey<Level> dimension;
    public final DimListWidget parent;
    private final Consumer<DimEntryWidget> selectCallback;
    private final ResourceLocation dimIconPath;
    private final Component dimensionName;
    private boolean dimensionIconPresent = true;
    private final Type type;
    public final DimStackEntry entry;
    public static final int widgetHeight = 50;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public List<? extends NarratableEntry> m_142437_() {
        return List.of();
    }

    public DimEntryWidget(ResourceKey<Level> dimension, DimListWidget parent, Consumer<DimEntryWidget> selectCallback, Type type) {
        this.dimension = dimension;
        this.parent = parent;
        this.selectCallback = selectCallback;
        this.type = type;
        this.dimIconPath = DimEntryWidget.getDimensionIconPath(this.dimension);
        this.dimensionName = DimEntryWidget.getDimensionName(dimension);
        try {
            Minecraft.m_91087_().m_91098_().m_142591_(this.dimIconPath);
        }
        catch (IOException e) {
            Helper.err("Cannot load texture " + this.dimIconPath);
            this.dimensionIconPresent = false;
        }
        this.entry = new DimStackEntry(dimension);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public void m_6311_(PoseStack matrixStack, int index, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean bl, float delta) {
        Minecraft client = Minecraft.m_91087_();
        client.f_91062_.m_92883_(matrixStack, this.dimensionName.getString(), (float)(x + 50 + 3), (float)y, -1);
        client.f_91062_.m_92883_(matrixStack, this.dimension.m_135782_().toString(), (float)(x + 50 + 3), (float)(y + 10), -6710887);
        if (this.dimensionIconPresent) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.dimIconPath);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)46, (int)46, (int)46, (int)46);
            RenderSystem.m_69461_();
        }
        if (this.type == Type.withAdvancedOptions) {
            client.f_91062_.m_92889_(matrixStack, this.getText1(), (float)(x + 50 + 3), (float)(y + 20), -6710887);
            client.f_91062_.m_92889_(matrixStack, this.getText2(), (float)(x + 50 + 3), (float)(y + 30), -6710887);
        }
    }

    private Component getText1() {
        TextComponent scaleText = this.entry.scale != 1.0 ? new TranslatableComponent("imm_ptl.scale").m_7220_((Component)new TextComponent(":" + Double.toString(this.entry.scale))) : new TextComponent("");
        return scaleText;
    }

    private Component getText2() {
        TextComponent horizontalRotationText = this.entry.horizontalRotation != 0.0 ? new TranslatableComponent("imm_ptl.horizontal_rotation").m_7220_((Component)new TextComponent(":" + Double.toString(this.entry.horizontalRotation))).m_7220_((Component)new TextComponent(" ")) : new TextComponent("");
        TranslatableComponent flippedText = this.entry.flipped ? new TranslatableComponent("imm_ptl.flipped") : new TextComponent("");
        return horizontalRotationText.m_7220_((Component)flippedText);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.selectCallback.accept(this);
        super.m_6375_(mouseX, mouseY, button);
        return true;
    }

    public static ResourceLocation getDimensionIconPath(ResourceKey<Level> dimension) {
        ResourceLocation id = dimension.m_135782_();
        return new ResourceLocation(id.m_135827_(), "textures/dimension/" + id.m_135815_() + ".png");
    }

    private static TranslatableComponent getDimensionName(ResourceKey<Level> dimension) {
        return new TranslatableComponent("dimension." + dimension.m_135782_().m_135827_() + "." + dimension.m_135782_().m_135815_());
    }

    public static enum Type {
        simple,
        withAdvancedOptions;

    }
}

