/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import qouteall.q_misc_util.dimension.DimId;

public class DimStackEntry {
    public ResourceKey<Level> dimension;
    public double scale = 1.0;
    public boolean flipped = false;
    public double horizontalRotation = 0.0;
    @Nullable
    public Integer topY = null;
    @Nullable
    public Integer bottomY = null;
    @Nullable
    public String bedrockReplacementStr = "minecraft:obsidian";

    public DimStackEntry(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public CompoundTag toNbt() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        compound.m_128347_("scale", this.scale);
        compound.m_128379_("flipped", this.flipped);
        compound.m_128347_("horizontalRotation", this.horizontalRotation);
        if (this.topY != null) {
            compound.m_128405_("topY", this.topY.intValue());
        }
        if (this.bottomY != null) {
            compound.m_128405_("bottomY", this.bottomY.intValue());
        }
        if (this.bedrockReplacementStr != null) {
            compound.m_128359_("bedrockReplacement", this.bedrockReplacementStr);
        }
        return compound;
    }

    public static DimStackEntry fromNbt(CompoundTag compound) {
        ResourceKey<Level> dimension = DimId.idToKey(compound.m_128461_("dimension"));
        DimStackEntry dimStackEntry = new DimStackEntry(dimension);
        dimStackEntry.scale = compound.m_128441_("scale") ? compound.m_128459_("scale") : 1.0;
        dimStackEntry.flipped = compound.m_128441_("flipped") ? compound.m_128471_("flipped") : false;
        dimStackEntry.horizontalRotation = compound.m_128459_("horizontalRotation");
        dimStackEntry.topY = compound.m_128441_("topY") ? Integer.valueOf(compound.m_128451_("topY")) : null;
        dimStackEntry.bottomY = compound.m_128441_("bottomY") ? Integer.valueOf(compound.m_128451_("bottomY")) : null;
        dimStackEntry.bedrockReplacementStr = compound.m_128441_("bedrockReplacement") ? compound.m_128461_("bedrockReplacement") : null;
        return dimStackEntry;
    }
}

