/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.peripheral.alternate_dimension.AlternateDimensions;
import qouteall.imm_ptl.peripheral.dim_stack.DimEntryWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntryEditScreen;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.SelectDimensionScreen;
import qouteall.q_misc_util.my_util.GuiHelper;

@OnlyIn(value=Dist.CLIENT)
public class DimStackScreen
extends Screen {
    @Nullable
    public final Screen parent;
    private final Button finishButton;
    private final Button toggleButton;
    private final Button addDimensionButton;
    private final Button removeDimensionButton;
    private final Button editButton;
    private final Button helpButton;
    private final Button loopButton;
    private final Button gravityModeButton;
    private int titleY;
    public boolean isEnabled = false;
    public final DimListWidget dimListWidget;
    public boolean loopEnabled = false;
    public boolean localGravityEnabled = false;
    public final Function<Screen, List<ResourceKey<Level>>> dimensionListSupplier;
    private final Consumer<DimStackInfo> finishCallback;

    public DimStackScreen(@javax.annotation.Nullable Screen parent, Function<Screen, List<ResourceKey<Level>>> dimensionListSupplier, Consumer<DimStackInfo> finishCallback) {
        super((Component)new TranslatableComponent("imm_ptl.altius_screen"));
        this.parent = parent;
        this.dimensionListSupplier = dimensionListSupplier;
        this.finishCallback = finishCallback;
        this.toggleButton = new Button(0, 0, 150, 20, (Component)new TranslatableComponent("imm_ptl.altius_toggle_false"), buttonWidget -> this.setEnabled(!this.isEnabled));
        this.loopButton = new Button(0, 0, 150, 20, (Component)new TranslatableComponent("imm_ptl.loop_disabled"), buttonWidget -> {
            this.loopEnabled = !this.loopEnabled;
            buttonWidget.m_93666_((Component)new TranslatableComponent(this.loopEnabled ? "imm_ptl.loop_enabled" : "imm_ptl.loop_disabled"));
        });
        this.gravityModeButton = new Button(0, 0, 150, 20, (Component)new TranslatableComponent("imm_ptl.dim_stack.gravity_transform_disabled"), buttonWidget -> {
            this.localGravityEnabled = !this.localGravityEnabled;
            buttonWidget.m_93666_((Component)new TranslatableComponent(this.localGravityEnabled ? "imm_ptl.dim_stack.gravity_transform_enabled" : "imm_ptl.dim_stack.gravity_transform_disabled"));
        });
        this.finishButton = new Button(0, 0, 72, 20, (Component)new TranslatableComponent("imm_ptl.finish"), buttonWidget -> {
            Minecraft.m_91087_().m_91152_(parent);
            finishCallback.accept(this.getDimStackInfo());
        });
        this.addDimensionButton = new Button(0, 0, 72, 20, (Component)new TranslatableComponent("imm_ptl.dim_stack_add"), buttonWidget -> this.onAddEntry());
        this.removeDimensionButton = new Button(0, 0, 72, 20, (Component)new TranslatableComponent("imm_ptl.dim_stack_remove"), buttonWidget -> this.onRemoveEntry());
        this.editButton = new Button(0, 0, 72, 20, (Component)new TranslatableComponent("imm_ptl.dim_stack_edit"), buttonWidget -> this.onEditEntry());
        this.dimListWidget = new DimListWidget(this.f_96543_, this.f_96544_, 100, 200, 50, this, DimListWidget.Type.mainDimensionList);
        Consumer<DimEntryWidget> callback = this.getElementSelectCallback();
        if (IPGlobal.enableAlternateDimensions) {
            this.dimListWidget.entryWidgets.add(this.createDimEntryWidget(AlternateDimensions.alternate5));
            this.dimListWidget.entryWidgets.add(this.createDimEntryWidget(AlternateDimensions.alternate1));
        }
        this.dimListWidget.entryWidgets.add(this.createDimEntryWidget((ResourceKey<Level>)Level.f_46428_));
        this.dimListWidget.entryWidgets.add(this.createDimEntryWidget((ResourceKey<Level>)Level.f_46429_));
        this.helpButton = DimStackScreen.createHelpButton(this);
    }

    public static Button createHelpButton(Screen parent) {
        return new Button(0, 0, 30, 20, (Component)new TextComponent("?"), button -> CHelper.openLinkConfirmScreen(parent, "https://qouteall.fun/immptl/wiki/Dimension-Stack"));
    }

    private DimEntryWidget createDimEntryWidget(ResourceKey<Level> dimension) {
        return new DimEntryWidget(dimension, this.dimListWidget, this.getElementSelectCallback(), DimEntryWidget.Type.withAdvancedOptions);
    }

    @javax.annotation.Nullable
    public DimStackInfo getDimStackInfo() {
        if (this.isEnabled) {
            return new DimStackInfo(this.dimListWidget.entryWidgets.stream().map(dimEntryWidget -> dimEntryWidget.entry).collect(Collectors.toList()), this.loopEnabled, this.localGravityEnabled);
        }
        return null;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)this.toggleButton);
        this.m_142416_((GuiEventListener)this.finishButton);
        this.m_142416_((GuiEventListener)this.addDimensionButton);
        this.m_142416_((GuiEventListener)this.removeDimensionButton);
        this.m_142416_((GuiEventListener)this.editButton);
        this.m_142416_((GuiEventListener)this.helpButton);
        this.m_142416_((GuiEventListener)this.loopButton);
        this.m_142416_((GuiEventListener)this.gravityModeButton);
        this.setEnabled(this.isEnabled);
        this.m_7787_((GuiEventListener)this.dimListWidget);
        this.dimListWidget.update();
        GuiHelper.layout(0, this.f_96544_, GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.helpButton.f_93620_ = this.f_96543_ - 50;
            this.helpButton.f_93621_ = from;
            this.helpButton.m_93674_(30);
        }), new GuiHelper.LayoutElement(true, 20, GuiHelper.combine(GuiHelper.layoutButtonVertically((AbstractWidget)this.toggleButton), GuiHelper.layoutButtonVertically((AbstractWidget)this.loopButton), GuiHelper.layoutButtonVertically((AbstractWidget)this.gravityModeButton))), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, (from, to) -> this.dimListWidget.m_93437_(this.f_96543_, this.f_96544_, from, to)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.finishButton.f_93621_ = from;
            this.addDimensionButton.f_93621_ = from;
            this.removeDimensionButton.f_93621_ = from;
            this.editButton.f_93621_ = from;
            GuiHelper.layout(0, this.f_96543_, GuiHelper.blankSpace(10), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.finishButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.addDimensionButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.removeDimensionButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.editButton)), GuiHelper.blankSpace(10));
        }), GuiHelper.blankSpace(5));
        GuiHelper.layout(0, this.f_96543_, GuiHelper.blankSpace(10), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.toggleButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 8, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.loopButton)), GuiHelper.blankSpace(5), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((AbstractWidget)this.gravityModeButton)), GuiHelper.blankSpace(10));
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private Consumer<DimEntryWidget> getElementSelectCallback() {
        return w -> this.dimListWidget.m_6987_((AbstractSelectionList.Entry)w);
    }

    public void m_6305_(PoseStack matrixStack, int mouseY, int i, float f) {
        this.m_7333_(matrixStack);
        if (this.isEnabled) {
            this.dimListWidget.m_6305_(matrixStack, mouseY, i, f);
        }
        super.m_6305_(matrixStack, mouseY, i, f);
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        textRenderer.m_92763_(matrixStack, this.f_96539_, 20.0f, 10.0f, -1);
    }

    private void setEnabled(boolean cond) {
        this.isEnabled = cond;
        if (this.isEnabled) {
            this.toggleButton.m_93666_((Component)new TranslatableComponent("imm_ptl.altius_toggle_true"));
        } else {
            this.toggleButton.m_93666_((Component)new TranslatableComponent("imm_ptl.altius_toggle_false"));
        }
        this.addDimensionButton.f_93624_ = this.isEnabled;
        this.removeDimensionButton.f_93624_ = this.isEnabled;
        this.editButton.f_93624_ = this.isEnabled;
        this.loopButton.f_93624_ = this.isEnabled;
        this.gravityModeButton.f_93624_ = this.isEnabled;
    }

    private void onAddEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        int position = selected == null ? 0 : this.dimListWidget.entryWidgets.indexOf((Object)selected);
        if (position < 0 || position > this.dimListWidget.entryWidgets.size()) {
            position = -1;
        }
        int insertingPosition = position + 1;
        Minecraft.m_91087_().m_91152_((Screen)new SelectDimensionScreen(this, dimensionType -> {
            this.dimListWidget.entryWidgets.add(insertingPosition, this.createDimEntryWidget((ResourceKey<Level>)dimensionType));
            this.removeDuplicate(insertingPosition);
            this.dimListWidget.update();
        }));
    }

    private void onRemoveEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        if (selected == null) {
            return;
        }
        int position = this.dimListWidget.entryWidgets.indexOf((Object)selected);
        if (position == -1) {
            return;
        }
        this.dimListWidget.entryWidgets.remove(position);
        this.dimListWidget.update();
    }

    private void onEditEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.m_93511_();
        if (selected == null) {
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new DimStackEntryEditScreen(this, selected));
    }

    private void removeDuplicate(int insertedIndex) {
        ResourceKey<Level> inserted = this.dimListWidget.entryWidgets.get((int)insertedIndex).dimension;
        for (int i = this.dimListWidget.entryWidgets.size() - 1; i >= 0; --i) {
            if (this.dimListWidget.entryWidgets.get((int)i).dimension != inserted || i == insertedIndex) continue;
            this.dimListWidget.entryWidgets.remove(i);
        }
    }
}

