/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.guide;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.SignalArged;

@OnlyIn(value=Dist.CLIENT)
public class IPGuide {
    public static final SignalArged<Portal> clientPortalSpawnSignal = new SignalArged();
    private static GuideInfo guideInfo = new GuideInfo();

    private static GuideInfo readFromFile() {
        File storageFile = IPGuide.getStorageFile();
        if (storageFile.exists()) {
            GuideInfo result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (GuideInfo)IPGlobal.gson.fromJson((Reader)fileReader, GuideInfo.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new GuideInfo();
            }
            if (result == null) {
                return new GuideInfo();
            }
            return result;
        }
        return new GuideInfo();
    }

    private static File getStorageFile() {
        return new File(Minecraft.m_91087_().f_91069_, "imm_ptl_state.json");
    }

    private static void writeToFile(GuideInfo guideInfo) {
        try (FileWriter fileWriter = new FileWriter(IPGuide.getStorageFile());){
            IPGlobal.gson.toJson((Object)guideInfo, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        guideInfo = IPGuide.readFromFile();
        clientPortalSpawnSignal.connect(p -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (!IPGuide.guideInfo.wikiInformed && player != null && player.m_7500_()) {
                IPGuide.guideInfo.wikiInformed = true;
                IPGuide.writeToFile(guideInfo);
                IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", (MutableComponent)new TranslatableComponent("imm_ptl.inform_wiki"));
            }
            if (!IPGuide.guideInfo.lagInformed && player != null) {
                IPGuide.guideInfo.lagInformed = true;
                IPGuide.writeToFile(guideInfo);
                IPGlobal.clientTaskList.addTask(MyTaskList.withDelay(100, () -> {
                    Minecraft.m_91087_().f_91065_.m_93051_(ChatType.SYSTEM, (Component)new TranslatableComponent("imm_ptl.about_lag"), Util.f_137441_);
                    return true;
                }));
            }
        });
    }

    public static void onClientPlacePortalHelper() {
        if (!IPGuide.guideInfo.portalHelperInformed) {
            IPGuide.guideInfo.portalHelperInformed = true;
            IPGuide.writeToFile(guideInfo);
            IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization#portal-helper-block", (MutableComponent)new TranslatableComponent("imm_ptl.inform_portal_helper"));
        }
    }

    private static void informWithURL(String link, MutableComponent text) {
        Minecraft.m_91087_().f_91065_.m_93051_(ChatType.SYSTEM, (Component)text.m_7220_((Component)McHelper.getLinkText(link)), Util.f_137441_);
    }

    public static class GuideInfo {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RemoteCallables {
        public static void showWiki() {
            IPGuide.informWithURL("https://qouteall.fun/immptl/wiki/Commands-Reference", (MutableComponent)new TextComponent(""));
        }
    }
}

