/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.mixin.IELevelStorageAccess_Misc;

public class MiscHelper {
    public static <T> MappedRegistry<T> filterAndCopyRegistry(MappedRegistry<T> registry, BiPredicate<ResourceKey<T>, T> predicate) {
        MappedRegistry newRegistry = new MappedRegistry(registry.m_123023_(), registry.m_7837_(), null);
        for (Map.Entry entry : registry.m_6579_()) {
            Object object = entry.getValue();
            ResourceKey key = (ResourceKey)entry.getKey();
            if (!predicate.test((ResourceKey<ResourceKey>)key, (ResourceKey)object)) continue;
            newRegistry.m_203505_(key, object, registry.m_6228_(object));
        }
        return newRegistry;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void executeOnRenderThread(Runnable runnable) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_18695_()) {
            runnable.run();
        } else {
            client.execute(runnable);
        }
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static void executeOnServerThread(Runnable runnable) {
        MinecraftServer server = MiscHelper.getServer();
        if (server.m_18695_()) {
            runnable.run();
        } else {
            server.execute(runnable);
        }
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static Path getWorldSavingDirectory() {
        MinecraftServer server = MiscHelper.getServer();
        Validate.notNull((Object)server);
        Path saveDir = ((IELevelStorageAccess_Misc)((IEMinecraftServer_Misc)server).ip_getStorageSource()).ip_getLevelPath();
        return saveDir;
    }
}

