/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimId;

public class DimsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dims").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"clone_dimension").then(Commands.m_82129_((String)"templateDimension", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"newDimensionID", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerLevel templateDimension = DimensionArgument.m_88808_((CommandContext)context, (String)"templateDimension");
            String newDimensionId = StringArgumentType.getString((CommandContext)context, (String)"newDimensionID");
            ResourceLocation newDimId = new ResourceLocation(newDimensionId);
            if (newDimId.m_135827_().equals("minecraft")) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Invalid namespace"));
                return 0;
            }
            DimsCommand.cloneDimension(templateDimension, Optional.empty(), newDimId);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Warning: the dynamic dimension feature is not yet stable now"), false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Dynamically added dimension %s".formatted(newDimensionId)), true);
            return 0;
        })).then(Commands.m_82129_((String)"newSeed", (ArgumentType)LongArgumentType.longArg()).executes(context -> {
            ServerLevel templateDimension = DimensionArgument.m_88808_((CommandContext)context, (String)"templateDimension");
            String newDimensionId = StringArgumentType.getString((CommandContext)context, (String)"newDimensionID");
            long newSeed = LongArgumentType.getLong((CommandContext)context, (String)"newSeed");
            ResourceLocation newDimId = new ResourceLocation(newDimensionId);
            if (newDimId.m_135827_().equals("minecraft")) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Invalid namespace"));
                return 0;
            }
            DimsCommand.cloneDimension(templateDimension, Optional.of(newSeed), newDimId);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Warning: the dynamic dimension feature is not yet stable now"), false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Dynamically added dimension %s with seed %s".formatted(newDimensionId, newSeed)), true);
            return 0;
        })))));
        builder.then(Commands.m_82127_((String)"remove_dimension").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ServerLevel dimension = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension");
            DimensionAPI.removeDimensionDynamically(dimension);
            DimensionAPI.deleteDimensionConfiguration((ResourceKey<Level>)dimension.m_46472_());
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Warning: the dynamic dimension feature is not yet stable now"), false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Dynamically removed dimension %s . Its world file is not yet deleted.".formatted(dimension.m_46472_().m_135782_())), true);
            return 0;
        })));
        dispatcher.register(builder);
    }

    private static void cloneDimension(ServerLevel templateDimension, Optional<Long> newSeed, ResourceLocation newDimId) {
        ChunkGenerator generator = templateDimension.m_7726_().m_8481_();
        if (newSeed.isPresent()) {
            generator = generator.m_6819_(newSeed.get().longValue());
        }
        DimensionAPI.addDimensionDynamically(newDimId, new LevelStem(templateDimension.m_204156_(), generator));
        DimensionAPI.saveDimensionConfiguration(DimId.idToKey(newDimId));
    }
}

