/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscGlobals;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.dimension.DimensionIdManagement;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.forge.events.ServerDimensionDynamicUpdateEvent;
import qouteall.q_misc_util.forge.networking.Dim_Sync;
import qouteall.q_misc_util.forge.networking.Message;
import qouteall.q_misc_util.mixin.dimension.IEWorldBorder;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.SignalArged;

public class DynamicDimensionsImpl {
    public static final SignalArged<ResourceKey<Level>> beforeRemovingDimensionSignal = new SignalArged();
    public static boolean isRemovingDimension = false;

    public static void init() {
    }

    public static void addDimensionDynamically(ResourceLocation dimensionId, LevelStem levelStem) {
        MinecraftServer server = MiscHelper.getServer();
        ResourceKey<Level> dimensionResourceKey = DimId.idToKey(dimensionId);
        Validate.isTrue((boolean)server.m_18695_());
        if (server.m_129880_(dimensionResourceKey) != null) {
            throw new RuntimeException("Dimension " + dimensionId + " already exists.");
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        WorldBorder worldBorder = overworld.m_6857_();
        Validate.notNull((Object)worldBorder);
        WorldData worldData = server.m_129910_();
        ServerLevelData serverLevelData = worldData.m_5996_();
        WorldGenSettings worldGenSettings = worldData.m_5961_();
        long seed = worldGenSettings.m_64619_();
        long obfuscatedSeed = BiomeManager.m_47877_((long)seed);
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, serverLevelData);
        ServerLevel newWorld = new ServerLevel(server, ((IEMinecraftServer_Misc)server).ip_getExecutor(), ((IEMinecraftServer_Misc)server).ip_getStorageSource(), (ServerLevelData)derivedLevelData, dimensionResourceKey, levelStem.m_204521_(), (ChunkProgressListener)new DummyProgressListener(), levelStem.m_63990_(), false, obfuscatedSeed, (List)ImmutableList.of(), false);
        worldBorder.m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
        ((IEMinecraftServer_Misc)server).ip_addDimensionToWorldMap(dimensionResourceKey, newWorld);
        worldBorder.m_61931_(serverLevelData.m_5813_());
        Helper.log("Added Dimension " + dimensionId);
        DimensionIdManagement.updateAndSaveServerDimIdRecord();
        Dim_Sync dimSyncPacket = new Dim_Sync();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            Message.sendToPlayer(dimSyncPacket, player);
        }
    }

    public static void removeDimensionDynamically(ServerLevel world) {
        MinecraftServer server = MiscHelper.getServer();
        Validate.isTrue((boolean)server.m_18695_());
        ResourceKey dimension = world.m_46472_();
        if (dimension == Level.f_46428_ || dimension == Level.f_46429_ || dimension == Level.f_46430_) {
            throw new RuntimeException();
        }
        Helper.log("Started Removing Dimension " + dimension.m_135782_());
        MiscGlobals.serverTaskList.addTask(MyTaskList.oneShotTask(() -> {
            beforeRemovingDimensionSignal.emit((ResourceKey<Level>)dimension);
            DynamicDimensionsImpl.evacuatePlayersFromDimension(world);
            long startTime = System.nanoTime();
            long lastLogTime = System.nanoTime();
            isRemovingDimension = true;
            ((IEMinecraftServer_Misc)server).ip_removeDimensionFromWorldMap((ResourceKey<Level>)dimension);
            try {
                while (world.m_7726_().f_8325_.m_201907_()) {
                    world.m_7726_().m_201915_();
                    world.m_7726_().m_201698_(() -> true, false);
                    world.m_7726_().m_8466_();
                    server.m_7245_();
                    if (System.nanoTime() - lastLogTime > Helper.secondToNano(1.0)) {
                        lastLogTime = System.nanoTime();
                        Helper.log("waiting for chunk tasks to finish");
                    }
                    if (System.nanoTime() - startTime > Helper.secondToNano(15.0)) {
                        Helper.err("Waited too long for chunk tasks");
                        break;
                    }
                    ((IEMinecraftServer_Misc)server).ip_waitUntilNextTick();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            isRemovingDimension = false;
            Helper.log("Finished chunk tasks in %f seconds".formatted(Helper.nanoToSecond(System.nanoTime() - startTime)));
            Helper.log("Chunk num:%d Has entities:%s".formatted(world.m_7726_().f_8325_.m_140394_(), world.m_8583_().iterator().hasNext()));
            server.m_129885_(false, true, false);
            try {
                world.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DynamicDimensionsImpl.resetWorldBorderListener(server);
            Helper.log("Successfully Removed Dimension " + dimension.m_135782_());
            Dim_Sync dimSyncPacket = new Dim_Sync();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                Message.sendToPlayer(dimSyncPacket, player);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ServerDimensionDynamicUpdateEvent(server.m_129784_()));
        }));
    }

    private static void resetWorldBorderListener(MinecraftServer server) {
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        WorldBorder worldBorder = overworld.m_6857_();
        List<BorderChangeListener> borderChangeListeners = ((IEWorldBorder)worldBorder).ip_getListeners();
        borderChangeListeners.clear();
        for (ServerLevel serverWorld : server.m_129785_()) {
            if (serverWorld == overworld) continue;
            worldBorder.m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(serverWorld.m_6857_()));
        }
        server.m_6846_().m_184209_(overworld);
    }

    private static void evacuatePlayersFromDimension(ServerLevel world) {
        MinecraftServer server = MiscHelper.getServer();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        List players = world.m_8795_(p -> true);
        BlockPos sharedSpawnPos = overworld.m_8900_();
        for (ServerPlayer player : players) {
            player.m_8999_(overworld, (double)sharedSpawnPos.m_123341_(), (double)sharedSpawnPos.m_123342_(), (double)sharedSpawnPos.m_123343_(), 0.0f, 0.0f);
            player.m_6352_((Component)new TextComponent("Teleported to spawn pos because dimension %s had been removed".formatted(world.m_46472_().m_135782_())), Util.f_137441_);
        }
    }

    private static class DummyProgressListener
    implements ChunkProgressListener {
        private DummyProgressListener() {
        }

        public void m_7647_(ChunkPos center) {
        }

        public void m_5511_(ChunkPos chunkPosition, @Nullable ChunkStatus newStatus) {
        }

        public void m_142611_() {
        }

        public void m_7646_() {
        }
    }
}

