/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.forge.networking;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimensionIdRecord;
import qouteall.q_misc_util.dimension.DimensionTypeSync;
import qouteall.q_misc_util.forge.events.ClientDimensionUpdateEvent;
import qouteall.q_misc_util.mixin.client.IEClientPacketListener_Misc;

public class Dim_Sync {
    private CompoundTag record;
    private CompoundTag typeMap;

    public Dim_Sync() {
        Validate.notNull((Object)DimensionIdRecord.serverRecord);
        this.record = DimensionIdRecord.recordToTag(DimensionIdRecord.serverRecord, dim -> MiscHelper.getServer().m_129880_(dim) != null);
        this.typeMap = DimensionTypeSync.createTagFromServerWorldInfo();
    }

    public Dim_Sync(FriendlyByteBuf buf) {
        this.record = buf.m_130260_();
        this.typeMap = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.record);
        buf.m_130079_(this.typeMap);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> Dim_Sync.processDimSync(this.record, this.typeMap, (ClientPacketListener)ctx.getNetworkManager().m_129538_()));
        ctx.setPacketHandled(true);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processDimSync(CompoundTag record, CompoundTag typeMap, ClientPacketListener packetListener) {
        DimensionIdRecord.clientRecord = DimensionIdRecord.tagToRecord(record);
        MiscHelper.executeOnRenderThread(() -> {
            DimensionTypeSync.acceptTypeMapData(typeMap);
            Helper.log("Received Dimension Int Id Sync");
            Helper.log("\n" + DimensionIdRecord.clientRecord);
            Set<ResourceKey<Level>> dimIdSet = DimensionIdRecord.clientRecord.getDimIdSet();
            ((IEClientPacketListener_Misc)packetListener).ip_setLevels(dimIdSet);
            MinecraftForge.EVENT_BUS.post((Event)new ClientDimensionUpdateEvent(dimIdSet));
        });
    }
}

