/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import qouteall.q_misc_util.Helper;

public class MyTaskList {
    private final ObjectList<MyTask> tasks = new ObjectArrayList();
    private final ObjectList<MyTask> tasksToAdd = new ObjectArrayList();

    public synchronized void addTask(MyTask task) {
        this.tasksToAdd.add((Object)task);
    }

    public synchronized void processTasks() {
        this.tasks.addAll(this.tasksToAdd);
        this.tasksToAdd.clear();
        Helper.removeIf(this.tasks, task -> {
            try {
                return task.runAndGetIsFinished();
            }
            catch (Throwable e) {
                Helper.err("Failed to process task " + task);
                e.printStackTrace();
                return true;
            }
        });
    }

    public synchronized void forceClearTasks() {
        this.tasks.clear();
        this.tasksToAdd.clear();
    }

    public static MyTask oneShotTask(Runnable runnable) {
        return () -> {
            runnable.run();
            return true;
        };
    }

    public static MyTask nullTask() {
        return () -> true;
    }

    public static MyTask chainTask(final MyTask a, final MyTask b) {
        return new MyTask(){
            boolean aFinished = false;

            @Override
            public boolean runAndGetIsFinished() {
                if (!this.aFinished) {
                    boolean finished = a.runAndGetIsFinished();
                    if (finished) {
                        this.aFinished = true;
                    } else {
                        return false;
                    }
                }
                return b.runAndGetIsFinished();
            }
        };
    }

    public static MyTask withDelay(final int iterations, final MyTask task) {
        return new MyTask(){
            private int counter;
            {
                this.counter = iterations;
            }

            @Override
            public boolean runAndGetIsFinished() {
                if (this.counter > 0) {
                    --this.counter;
                    return false;
                }
                return task.runAndGetIsFinished();
            }
        };
    }

    public static MyTask withCancelCondition(BooleanSupplier shouldCancel, MyTask task) {
        return () -> {
            if (shouldCancel.getAsBoolean()) {
                return true;
            }
            return task.runAndGetIsFinished();
        };
    }

    public static MyTask withDelayCondition(BooleanSupplier shouldDelay, MyTask task) {
        return () -> {
            if (shouldDelay.getAsBoolean()) {
                return false;
            }
            return task.runAndGetIsFinished();
        };
    }

    public static MyTask withRetryNumberLimit(final int retryNumberLimit, final MyTask task, final Runnable onLimitReached) {
        return new MyTask(){
            private int retryNumber = 0;

            @Override
            public boolean runAndGetIsFinished() {
                boolean finished = task.runAndGetIsFinished();
                if (finished) {
                    return true;
                }
                ++this.retryNumber;
                if (this.retryNumber > retryNumberLimit) {
                    onLimitReached.run();
                    return true;
                }
                return false;
            }
        };
    }

    public static MyTask withInterval(final int interval, final MyTask task) {
        return new MyTask(){
            int i = 0;

            @Override
            public boolean runAndGetIsFinished() {
                if (this.i < interval) {
                    ++this.i;
                    return false;
                }
                this.i = 0;
                return task.runAndGetIsFinished();
            }
        };
    }

    public static MyTask withMacroLifecycle(final Runnable beginAction, final Runnable endAction, final MyTask task) {
        return new MyTask(){
            boolean began = false;

            @Override
            public boolean runAndGetIsFinished() {
                boolean finished;
                if (!this.began) {
                    this.began = true;
                    beginAction.run();
                }
                if (finished = task.runAndGetIsFinished()) {
                    endAction.run();
                }
                return finished;
            }
        };
    }

    public static MyTask withMicroLifecycle(Runnable beginAction, Runnable endAction, MyTask task) {
        return () -> {
            beginAction.run();
            boolean finished = task.runAndGetIsFinished();
            endAction.run();
            return finished;
        };
    }

    public static MyTask chainTasks(Iterator<MyTask> tasks) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(tasks);
        return () -> {
            MyTask curr;
            boolean finished;
            if (peekingIterator.hasNext() && (finished = (curr = (MyTask)peekingIterator.peek()).runAndGetIsFinished())) {
                peekingIterator.next();
            }
            return !peekingIterator.hasNext();
        };
    }

    public static MyTask repeat(int number, Supplier<MyTask> taskConstructor) {
        return MyTaskList.chainTasks(Stream.generate(taskConstructor).limit(number).iterator());
    }

    public static interface MyTask {
        public boolean runAndGetIsFinished();
    }
}

