/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.QuarkModule;

public abstract class QuarkButtonBlock
extends ButtonBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkButtonBlock(String regname, QuarkModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(false, properties);
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)regname);
        if (creativeTab != null) {
            RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)creativeTab);
        }
    }

    @Nonnull
    protected abstract SoundEvent m_5722_(boolean var1);

    public abstract int m_51115_();

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkButtonBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }
}

