/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.PrintStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.AbstractConfigElement;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.obj.BooleanObject;
import vazkii.quark.base.client.config.obj.DoubleObject;
import vazkii.quark.base.client.config.obj.IntegerObject;
import vazkii.quark.base.client.config.obj.ListObject;
import vazkii.quark.base.client.config.obj.StringObject;
import vazkii.quark.base.client.config.screen.widgets.IWidgetProvider;

public abstract class ConfigObject<T>
extends AbstractConfigElement
implements IConfigObject<T>,
IWidgetProvider {
    public final T defaultObj;
    public final Predicate<Object> restriction;
    protected final Supplier<T> objectGetter;
    protected final String displayName;
    protected T loadedObj;
    protected T currentObj;
    protected final ForgeConfigSpec.ConfigValue<T> configValue;

    public ConfigObject(ForgeConfigSpec.ConfigValue<T> value, String comment, T defaultObj, Supplier<T> objGetter, Predicate<Object> restriction, ConfigCategory parent) {
        super(ConfigObject.getDefaultName(value), comment, parent);
        this.defaultObj = defaultObj;
        this.objectGetter = objGetter;
        this.restriction = restriction;
        this.configValue = value;
        this.displayName = this.name.contains(" ") ? String.format("\"%s\"", this.name) : this.name;
    }

    public static <T> IConfigObject<T> create(ForgeConfigSpec.ConfigValue<T> value, String comment, T defaultObj, Supplier<T> objGetter, Predicate<Object> restriction, ConfigCategory parent) {
        if (defaultObj instanceof Boolean) {
            return new BooleanObject(value, comment, (Boolean)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof String) {
            return new StringObject(value, comment, (String)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof Integer) {
            return new IntegerObject(value, comment, (Integer)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof Double) {
            return new DoubleObject(value, comment, (Double)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof List) {
            return new ListObject(value, comment, (List)defaultObj, objGetter, restriction, parent);
        }
        throw new IllegalArgumentException(defaultObj + " isn't a valid config object.");
    }

    @Override
    public String getGuiDisplayName() {
        return this.name;
    }

    @Override
    public void refresh() {
        this.currentObj = this.objectGetter.get();
        this.loadedObj = this.currentObj;
    }

    @Override
    public void clean() {
        this.loadedObj = this.currentObj;
    }

    @Override
    public void save() {
        this.configValue.set(this.currentObj);
    }

    @Override
    public void reset(boolean hard) {
        this.setCurrentObj(hard ? this.defaultObj : this.loadedObj);
    }

    @Override
    public T getCurrentObj() {
        return this.currentObj;
    }

    @Override
    public void setCurrentObj(T currentObj) {
        this.currentObj = currentObj;
        this.parent.updateDirty();
    }

    @Override
    public String getSubtitle() {
        Object str = this.currentObj.toString();
        if (((String)str).length() > 30) {
            str = ((String)str).substring(0, 27) + "...";
        }
        return str;
    }

    @Override
    public boolean isDirty() {
        return this.wouldBeDirty(this.currentObj);
    }

    public boolean wouldBeDirty(T testObject) {
        return !this.loadedObj.equals(testObject);
    }

    @Override
    public void print(String pad, PrintStream out) {
        super.print(pad, out);
        String objStr = this.computeObjectString();
        out.printf("%s%s = %s%n", pad, this.displayName, objStr);
    }

    protected String computeObjectString() {
        return this.currentObj.toString();
    }

    @Override
    public int compareTo(@Nonnull IConfigElement o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof IConfigObject)) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    private static String getDefaultName(ForgeConfigSpec.ConfigValue<?> value) {
        List path = value.getPath();
        return (String)path.get(path.size() - 1);
    }
}

