/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.item;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.DistExecutor;

public class BEWLRBlockItem
extends BlockItem {
    @Nullable
    private final Supplier<LazyBEWLR> bewlr;

    public BEWLRBlockItem(Block block, Item.Properties properties, Supplier<Callable<LazyBEWLR>> bewlr) {
        super(block, properties);
        LazyBEWLR lazyBEWLR = (LazyBEWLR)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, bewlr);
        this.bewlr = lazyBEWLR == null ? null : () -> lazyBEWLR;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                LazyBEWLR lazyBEWLR = BEWLRBlockItem.this.bewlr.get();
                BlockEntityWithoutLevelRenderer value = lazyBEWLR.value;
                if (value != null) {
                    return value;
                }
                return lazyBEWLR.cache(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            }
        });
    }

    public static final class LazyBEWLR {
        private final BiFunction<BlockEntityRenderDispatcher, EntityModelSet, BlockEntityWithoutLevelRenderer> cacheFunction;
        public BlockEntityWithoutLevelRenderer value;

        public LazyBEWLR(BiFunction<BlockEntityRenderDispatcher, EntityModelSet, BlockEntityWithoutLevelRenderer> cacheFunction) {
            this.cacheFunction = cacheFunction;
        }

        public BlockEntityWithoutLevelRenderer cache(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
            this.value = this.cacheFunction.apply(dispatcher, modelSet);
            return this.value;
        }
    }
}

