/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public final class ModdedBiomeSource
extends BiomeSource {
    public static final Codec<BiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("original_biome_source").forGetter(thisBiomeSource -> {
        BiomeSource biomeSource;
        if (thisBiomeSource instanceof ModdedBiomeSource) {
            ModdedBiomeSource moddedBiomeSource = (ModdedBiomeSource)((Object)((Object)thisBiomeSource));
            biomeSource = moddedBiomeSource.originalSource;
        } else {
            biomeSource = thisBiomeSource;
        }
        return biomeSource;
    })).apply((Applicative)instance, biomeSource -> biomeSource));
    private final Registry<Biome> biomes;
    private final BiomeSource originalSource;
    private final ThreadLocal<SlicesCache> slicesCache = ThreadLocal.withInitial(SlicesCache::new);
    private final ModdedBiomeSlice[] slices;
    private final int totalWeight;
    private final int size;
    private final Biome originalSourceMarker;
    private final long slicesSeed;
    private final long slicesZoomSeed;
    private final long obfuscatedSeed;

    public ModdedBiomeSource(Registry<Biome> biomes, BiomeSource originalSource, ArrayList<ModdedBiomeSlice> slices, int size, long seed, long dimensionSeedModifier) {
        this(biomes, originalSource, slices, size + Mth.m_14165_((double)(Math.log(slices.size()) / Math.log(2.0))), seed, seed + 1791510900L + dimensionSeedModifier, seed - 771160217L + dimensionSeedModifier);
    }

    public ModdedBiomeSource(Registry<Biome> biomes, BiomeSource originalSource, ArrayList<ModdedBiomeSlice> slices, int size, long seed, long slicesSeed, long slicesZoomSeed) {
        super(new ArrayList<Holder<Biome>>(ModdedBiomeSource.combinePossibleBiomes(originalSource.m_207840_(), slices, biomes)));
        this.biomes = biomes;
        this.originalSource = originalSource;
        this.slices = slices.toArray(new ModdedBiomeSlice[0]);
        this.totalWeight = Stream.of(this.slices).map(ModdedBiomeSlice::weight).reduce(0, Integer::sum);
        this.size = size;
        this.originalSourceMarker = (Biome)biomes.m_123013_(BlueprintBiomes.ORIGINAL_SOURCE_MARKER.getKey());
        this.slicesSeed = slicesSeed;
        this.slicesZoomSeed = slicesZoomSeed;
        this.obfuscatedSeed = BiomeManager.m_47877_((long)seed);
    }

    private static Set<Holder<Biome>> combinePossibleBiomes(Set<Holder<Biome>> possibleBiomes, ArrayList<ModdedBiomeSlice> slices, Registry<Biome> registry) {
        HashSet<Holder<Biome>> biomes = new HashSet<Holder<Biome>>(possibleBiomes);
        for (ModdedBiomeSlice slice : slices) {
            biomes.addAll(slice.provider().getAdditionalPossibleBiomes(registry));
        }
        return biomes;
    }

    public void m_207301_(List<String> strings, BlockPos pos, Climate.Sampler sampler) {
        BiomeSource original = this.originalSource;
        original.m_207301_(strings, pos, sampler);
        if (!(original instanceof ModdedBiomeSource)) {
            strings.add("Modded Biome Slice: " + this.getSlice(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123343_())).name());
        }
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long seed) {
        return new ModdedBiomeSource(this.biomes, this.originalSource, new ArrayList<ModdedBiomeSlice>(List.of(this.slices)), this.size, seed, this.slicesSeed, this.slicesZoomSeed);
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        Holder biome = this.getSlice(x, z).provider().getNoiseBiome(x, y, z, sampler, this.originalSource, this.biomes);
        return biome.m_203334_() == this.originalSourceMarker ? this.originalSource.m_203407_(x, y, z, sampler) : biome;
    }

    private ModdedBiomeSlice getSlice(int x, int z) {
        return this.slicesCache.get().getSlice(this, x, z);
    }

    private ModdedBiomeSlice getSliceUncached(int x, int z) {
        int cordX = QuartPos.m_175402_((int)x);
        int cordZ = QuartPos.m_175402_((int)z);
        long slicesZoomSeed = this.slicesZoomSeed;
        for (int i = 0; i < this.size; ++i) {
            int cellPosX = cordX & 1;
            int cellPosZ = cordZ & 1;
            int cellX = cordX >> 1;
            int cellZ = cordZ >> 1;
            if (cellPosX == 0 && cellPosZ == 0) {
                cordX = cellX;
                cordZ = cellZ;
                continue;
            }
            if (cellPosX == 0) {
                cordZ = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 2) == 0 ? cellZ : cordZ + 1 >> 1;
                cordX = cellX;
                continue;
            }
            if (cellPosZ == 0) {
                cordX = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 2) == 0 ? cellX : cordX + 1 >> 1;
                cordZ = cellZ;
                continue;
            }
            int offsetChoice = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 4);
            if (offsetChoice == 0) {
                cordX = cellX;
                cordZ = cellZ;
                continue;
            }
            if (offsetChoice == 1) {
                cordX = cordX + 1 >> 1;
                cordZ = cellZ;
                continue;
            }
            if (offsetChoice == 2) {
                cordX = cellX;
                cordZ = cordZ + 1 >> 1;
                continue;
            }
            cordX = cordX + 1 >> 1;
            cordZ = cordZ + 1 >> 1;
        }
        int randomWeight = ModdedBiomeSource.nextInt(this.slicesSeed, cordX, cordZ, this.totalWeight);
        for (ModdedBiomeSlice slice : this.slices) {
            if ((randomWeight -= slice.weight()) >= 0) continue;
            return slice;
        }
        return this.slices[0];
    }

    public ModdedBiomeSlice getSliceWithVanillaZoom(int x, int y, int z) {
        int i = x - 2;
        int j = y - 2;
        int k = z - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int l1 = 0; l1 < 8; ++l1) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = ModdedBiomeSource.getFiddledDistance(this.obfuscatedSeed, i2, j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1, k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1, d4 = flag ? d0 : d0 - 1.0, d5 = flag1 ? d1 : d1 - 1.0, d6 = flag2 ? d2 : d2 - 1.0);
            if (!(d3 > d7)) continue;
            k1 = l1;
            d3 = d7;
        }
        int l2 = (k1 & 4) == 0 ? l : l + 1;
        int j3 = (k1 & 1) == 0 ? j1 : j1 + 1;
        return this.getSlice(l2, j3);
    }

    private static double getFiddledDistance(long p_186680_, int p_186681_, int p_186682_, int p_186683_, double p_186684_, double p_186685_, double p_186686_) {
        long $$7 = LinearCongruentialGenerator.m_13972_((long)p_186680_, (long)p_186681_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186682_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186683_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186681_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186682_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186683_);
        double d0 = ModdedBiomeSource.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186680_);
        double d1 = ModdedBiomeSource.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186680_);
        double d2 = ModdedBiomeSource.getFiddle($$7);
        return Mth.m_144952_((double)(p_186686_ + d2)) + Mth.m_144952_((double)(p_186685_ + d1)) + Mth.m_144952_((double)(p_186684_ + d0));
    }

    private static double getFiddle(long p_186690_) {
        double d0 = (double)Math.floorMod(p_186690_ >> 24, 1024) / 1024.0;
        return (d0 - 0.5) * 0.9;
    }

    private static int nextInt(long seed, int x, int z, int bound) {
        long next = LinearCongruentialGenerator.m_13972_((long)seed, (long)x);
        next = LinearCongruentialGenerator.m_13972_((long)next, (long)z);
        next = LinearCongruentialGenerator.m_13972_((long)next, (long)x);
        return Math.floorMod(LinearCongruentialGenerator.m_13972_((long)next, (long)z) >> 24, bound);
    }

    private static class SlicesCache {
        private final long[] lastXZHashes = new long[256];
        private final ModdedBiomeSlice[] slices;

        private SlicesCache() {
            Arrays.fill(this.lastXZHashes, -9223372036854775807L);
            this.slices = new ModdedBiomeSlice[256];
        }

        private ModdedBiomeSlice getSlice(ModdedBiomeSource biomeSource, int x, int z) {
            long xzHash;
            int zIndex;
            int xIndex = SectionPos.m_123207_((int)x);
            int index = 16 * xIndex + (zIndex = SectionPos.m_123207_((int)z));
            if (this.lastXZHashes[index] != (xzHash = ChunkPos.m_45589_((int)x, (int)z))) {
                this.lastXZHashes[index] = xzHash;
                this.slices[index] = biomeSource.getSliceUncached(x, z);
                return this.slices[index];
            }
            return this.slices[index];
        }
    }
}

