/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete;

import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.villainy.sweetconcrete.blocks.ConcreteButtonBlock;
import org.villainy.sweetconcrete.blocks.ConcreteCakeBlock;
import org.villainy.sweetconcrete.blocks.ConcreteFenceBlock;
import org.villainy.sweetconcrete.blocks.ConcreteFenceGateBlock;
import org.villainy.sweetconcrete.blocks.ConcreteLadderBlock;
import org.villainy.sweetconcrete.blocks.ConcreteLeverBlock;
import org.villainy.sweetconcrete.blocks.ConcretePowderLayerBlock;
import org.villainy.sweetconcrete.blocks.ConcretePressurePlateBlock;
import org.villainy.sweetconcrete.blocks.ConcreteSlabBlock;
import org.villainy.sweetconcrete.blocks.ConcreteStairsBlock;
import org.villainy.sweetconcrete.blocks.ConcreteVerticalSlabBlock;
import org.villainy.sweetconcrete.blocks.ConcreteWallBlock;
import org.villainy.sweetconcrete.config.ConfigHelper;
import org.villainy.sweetconcrete.config.ConfigHolder;
import org.villainy.sweetconcrete.config.FlagRecipeCondition;
import org.villainy.sweetconcrete.items.helper.BlockItemHelper;
import org.villainy.sweetconcrete.proxy.ClientProxy;
import org.villainy.sweetconcrete.proxy.CommonProxy;
import org.villainy.sweetconcrete.proxy.IProxy;

@Mod(value="sweetconcrete")
public class SweetConcrete {
    public static final String MODID = "sweetconcrete";
    public static final String CHANNEL = "sweetconcrete";
    private static final String PROTOCOL_VERSION = "1.0";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOG = LogManager.getLogger();

    public SweetConcrete() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.COMMON_SPEC);
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(new ResourceLocation("sweetconcrete", "flag")));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            Stream.of(DyeColor.values()).forEach(dyeColor -> {
                ConcreteSlabBlock slab = new ConcreteSlabBlock((DyeColor)dyeColor);
                blockRegistry.register((IForgeRegistryEntry)slab);
                blockRegistry.register((IForgeRegistryEntry)new ConcreteStairsBlock((DyeColor)dyeColor, slab.m_49966_()));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteWallBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteButtonBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcretePressurePlateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteFenceBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteFenceGateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteLadderBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteLeverBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteVerticalSlabBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcretePowderLayerBlock((DyeColor)dyeColor));
            });
            blockRegistry.register((IForgeRegistryEntry)new ConcreteCakeBlock());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            ConcreteSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40749_)));
            ConcreteStairsBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40749_)));
            ConcreteWallBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40750_)));
            ConcreteButtonBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40751_)));
            ConcretePressurePlateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40751_)));
            ConcreteFenceBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40750_)));
            ConcreteFenceGateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40750_)));
            ConcreteLadderBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40750_)));
            ConcreteCakeBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40755_)));
            ConcreteLeverBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40751_)));
            ConcreteVerticalSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40749_)));
            ConcretePowderLayerBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, CreativeModeTab.f_40749_)));
        }

        @SubscribeEvent
        public static void onModConfigEvent(ModConfigEvent.Loading event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
                ConfigHelper.bakeCommon(config);
            }
        }
    }
}

