/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.villainy.sweetconcrete.config.SweetConcreteConfig;
import org.villainy.sweetconcrete.objectholders.ConcretePowderLayerBlocks;

public class ConcretePowderLayerBlock
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public ConcretePowderLayerBlock(DyeColor dyeColor) {
        super(BlockBehaviour.Properties.m_60941_((Material)Material.f_76317_, (DyeColor)dyeColor).m_60978_(0.5f).m_60918_(SoundType.f_56746_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        this.setRegistryName(dyeColor.m_7912_() + "_concrete_powder_layer");
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.m_61143_((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)LAYERS) - 1];
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        Block block = blockstate.m_60734_();
        if (block != Blocks.f_50719_ && block != Blocks.f_50135_) {
            return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP) || block == this && (Integer)blockstate.m_61143_((Property)LAYERS) == 8;
        }
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)levelAccessor, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, levelAccessor, currentPos, facingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (useContext.m_43722_().m_41720_() == this.m_5456_() && i < 8) {
            if (useContext.m_7058_()) {
                return useContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() == this) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == CreativeModeTab.f_40754_ || this.isEnabled()) {
            super.m_49811_(group, items);
        }
    }

    public static Stream<Block> allBlocks() {
        return Stream.of(new Block[]{ConcretePowderLayerBlocks.WHITE, ConcretePowderLayerBlocks.ORANGE, ConcretePowderLayerBlocks.MAGENTA, ConcretePowderLayerBlocks.LIGHT_BLUE, ConcretePowderLayerBlocks.YELLOW, ConcretePowderLayerBlocks.LIME, ConcretePowderLayerBlocks.PINK, ConcretePowderLayerBlocks.GRAY, ConcretePowderLayerBlocks.LIGHT_GRAY, ConcretePowderLayerBlocks.CYAN, ConcretePowderLayerBlocks.PURPLE, ConcretePowderLayerBlocks.BLUE, ConcretePowderLayerBlocks.BROWN, ConcretePowderLayerBlocks.GREEN, ConcretePowderLayerBlocks.RED, ConcretePowderLayerBlocks.BLACK});
    }

    private boolean isEnabled() {
        return SweetConcreteConfig.enablePowderLayers;
    }
}

