/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CageLampBlock
extends Block
implements SimpleWaterloggedBlock {
    public final DustParticleOptions particle;
    protected static final VoxelShape AABB_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    protected static final VoxelShape AABB_DOWN = Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_EAST = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_WEST = Block.m_49796_((double)8.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)8.0);
    protected static final VoxelShape AABB_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0, (double)16.0);

    public CageLampBlock(BlockBehaviour.Properties props, Vector3f color) {
        super(props);
        this.particle = new DustParticleOptions(color, 0.3f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61441_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)ctx.m_43719_())).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_46616_(ctx.m_8083_(), ctx.m_43719_())))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> AABB_UP;
            case Direction.DOWN -> AABB_DOWN;
            case Direction.EAST -> AABB_EAST;
            case Direction.WEST -> AABB_WEST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.NORTH -> AABB_NORTH;
        };
    }

    public static boolean shouldBeLit(BlockState state, Level level, BlockPos pos) {
        Direction attach = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61441_) ^ level.m_46616_(pos.m_142300_(attach), attach);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean bool) {
        Direction face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (pos.m_142300_(face.m_122424_()).equals((Object)neighborPos)) {
            BlockState blockState = this.toggle(state, level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState next = this.toggle((BlockState)state.m_61122_((Property)BlockStateProperties.f_61441_), level, pos);
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        float pitch = (Boolean)next.m_61143_((Property)BlockStateProperties.f_61441_) != false ? 0.6f : 0.5f;
        level.m_5594_((Player)null, pos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, pitch);
        return InteractionResult.CONSUME;
    }

    private BlockState toggle(BlockState state, Level level, BlockPos pos) {
        if (level.f_46443_) {
            this.makeParticle(state, (LevelAccessor)level, pos);
        }
        BlockState next = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(CageLampBlock.shouldBeLit(state, level, pos)));
        level.m_7731_(pos, next, 3);
        return next;
    }

    private void makeParticle(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        float x = (float)pos.m_123341_() + 0.5f + 0.1f * (float)direction.m_122429_();
        float y = (float)pos.m_123342_() + 0.5f + 0.1f * (float)direction.m_122430_();
        float z = (float)pos.m_123343_() + 0.5f + 0.1f * (float)direction.m_122431_();
        level.m_7106_((ParticleOptions)this.particle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_}).m_61104_(new Property[]{BlockStateProperties.f_61441_}).m_61104_(new Property[]{BlockStateProperties.f_61372_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }
}

