/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.source.FileIndex;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.error.ErrorBuilder;
import com.jozufozu.flywheel.core.source.error.ErrorReporter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class FileIndexImpl
implements FileIndex {
    public final List<SourceFile> files = new ArrayList<SourceFile>();

    @Override
    public int getFileID(SourceFile sourceFile) {
        int i = this.files.indexOf(sourceFile);
        if (i != -1) {
            return i;
        }
        int size = this.files.size();
        this.files.add(sourceFile);
        return size;
    }

    @Override
    public SourceFile getFile(int fileId) {
        return this.files.get(fileId);
    }

    public void printShaderInfoLog(String source, String log, ResourceLocation name) {
        List<String> lines = log.lines().toList();
        boolean needsSourceDump = false;
        StringBuilder errors = new StringBuilder();
        for (String line : lines) {
            ErrorBuilder builder = this.parseCompilerError(line);
            if (builder != null) {
                errors.append(builder.build());
                continue;
            }
            errors.append(line).append('\n');
            needsSourceDump = true;
        }
        Backend.LOGGER.error("Errors compiling '" + name + "': \n" + errors);
        if (needsSourceDump) {
            ErrorReporter.printLines(source);
        }
    }

    @Nullable
    private ErrorBuilder parseCompilerError(String line) {
        try {
            ErrorBuilder error = ErrorBuilder.fromLogLine(this, line);
            if (error != null) {
                return error;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

